/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.javabean.plugins.jaxb;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.javabean.plugins.jaxb.AbstractParameter;
import org.jboss.javabean.plugins.jaxb.Constructor;
import org.jboss.javabean.plugins.jaxb.Parameter;
import org.jboss.javabean.plugins.jaxb.Property;
import org.jboss.joinpoint.plugins.Config;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.jboss.xb.spi.BeanAdapter;
import org.jboss.xb.spi.BeanAdapterFactory;

public class JavaBean
extends BeanAdapter {
    private static Configuration configuration;
    private String className;
    private Constructor constructor;
    private Property[] properties;

    static synchronized void init() {
        if (configuration == null) {
            configuration = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

                @Override
                public Configuration run() {
                    return new PropertyConfiguration(System.getProperties());
                }
            });
            PropertyEditors.init();
        }
    }

    public JavaBean(BeanAdapterFactory beanAdapterFactory) {
        super(beanAdapterFactory);
    }

    public String getClassName() {
        return this.className;
    }

    @XmlAttribute(name="class")
    public void setClassName(String className) {
        this.className = className;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    @XmlElement(name="property")
    public void setProperties(Property[] properties) {
        this.properties = properties;
    }

    @Override
    @XmlTransient
    public Object getValue() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Object result;
            BeanInfo beanInfo = null;
            if (this.className != null) {
                beanInfo = configuration.getBeanInfo(this.className, cl);
            }
            if (this.constructor != null) {
                String factoryMethod = this.constructor.getFactoryMethod();
                if (factoryMethod != null) {
                    String factoryClass = this.constructor.getFactoryClass();
                    BeanInfo factoryBeanInfo = beanInfo;
                    if (factoryClass != null) {
                        factoryBeanInfo = configuration.getBeanInfo(factoryClass, cl);
                    }
                    if (factoryBeanInfo == null) {
                        throw new IllegalArgumentException("Missing className or factoryClass: " + this);
                    }
                    String[] signature = this.getSignature(this.constructor.getParameters());
                    MethodInfo factory = Config.findMethodInfo((ClassInfo)factoryBeanInfo.getClassInfo(), (String)factoryMethod, (String[])signature, (boolean)true, (boolean)true);
                    Object[] params = this.getParams(this.constructor.getParameters(), factory.getParameterTypes());
                    result = factory.invoke(null, params);
                } else {
                    if (beanInfo == null) {
                        throw new IllegalArgumentException("Missing className: " + this);
                    }
                    String[] signature = this.getSignature(this.constructor.getParameters());
                    ConstructorInfo constructorInfo = Config.findConstructorInfo((ClassInfo)beanInfo.getClassInfo(), (String[])signature);
                    Object[] params = this.getParams(this.constructor.getParameters(), constructorInfo.getParameterTypes());
                    result = constructorInfo.newInstance(params);
                }
            } else {
                if (beanInfo == null) {
                    throw new IllegalArgumentException("Missing className: " + this);
                }
                result = beanInfo.newInstance();
            }
            if (beanInfo == null) {
                beanInfo = configuration.getBeanInfo(result.getClass());
            }
            if (this.properties != null) {
                for (Property property : this.properties) {
                    Object value = property.getValue();
                    if (value == null) continue;
                    PropertyInfo propertyInfo = beanInfo.getProperty(property.getName());
                    TypeInfo typeInfo = propertyInfo.getType();
                    String type = property.getType();
                    if (type != null) {
                        typeInfo = configuration.getTypeInfo(type, cl);
                    }
                    value = typeInfo.convertValue(value, false);
                    propertyInfo.set(result, value);
                }
            }
            return result;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error constructing javabean", t);
        }
    }

    @Override
    public Object get(PropertyInfo propertyInfo) throws Throwable {
        return propertyInfo.get((Object)this);
    }

    @Override
    public void set(PropertyInfo propertyInfo, Object child) throws Throwable {
        propertyInfo.set((Object)this, child);
    }

    protected String[] getSignature(List<? extends AbstractParameter> parameters) {
        if (parameters == null) {
            return new String[0];
        }
        String[] signature = new String[parameters.size()];
        for (int i = 0; i < signature.length; ++i) {
            AbstractParameter parameter = parameters.get(i);
            if (!(parameter instanceof Parameter)) continue;
            signature[i] = ((Parameter)parameter).getParamType();
        }
        return signature;
    }

    protected Object[] getParams(List<? extends AbstractParameter> parameters, TypeInfo[] paramTypes) {
        if (parameters == null) {
            return new String[0];
        }
        Object[] params = new Object[parameters.size()];
        for (int i = 0; i < params.length; ++i) {
            AbstractParameter parameter = parameters.get(i);
            Object value = parameter.getValue();
            try {
                TypeInfo parameterType = paramTypes[i];
                String type = parameter.getType();
                if (type != null) {
                    parameterType = parameterType.getTypeInfoFactory().getTypeInfo(type, null);
                }
                params[i] = parameterType.convertValue(value, false);
                continue;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error converting parameter #" + i + " value=" + value + " to type " + paramTypes[i]);
            }
        }
        return params;
    }

    static {
        JavaBean.init();
    }
}

