/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.util;

import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UrlUtility {
    @NotNull
    public static String addParametersToQueryString(@NotNull String url, @Nullable Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return url;
        }
        StringBuilder updatedURL = new StringBuilder(url);
        if (updatedURL.lastIndexOf("?") == -1) {
            updatedURL.append('?');
        } else {
            char lastChar = updatedURL.charAt(updatedURL.length() - 1);
            if (lastChar != '&' && lastChar != '?') {
                updatedURL.append('&');
            }
        }
        Set<String> paramNames = parameters.keySet();
        for (String paramName : paramNames) {
            updatedURL.append(paramName);
            updatedURL.append('=');
            updatedURL.append(parameters.get(paramName));
            updatedURL.append('&');
        }
        updatedURL.deleteCharAt(updatedURL.length() - 1);
        return updatedURL.toString();
    }
}

