/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.URLHandlerSupportImpl;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.URLHandlerSupport;
import org.osgi.framework.BundleContext;

final class URLHandlerPlugin
extends AbstractIntegrationService<URLHandlerSupport> {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();

    URLHandlerPlugin() {
        super(IntegrationServices.URL_HANDLER_PLUGIN);
        URLHandlerSupportImpl.initURLHandlerSupport();
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<URLHandlerSupport> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, this.injectedBundleManager);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedSystemContext);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext startContext) throws StartException {
        super.start(startContext);
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        ((URLHandlerSupport)this.getValue()).start(systemContext);
    }

    @Override
    protected URLHandlerSupport createServiceValue(StartContext startContext) throws StartException {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        return new URLHandlerSupportImpl(bundleManager);
    }

    public void stop(StopContext context) {
        ((URLHandlerSupport)this.getValue()).stop();
    }
}

