/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.List;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.spi.AbstractBundleWiring;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractEnvironment;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;

public final class EnvironmentImpl
extends AbstractEnvironment
implements XEnvironment {
    private final LockManager lockManager;

    public EnvironmentImpl(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installResources(XResource ... resources) {
        for (XResource res : resources) {
            if (!(res instanceof XBundleRevision)) {
                throw FrameworkMessages.MESSAGES.unsupportedResourceType(res);
            }
            XBundleRevision brev = (XBundleRevision)res;
            if (brev.getBundle() != null) continue;
            throw FrameworkMessages.MESSAGES.cannotObtainBundleFromResource(res);
        }
        LockManager.LockContext lockContext = null;
        try {
            FrameworkWiringLock wireLock = this.lockManager.getItemForType(FrameworkWiringLock.class);
            lockContext = this.lockManager.lockItems(LockManager.Method.INSTALL, this.getLockableItems(wireLock, resources));
            super.installResources(resources);
            this.lockManager.unlockItems(lockContext);
        }
        catch (Throwable throwable) {
            this.lockManager.unlockItems(lockContext);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void uninstallResources(XResource ... resources) {
        LockManager.LockContext lockContext = null;
        try {
            FrameworkWiringLock wireLock = this.lockManager.getItemForType(FrameworkWiringLock.class);
            lockContext = this.lockManager.lockItems(LockManager.Method.UNINSTALL, this.getLockableItems(wireLock, resources));
            super.uninstallResources(resources);
            this.lockManager.unlockItems(lockContext);
        }
        catch (Throwable throwable) {
            this.lockManager.unlockItems(lockContext);
            throw throwable;
        }
    }

    public Wiring createWiring(XResource res, List<Wire> required, List<Wire> provided) {
        XBundleRevision brev = (XBundleRevision)res;
        return new AbstractBundleWiring(brev, required, provided);
    }

    private LockManager.LockableItem[] getLockableItems(LockManager.LockableItem item, XResource ... resources) {
        ArrayList<LockManager.LockableItem> items = new ArrayList<LockManager.LockableItem>();
        items.add(item);
        if (resources != null) {
            for (XResource res : resources) {
                XBundleRevision brev = (XBundleRevision)res;
                if (!(brev.getBundle() instanceof LockManager.LockableItem)) continue;
                items.add((LockManager.LockableItem)brev.getBundle());
            }
        }
        return items.toArray(new LockManager.LockableItem[items.size()]);
    }
}

