/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.transport;

import java.io.StringReader;
import java.net.URI;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.scout.registry.RegistryException;
import org.apache.ws.scout.transport.Transport;
import org.apache.ws.scout.transport.TransportException;
import org.apache.ws.scout.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SaajTransport
implements Transport {
    public static final String UDDI_V2_NAMESPACE = "urn:uddi-org:api_v2";
    private static Log log = LogFactory.getLog(SaajTransport.class);

    @Override
    public Element send(Element request, URI endpointURL) throws TransportException {
        if (log.isDebugEnabled()) {
            String requestMessage = XMLUtils.convertNodeToXMLString(request);
            log.debug((Object)("Request message: %s\n%s" + endpointURL + ":" + requestMessage));
        }
        Element response = null;
        try {
            SOAPMessage message = this.createSOAPMessage(request);
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = soapConnectionFactory.createConnection();
            SOAPMessage soapResponse = connection.call(message, (Object)endpointURL.toURL());
            SOAPBody soapBody = soapResponse.getSOAPBody();
            boolean hasFault = soapBody.hasFault();
            if (hasFault) {
                SOAPFault soapFault = soapBody.getFault();
                String faultStr = soapFault.getFaultCode() + "::" + soapFault.getFaultString();
                throw new RegistryException(faultStr);
            }
            response = this.getFirstChildElement((Element)soapBody);
        }
        catch (Exception ex) {
            log.error((Object)("Exception::" + ex.getMessage()), (Throwable)ex);
            throw new TransportException(ex);
        }
        if (log.isDebugEnabled()) {
            String responseMessage = XMLUtils.convertNodeToXMLString(response);
            log.debug((Object)("Response message: %s" + responseMessage));
        }
        return response;
    }

    @Override
    public String send(String request, URI endpointURL) throws TransportException {
        Element reqEl = SaajTransport.getElement(request);
        Element respEl = this.send(reqEl, endpointURL);
        return XMLUtils.convertNodeToXMLString(respEl);
    }

    private SOAPMessage createSOAPMessage(Element elem) throws Exception {
        String prefix = "";
        MessageFactory msgFactory = MessageFactory.newInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPMessage message = msgFactory.createMessage();
        message.getSOAPHeader().detachNode();
        SOAPPart soapPart = message.getSOAPPart();
        SOAPBody soapBody = soapPart.getEnvelope().getBody();
        Name bodyName = factory.createName(elem.getNodeName(), prefix, UDDI_V2_NAMESPACE);
        SOAPBodyElement bodyElement = soapBody.addBodyElement(bodyName);
        bodyElement.addNamespaceDeclaration(prefix, UDDI_V2_NAMESPACE);
        this.appendAttributes((SOAPElement)bodyElement, elem.getAttributes(), factory);
        this.appendElements((SOAPElement)bodyElement, elem.getChildNodes(), factory);
        return message;
    }

    private void appendAttributes(SOAPElement bodyElement, NamedNodeMap nnm, SOAPFactory factory) throws SOAPException {
        int len = nnm != null ? nnm.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            Node n = nnm.item(i);
            String nodename = n.getNodeName();
            String nodevalue = n.getNodeValue();
            if ("xmlns".equals(nodename) || nodename.startsWith("xmlns:")) continue;
            if ("xml:lang".equals(nodename)) {
                Name xmlLang = factory.createName("lang", "xml", "");
                bodyElement.addAttribute(xmlLang, nodevalue);
                continue;
            }
            bodyElement.addAttribute(factory.createName(nodename), nodevalue);
        }
    }

    private void appendElements(SOAPElement bodyElement, NodeList nlist, SOAPFactory factory) throws SOAPException {
        String prefix = "";
        int len = nlist != null ? nlist.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            int nodeType;
            Node node = nlist.item(i);
            int n = nodeType = node != null ? (int)node.getNodeType() : -100;
            if (1 == nodeType) {
                Element el = (Element)node;
                Name name = factory.createName(el.getNodeName(), prefix, UDDI_V2_NAMESPACE);
                SOAPElement attachedEl = bodyElement.addChildElement(name);
                this.appendAttributes(attachedEl, el.getAttributes(), factory);
                this.appendElements(attachedEl, el.getChildNodes(), factory);
                continue;
            }
            if (nodeType != 3) continue;
            bodyElement.addTextNode(node.getNodeValue());
        }
    }

    private static Element getElement(String xmlFrag) {
        Document doc = null;
        Element reqElement = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(xmlFrag)));
            reqElement = doc.getDocumentElement();
        }
        catch (Exception ex) {
            log.error((Object)("Exception:" + ex.getMessage()), (Throwable)ex);
        }
        return reqElement;
    }

    private Element getFirstChildElement(Element el) {
        return this.getFirstChildElement(el, null);
    }

    private Element getFirstChildElement(Element el, String tagName) {
        Element childEl = null;
        NodeList nlist = el != null ? el.getChildNodes() : null;
        int len = nlist != null ? nlist.getLength() : 0;
        for (int i = 0; childEl == null && i < len; ++i) {
            Node node = nlist.item(i);
            if (node.getNodeType() != 1 || tagName != null && !tagName.equals(node.getLocalName())) continue;
            childEl = (Element)node;
        }
        if (log.isDebugEnabled()) {
            String responseObtained = XMLUtils.convertNodeToXMLString(childEl);
            log.debug((Object)("Response obtained: %s" + responseObtained));
        }
        return childEl;
    }
}

