/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry.infomodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.LocalizedString;
import org.apache.ws.scout.registry.infomodel.LocalizedStringImpl;

public class InternationalStringImpl
implements InternationalString {
    private final Map<MapKey, LocalizedString> map = new HashMap<MapKey, LocalizedString>();

    public InternationalStringImpl() {
    }

    public InternationalStringImpl(String str) {
        Locale locale = Locale.getDefault();
        this.map.put(new MapKey(locale, "UTF-8"), new LocalizedStringImpl(locale, str, "UTF-8"));
    }

    public InternationalStringImpl(Locale locale, String str, String charsetName) {
        MapKey mapKey = new MapKey(locale, charsetName);
        this.map.put(mapKey, new LocalizedStringImpl(locale, str, charsetName));
    }

    public void addLocalizedString(LocalizedString localizedString) throws JAXRException {
        MapKey mapKey = new MapKey(localizedString);
        this.map.put(mapKey, localizedString);
    }

    public void addLocalizedStrings(Collection collection) throws JAXRException {
        for (LocalizedString localizedString : collection) {
            this.map.put(new MapKey(localizedString), localizedString);
        }
    }

    public Collection<LocalizedString> getLocalizedStrings() throws JAXRException {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public String getValue() throws JAXRException {
        return this.getValue(Locale.getDefault());
    }

    public void setValue(String str) throws JAXRException {
        this.setValue(Locale.getDefault(), str);
    }

    public String getValue(Locale locale) throws JAXRException {
        LocalizedString localizedString = this.map.get(new MapKey(locale, "UTF-8"));
        return localizedString != null ? localizedString.getValue() : null;
    }

    public void setValue(Locale locale, String value) throws JAXRException {
        this.map.put(new MapKey(locale, "UTF-8"), new LocalizedStringImpl(locale, value, "UTF-8"));
    }

    public void removeLocalizedString(LocalizedString localizedString) throws JAXRException {
        this.map.remove(new MapKey(localizedString));
    }

    public void removeLocalizedStrings(Collection collection) throws JAXRException {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            this.removeLocalizedString((LocalizedString)i.next());
        }
    }

    public LocalizedString getLocalizedString(Locale locale, String charset) throws JAXRException {
        return this.map.get(new MapKey(locale, charset));
    }

    private static class MapKey {
        private final Locale locale;
        private final String charsetName;

        public MapKey(Locale locale, String charsetName) {
            this.locale = locale;
            this.charsetName = charsetName;
        }

        public MapKey(LocalizedString localizedString) throws JAXRException {
            this.locale = localizedString.getLocale();
            this.charsetName = localizedString.getCharsetName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MapKey)) {
                return false;
            }
            MapKey mapKey = (MapKey)o;
            if (!this.charsetName.equals(mapKey.charsetName)) {
                return false;
            }
            return this.locale.equals(mapKey.locale);
        }

        public int hashCode() {
            int result = this.locale.hashCode();
            result = 29 * result + this.charsetName.hashCode();
            return result;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(32);
            buf.append('[').append(this.locale).append(',').append(this.charsetName).append(']');
            return buf.toString();
        }
    }
}

