/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.vfs.VirtualFile;
import org.rhq.cassandra.schema.UpdateFile;

class UpdateFolder {
    private final Log log = LogFactory.getLog(UpdateFolder.class);
    private final String folder;
    private final List<UpdateFile> updateFiles;

    public UpdateFolder(String folder) throws Exception {
        this.folder = folder;
        this.updateFiles = this.loadUpdateFiles();
    }

    public String getFolder() {
        return this.folder;
    }

    public void removeAppliedUpdates(int currentVersion) {
        int version;
        List<UpdateFile> updateFiles = this.getUpdateFiles();
        while (!updateFiles.isEmpty() && (version = updateFiles.get(0).extractVersion()) <= currentVersion) {
            updateFiles.remove(0);
        }
    }

    public List<UpdateFile> getUpdateFiles() {
        return this.updateFiles;
    }

    public int getLatestVersion() {
        if (this.updateFiles != null && this.updateFiles.size() > 0) {
            return this.updateFiles.get(this.updateFiles.size() - 1).extractVersion();
        }
        return 0;
    }

    private List<UpdateFile> loadUpdateFiles() throws Exception {
        ArrayList<UpdateFile> files = new ArrayList<UpdateFile>();
        InputStream stream = null;
        try {
            URL resourceFolderURL = this.getClass().getClassLoader().getResource(this.folder);
            if (resourceFolderURL.getProtocol().equals("file")) {
                String updateFile;
                stream = this.getClass().getClassLoader().getResourceAsStream(this.folder);
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                while ((updateFile = reader.readLine()) != null) {
                    files.add(new UpdateFile(this.folder + "/" + updateFile));
                }
            } else if (resourceFolderURL.getProtocol().equals("jar")) {
                URL jarURL = this.getClass().getClassLoader().getResources(this.folder).nextElement();
                JarURLConnection jarURLCon = (JarURLConnection)jarURL.openConnection();
                JarFile jarFile = jarURLCon.getJarFile();
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement().getName();
                    if (!entry.startsWith(this.folder) || entry.equals(this.folder) || entry.equals(this.folder + "/")) continue;
                    files.add(new UpdateFile(entry));
                }
            } else if (resourceFolderURL.getProtocol().equals("vfs")) {
                URLConnection conn = resourceFolderURL.openConnection();
                VirtualFile virtualFolder = (VirtualFile)conn.getContent();
                for (VirtualFile virtualChild : virtualFolder.getChildren()) {
                    if (virtualChild.isDirectory()) continue;
                    files.add(new UpdateFile(virtualChild.getPathNameRelativeTo(virtualFolder.getParent())));
                }
            } else {
                throw new RuntimeException("The URL protocol [" + resourceFolderURL.getProtocol() + "] is not " + "supported");
            }
            Collections.sort(files, new Comparator<UpdateFile>(){

                @Override
                public int compare(UpdateFile o1, UpdateFile o2) {
                    return o1.compareTo(o2);
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)"Error reading the list of update files.", (Throwable)e);
            throw e;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    this.log.error((Object)"Error closing the stream with the list of update files.", (Throwable)e);
                    throw e;
                }
            }
        }
        return files;
    }
}

