/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Hours;
import org.joda.time.ReadableInstant;
import org.rhq.cassandra.schema.DateRanges;
import org.rhq.cassandra.schema.ReplaceIndex;

public class Replace412Index {
    private static final Log log = LogFactory.getLog(Replace412Index.class);
    private static final int NUM_PARTITIONS = 10;
    private static final int PAGE_SIZE = Integer.parseInt(System.getProperty("rhq.metrics.index.page-size", "2500"));
    private Session session;
    private PreparedStatement find412IndexEntries;
    private PreparedStatement find412IndexEntriesAfterScheduleId;
    private PreparedStatement updateNewIndex;

    public Replace412Index(Session session) {
        this.session = session;
    }

    public void execute(DateRanges dateRanges) {
        this.initPreparedStatements();
        DateTime startDay = dateRanges.sixHourStartTime;
        this.updateRawIndex(dateRanges.rawStartTime, dateRanges.rawEndTime, startDay);
        this.update1HourIndex(dateRanges.oneHourStartTime, dateRanges.oneHourEndTime, startDay);
        this.update6HourIndex(dateRanges.sixHourStartTime, dateRanges.sixHourEndTime, startDay);
        this.dropTables("rhq.metrics_cache", "rhq.metrics_cache_index");
    }

    private void initPreparedStatements() {
        this.find412IndexEntries = this.session.prepare("SELECT day, start_schedule_id, schedule_ids FROM rhq.metrics_cache_index WHERE bucket = ? AND partition = 0 AND day = ? AND collection_time_slice = ? LIMIT " + PAGE_SIZE);
        this.find412IndexEntriesAfterScheduleId = this.session.prepare("SELECT day, start_schedule_id, schedule_ids FROM rhq.metrics_cache_index WHERE bucket = ? AND partition = 0 AND day = ? AND collection_time_slice = ? AND start_schedule_id > ? LIMIT " + PAGE_SIZE);
        this.updateNewIndex = this.session.prepare("INSERT INTO rhq.metrics_idx (bucket, partition, time, schedule_id) VALUES (?, ?, ?, ?)");
    }

    private void updateRawIndex(DateTime start, DateTime end, DateTime startDay) {
        log.info((Object)"Updating raw index");
        this.updateIndex("raw_metrics", "raw", startDay, start, end, Hours.ONE.toStandardDuration());
    }

    private void update1HourIndex(DateTime start, DateTime end, DateTime startDay) {
        log.info((Object)"Updating one_hour index");
        this.updateIndex("one_hour_metrics", "one_hour", startDay, start, end, Hours.SIX.toStandardDuration());
    }

    private void update6HourIndex(DateTime start, DateTime end, DateTime startDay) {
        log.info((Object)"Updating six_hour index");
        this.updateIndex("six_hour_metrics", "six_hour", startDay, start, end, Days.ONE.toStandardDuration());
    }

    private void updateIndex(String oldBucket, String newBucket, DateTime startDay, DateTime start, DateTime end, Duration timeSlice) {
        DateTime time = start;
        BoundStatement statement = this.find412IndexEntries.bind(new Object[]{oldBucket, startDay.toDate(), start.toDate()});
        ResultSet resultSet = this.session.execute((Query)statement);
        DateTime day = startDay;
        int startScheduleId = 0;
        int count = 0;
        int partition = 0;
        do {
            for (Row row : resultSet) {
                day = new DateTime((Object)row.getDate(0));
                startScheduleId = row.getInt(1);
                Set scheduleIds = row.getSet(2, Integer.class);
                ++count;
                for (Integer scheduleId : scheduleIds) {
                    partition = scheduleId % 10;
                    this.session.execute((Query)this.updateNewIndex.bind(new Object[]{newBucket, partition, ReplaceIndex.getUTCTimeSlice(time, timeSlice).toDate(), scheduleId}));
                }
            }
            if (count < PAGE_SIZE) {
                DateTime tempDay;
                if ((time = ReplaceIndex.plusDSTAware(time, timeSlice)).equals((Object)(tempDay = ReplaceIndex.plusDSTAware(day, Days.ONE.toStandardDuration())))) {
                    day = ReplaceIndex.plusDSTAware(day, Days.ONE.toStandardDuration());
                }
                statement = this.find412IndexEntries.bind(new Object[]{oldBucket, day.toDate(), time.toDate()});
            } else {
                statement = this.find412IndexEntriesAfterScheduleId.bind(new Object[]{oldBucket, day.toDate(), time.toDate(), startScheduleId});
            }
            count = 0;
            resultSet = this.session.execute((Query)statement);
        } while (!time.isAfter((ReadableInstant)end));
    }

    private void dropTables(String ... tables) {
        for (String table : tables) {
            log.info((Object)("Dropping table " + table));
            this.session.execute("DROP table " + table);
        }
    }
}

