/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.util.Collections;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.platform.ProcessComponent;
import org.rhq.plugins.platform.ProcessComponentConfig;

public class ProcessDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        return Collections.emptySet();
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext context) throws InvalidPluginConfigurationException {
        String resourceDescription;
        String resourceKey;
        ProcessInfo processInfo;
        ProcessComponentConfig processComponentConfig = ProcessComponentConfig.createProcessComponentConfig(pluginConfig);
        try {
            processInfo = ProcessComponent.findProcess(processComponentConfig, context.getSystemInformation());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to manually add process Resource based on plugin config: " + pluginConfig.toString(true), e);
        }
        switch (processComponentConfig.getType()) {
            case pidFile: {
                resourceKey = processComponentConfig.getPidFile();
                resourceDescription = processInfo.getBaseName() + " process with PID file [" + resourceKey + "]";
                break;
            }
            case piql: {
                resourceKey = processComponentConfig.getPiql();
                resourceDescription = processInfo.getBaseName() + " process with PIQL expression [" + resourceKey + "]";
                break;
            }
            default: {
                throw new InvalidPluginConfigurationException("Unknown type: " + (Object)((Object)processComponentConfig.getType()));
            }
        }
        return new DiscoveredResourceDetails(context.getResourceType(), resourceKey, processInfo.getBaseName(), null, resourceDescription, pluginConfig, processInfo);
    }
}

