/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;

class ProcessComponentConfig {
    private Type type;
    private String pidFile;
    private String piql;
    private boolean fullProcessTree;

    private ProcessComponentConfig(Type type, String pidFile, String piql, boolean fullProcessTree) {
        this.type = type;
        this.pidFile = pidFile;
        this.piql = piql;
        this.fullProcessTree = fullProcessTree;
    }

    static ProcessComponentConfig createProcessComponentConfig(Configuration pluginConfig) throws InvalidPluginConfigurationException {
        boolean fullProcessTree;
        String piql;
        String pidFile;
        Type type;
        try {
            type = Type.valueOf(pluginConfig.getSimpleValue("type", "pidFile"));
            pidFile = pluginConfig.getSimpleValue("pidFile", null);
            piql = pluginConfig.getSimpleValue("piql", null);
            fullProcessTree = pluginConfig.getSimple("fullProcessTree").getBooleanValue();
        }
        catch (Exception e) {
            throw new InvalidPluginConfigurationException((Throwable)e);
        }
        if (type == Type.pidFile && (pidFile == null || pidFile.length() == 0)) {
            throw new InvalidPluginConfigurationException("Missing pidfile");
        }
        if (type == Type.piql && (piql == null || piql.length() == 0)) {
            throw new InvalidPluginConfigurationException("Missing process query");
        }
        return new ProcessComponentConfig(type, pidFile, piql, fullProcessTree);
    }

    Type getType() {
        return this.type;
    }

    String getPidFile() {
        return this.pidFile;
    }

    String getPiql() {
        return this.piql;
    }

    boolean isFullProcessTree() {
        return this.fullProcessTree;
    }

    static enum Type {
        pidFile,
        piql;

    }
}

