/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.system.AggregateProcessInfo;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.platform.ProcessComponentConfig;

public class ProcessComponent
implements ResourceComponent,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(ProcessComponent.class);
    private static final String PROCESS_METRIC_PREFIX = "Process.";
    private ResourceContext resourceContext;
    private ProcessComponentConfig processComponentConfig;
    private ProcessInfo process;

    public void start(ResourceContext resourceContext) throws Exception {
        this.resourceContext = resourceContext;
        this.processComponentConfig = ProcessComponentConfig.createProcessComponentConfig(resourceContext.getPluginConfiguration());
    }

    public void stop() {
        this.resourceContext = null;
        this.processComponentConfig = null;
        this.process = null;
    }

    public AvailabilityType getAvailability() {
        try {
            ProcessInfo.ProcessInfoSnapshot snapshot = this.getFreshSnapshot();
            return snapshot != null && snapshot.isRunning() ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to get process info", (Throwable)e);
            }
            return AvailabilityType.DOWN;
        }
    }

    private ProcessInfo.ProcessInfoSnapshot getFreshSnapshot() throws Exception {
        ProcessInfo.ProcessInfoSnapshot snapshot;
        ProcessInfo.ProcessInfoSnapshot processInfoSnapshot = snapshot = this.process == null ? null : this.process.freshSnapshot();
        if (snapshot == null || !snapshot.isRunning()) {
            this.process = ProcessComponent.findProcess(this.processComponentConfig, this.resourceContext.getSystemInformation());
            snapshot = this.process == null ? null : this.process.priorSnaphot();
        }
        return snapshot;
    }

    static ProcessInfo findProcess(ProcessComponentConfig processComponentConfig, SystemInfo systemInfo) throws Exception {
        long pid;
        switch (processComponentConfig.getType()) {
            case pidFile: {
                pid = ProcessComponent.getPidFromPidFile(processComponentConfig);
                break;
            }
            case piql: {
                pid = ProcessComponent.getPidFromPiqlExpression(processComponentConfig, systemInfo);
                break;
            }
            default: {
                throw new InvalidPluginConfigurationException("Unknown type: " + (Object)((Object)processComponentConfig.getType()));
            }
        }
        if (processComponentConfig.isFullProcessTree()) {
            return new AggregateProcessInfo(pid);
        }
        return new ProcessInfo(pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getPidFromPidFile(ProcessComponentConfig processComponentConfig) throws IOException {
        File file = new File(processComponentConfig.getPidFile());
        if (file.canRead()) {
            FileInputStream fis = new FileInputStream(file);
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(fis));
                long l = Long.parseLong(r.readLine());
                return l;
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception ignore) {}
            }
        }
        throw new FileNotFoundException("pidfile [" + processComponentConfig.getPidFile() + "] does not exist or is not allowed to be read. full path=" + file.getAbsolutePath());
    }

    private static long getPidFromPiqlExpression(ProcessComponentConfig processComponentConfig, SystemInfo systemInfo) throws Exception {
        List processes = systemInfo.getProcesses(processComponentConfig.getPiql());
        if (processes != null && processes.size() == 1) {
            return ((ProcessInfo)processes.get(0)).getPid();
        }
        throw new Exception("process query [" + processComponentConfig.getPiql() + "] did not return a single process: " + processes);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        ProcessInfo.ProcessInfoSnapshot snapshot;
        try {
            snapshot = this.getFreshSnapshot();
            if (snapshot == null || !snapshot.isRunning()) {
                return;
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to get process info", (Throwable)e);
            }
            return;
        }
        for (MeasurementScheduleRequest request : metrics) {
            StringTokenizer propertyTokenizer;
            String propertyName = request.getName();
            if (!propertyName.startsWith(PROCESS_METRIC_PREFIX) || !(propertyTokenizer = new StringTokenizer(propertyName = propertyName.substring(PROCESS_METRIC_PREFIX.length()), ".")).hasMoreTokens()) continue;
            String category = propertyTokenizer.nextToken();
            if (!propertyTokenizer.hasMoreTokens()) continue;
            String subcategory = propertyTokenizer.nextToken();
            if (category.equals("cpu")) {
                CpuMetricGatherer cpuMetricGatherer = this.processComponentConfig.isFullProcessTree() ? new AggregateProcessCpuMetricGatherer((AggregateProcessInfo)this.process) : new ProcessCpuMetricGatherer(snapshot);
                this.addCpuMetric(subcategory, report, request, cpuMetricGatherer);
                continue;
            }
            if (category.equals("memory")) {
                MemoryMetricGatherer memoryMetricGatherer = this.processComponentConfig.isFullProcessTree() ? new AggregateProcessMemoryMetricGatherer((AggregateProcessInfo)this.process) : new ProcessMemoryMetricGatherer(snapshot);
                this.addMemoryMetric(subcategory, report, request, memoryMetricGatherer);
                continue;
            }
            if (!category.equals("fileDescriptor")) continue;
            FileDescriptorMetricGatherer fileDescriptorMetricGatherer = this.processComponentConfig.isFullProcessTree() ? new AggregateProcessFileDescriptorMetricGatherer((AggregateProcessInfo)this.process) : new ProcessFileDescriptorMetricGatherer(snapshot);
            this.addFileDescriptorMetric(subcategory, report, request, fileDescriptorMetricGatherer);
        }
    }

    private void addCpuMetric(String element, MeasurementReport report, MeasurementScheduleRequest request, CpuMetricGatherer cpuMetricGatherer) {
        if (element.equals("user")) {
            report.addData(new MeasurementDataNumeric(request, cpuMetricGatherer.getUser()));
        } else if (element.equals("sys")) {
            report.addData(new MeasurementDataNumeric(request, cpuMetricGatherer.getSys()));
        } else if (element.equals("percent")) {
            report.addData(new MeasurementDataNumeric(request, cpuMetricGatherer.getPercent()));
        }
    }

    private void addMemoryMetric(String element, MeasurementReport report, MeasurementScheduleRequest request, MemoryMetricGatherer memoryMetricGatherer) {
        if (element.equals("resident")) {
            report.addData(new MeasurementDataNumeric(request, memoryMetricGatherer.getResident()));
        } else if (element.equals("size")) {
            report.addData(new MeasurementDataNumeric(request, memoryMetricGatherer.getSize()));
        }
    }

    private void addFileDescriptorMetric(String element, MeasurementReport report, MeasurementScheduleRequest request, FileDescriptorMetricGatherer fileDescriptorMetricGatherer) {
        if (element.equals("total")) {
            report.addData(new MeasurementDataNumeric(request, fileDescriptorMetricGatherer.getTotal()));
        }
    }

    @Deprecated
    protected static ProcessInfo getProcessForConfiguration(Configuration pluginConfig, SystemInfo systemInfo) throws Exception {
        return ProcessComponent.findProcess(ProcessComponentConfig.createProcessComponentConfig(pluginConfig), systemInfo);
    }

    private static class AggregateProcessFileDescriptorMetricGatherer
    implements FileDescriptorMetricGatherer {
        AggregateProcessInfo aggregateProcessInfo;

        AggregateProcessFileDescriptorMetricGatherer(AggregateProcessInfo aggregateProcessInfo) {
            this.aggregateProcessInfo = aggregateProcessInfo;
        }

        @Override
        public Double getTotal() {
            return this.aggregateProcessInfo.getAggregateFileDescriptor().getTotal();
        }
    }

    private static class ProcessFileDescriptorMetricGatherer
    implements FileDescriptorMetricGatherer {
        ProcessInfo.ProcessInfoSnapshot snapshot;

        ProcessFileDescriptorMetricGatherer(ProcessInfo.ProcessInfoSnapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public Double getTotal() {
            return this.snapshot.getFileDescriptor().getTotal();
        }
    }

    private static interface FileDescriptorMetricGatherer {
        public Double getTotal();
    }

    private static class AggregateProcessMemoryMetricGatherer
    implements MemoryMetricGatherer {
        AggregateProcessInfo aggregateProcessInfo;

        AggregateProcessMemoryMetricGatherer(AggregateProcessInfo aggregateProcessInfo) {
            this.aggregateProcessInfo = aggregateProcessInfo;
        }

        @Override
        public Double getResident() {
            return this.aggregateProcessInfo.getAggregateMemory().getResident();
        }

        @Override
        public Double getSize() {
            return this.aggregateProcessInfo.getAggregateMemory().getSize();
        }
    }

    private static class ProcessMemoryMetricGatherer
    implements MemoryMetricGatherer {
        ProcessInfo.ProcessInfoSnapshot snapshot;

        ProcessMemoryMetricGatherer(ProcessInfo.ProcessInfoSnapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public Double getResident() {
            return this.snapshot.getMemory().getResident();
        }

        @Override
        public Double getSize() {
            return this.snapshot.getMemory().getSize();
        }
    }

    private static interface MemoryMetricGatherer {
        public Double getResident();

        public Double getSize();
    }

    private static class AggregateProcessCpuMetricGatherer
    implements CpuMetricGatherer {
        AggregateProcessInfo aggregateProcessInfo;

        AggregateProcessCpuMetricGatherer(AggregateProcessInfo aggregateProcessInfo) {
            this.aggregateProcessInfo = aggregateProcessInfo;
        }

        @Override
        public Double getUser() {
            return this.aggregateProcessInfo.getAggregateCpu().getUser();
        }

        @Override
        public Double getSys() {
            return this.aggregateProcessInfo.getAggregateCpu().getSys();
        }

        @Override
        public Double getPercent() {
            return this.aggregateProcessInfo.getAggregateCpu().getPercent();
        }
    }

    private static class ProcessCpuMetricGatherer
    implements CpuMetricGatherer {
        ProcessInfo.ProcessInfoSnapshot snapshot;

        ProcessCpuMetricGatherer(ProcessInfo.ProcessInfoSnapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public Double getUser() {
            return this.snapshot.getCpu().getUser();
        }

        @Override
        public Double getSys() {
            return this.snapshot.getCpu().getSys();
        }

        @Override
        public Double getPercent() {
            return this.snapshot.getCpu().getPercent();
        }
    }

    private static interface CpuMetricGatherer {
        public Double getUser();

        public Double getSys();

        public Double getPercent();
    }
}

