/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.model.ResourceAccessControlUtil;

class RootResourceIterator<T> {
    private final ResourceAccessControlUtil accessControlUtil;
    private final Resource rootResource;
    private final ResourceAction<T> action;

    RootResourceIterator(ResourceAccessControlUtil accessControlUtil, Resource rootResource, ResourceAction<T> action) {
        this.accessControlUtil = accessControlUtil;
        this.rootResource = rootResource;
        this.action = action;
    }

    T iterate() {
        this.doIterate(this.rootResource, PathAddress.EMPTY_ADDRESS);
        return this.action.getResult();
    }

    private void doIterate(Resource current, PathAddress address) {
        boolean handleChildren = false;
        if (this.accessControlUtil.getResourceAccess(address, false).isAccessibleResource()) {
            handleChildren = this.action.onResource(address);
        }
        if (handleChildren) {
            for (String type : current.getChildTypes()) {
                if (!current.hasChildren(type)) continue;
                for (Resource.ResourceEntry entry : current.getChildren(type)) {
                    PathElement pathElement = entry.getPathElement();
                    Resource child = current.getChild(pathElement);
                    PathAddress childAddress = address.append(new PathElement[]{pathElement});
                    this.doIterate(child, childAddress);
                }
            }
        }
    }

    static interface ResourceAction<T> {
        public boolean onResource(PathAddress var1);

        public T getResult();
    }
}

