/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications;

import java.util.Map;
import org.rhq.enterprise.communications.ServiceContainer;
import org.rhq.enterprise.communications.ServiceContainerMetricsMBean;
import org.rhq.enterprise.communications.command.server.CommandProcessor;
import org.rhq.enterprise.communications.command.server.CommandProcessorMetrics;

public class ServiceContainerMetrics
implements ServiceContainerMetricsMBean {
    private CommandProcessor commandProcessor;
    private ServiceContainer serviceContainer;

    public ServiceContainerMetrics(ServiceContainer service_container, CommandProcessor command_processor) {
        this.serviceContainer = service_container;
        this.commandProcessor = command_processor;
    }

    @Override
    public void clear() {
        this.commandProcessor.getCommandProcessorMetrics().clear();
    }

    @Override
    public long getNumberSuccessfulCommandsReceived() {
        return this.commandProcessor.getCommandProcessorMetrics().getNumberSuccessfulCommands();
    }

    @Override
    public long getNumberFailedCommandsReceived() {
        return this.commandProcessor.getCommandProcessorMetrics().getNumberFailedCommands();
    }

    @Override
    public long getNumberDroppedCommandsReceived() {
        return this.commandProcessor.getCommandProcessorMetrics().getNumberDroppedCommands();
    }

    @Override
    public long getNumberNotProcessedCommandsReceived() {
        return this.commandProcessor.getCommandProcessorMetrics().getNumberNotProcessedCommands();
    }

    @Override
    public long getNumberTotalCommandsReceived() {
        return this.getNumberSuccessfulCommandsReceived() + this.getNumberFailedCommandsReceived() + this.getNumberDroppedCommandsReceived() + this.getNumberNotProcessedCommandsReceived();
    }

    @Override
    public long getAverageExecutionTimeReceived() {
        return this.commandProcessor.getCommandProcessorMetrics().getAverageExecutionTime();
    }

    @Override
    public Map<String, CommandProcessorMetrics.Calltime> getCallTimeDataReceived() {
        Map<String, CommandProcessorMetrics.Calltime> callTimeData = this.commandProcessor.getCommandProcessorMetrics().getCallTimeData();
        return callTimeData;
    }
}

