/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.configuration;

import java.util.LinkedHashMap;
import java.util.Map;
import org.rhq.core.domain.configuration.PropertySimple;

public class MapPropertySimpleWrapper {
    private PropertySimple prop;

    public MapPropertySimpleWrapper(PropertySimple prop) {
        if (prop == null) {
            throw new IllegalArgumentException("'prop' parameter must not be null.");
        }
        this.prop = prop;
    }

    public void setValue(Map<String, String> map) {
        String stringValue;
        if (map != null) {
            StringBuilder buffer = new StringBuilder();
            for (String key : map.keySet()) {
                String value = map.get(key);
                buffer.append(key).append('=').append(value).append('\n');
            }
            stringValue = buffer.toString();
        } else {
            stringValue = null;
        }
        if (null != stringValue && stringValue.length() > 2000) {
            throw new IllegalArgumentException(stringValue);
        }
        this.prop.setStringValue(stringValue);
    }

    public Map<String, String> getValue() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String stringValue = this.prop.getStringValue();
        if (stringValue != null) {
            String[] lines;
            for (String line : lines = stringValue.split("\n+")) {
                String entry = line.trim();
                int equalsIndex = entry.indexOf(61);
                if (equalsIndex == -1) {
                    throw new IllegalStateException("Malformed entry (no equals sign): " + entry);
                }
                String key = entry.substring(0, equalsIndex);
                String value = entry.substring(equalsIndex + 1);
                map.put(key, value);
            }
        }
        return map;
    }
}

