/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.bundle;

public class BundleHandoverResponse {
    private final boolean success;
    private final String message;
    private final Throwable throwable;
    private final FailureType failureType;

    private BundleHandoverResponse(boolean success, String message, Throwable throwable, FailureType failureType) {
        this.success = success;
        this.message = message;
        this.throwable = throwable;
        this.failureType = failureType;
    }

    public static BundleHandoverResponse success() {
        return BundleHandoverResponse.success(null);
    }

    public static BundleHandoverResponse success(String message) {
        return new BundleHandoverResponse(true, message, null, null);
    }

    public static BundleHandoverResponse failure(FailureType failureType) {
        return BundleHandoverResponse.failure(failureType, null, null);
    }

    public static BundleHandoverResponse failure(FailureType failureType, String message) {
        return BundleHandoverResponse.failure(failureType, message, null);
    }

    public static BundleHandoverResponse failure(FailureType failureType, String message, Throwable throwable) {
        if (failureType == null) {
            throw new IllegalArgumentException("failureType is null");
        }
        return new BundleHandoverResponse(false, message, throwable, failureType);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public FailureType getFailureType() {
        return this.failureType;
    }

    public static enum FailureType {
        INVALID_ACTION,
        MISSING_PARAMETER,
        INVALID_PARAMETER,
        PLUGIN_CONTAINER,
        EXECUTION;

    }
}

