/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.bundle;

import java.io.InputStream;
import java.util.Map;
import org.rhq.core.pluginapi.bundle.BundleHandoverContext;

public class BundleHandoverRequest {
    private final InputStream content;
    private final String filename;
    private final String action;
    private final Map<String, String> params;
    private final BundleHandoverContext context;

    private BundleHandoverRequest(InputStream content, String filename, String action, Map<String, String> params, BundleHandoverContext context) {
        this.content = content;
        this.filename = filename;
        this.action = action;
        this.params = params;
        this.context = context;
    }

    public InputStream getContent() {
        return this.content;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getAction() {
        return this.action;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public BundleHandoverContext getContext() {
        return this.context;
    }

    public String toString() {
        return "BundleHandoverRequest[filename='" + this.filename + '\'' + ", action='" + this.action + '\'' + ", params=" + this.params + ", context=" + this.context + ']';
    }

    public static class Builder {
        private InputStream content;
        private String filename;
        private String action;
        private Map<String, String> params;
        private BundleHandoverContext context;

        public Builder setContent(InputStream content) {
            this.content = content;
            return this;
        }

        public Builder setFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public Builder setParams(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public Builder setContext(BundleHandoverContext context) {
            this.context = context;
            return this;
        }

        public BundleHandoverRequest createBundleHandoverRequest() {
            return new BundleHandoverRequest(this.content, this.filename, this.action, this.params, this.context);
        }
    }
}

