/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.util.ConfigEditor;
import org.rhq.cassandra.util.ConfigEditorException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.StringUtil;
import org.yaml.snakeyaml.error.YAMLException;

public class StorageNodeConfigDelegate
implements ConfigurationFacet {
    private Log log = LogFactory.getLog(StorageNodeConfigDelegate.class);
    private File jvmOptsFile;
    private File wrapperEnvFile;
    private File cassandraYamlFile;
    private OperationFacet invoker;

    public StorageNodeConfigDelegate(File basedir, OperationFacet invoker) {
        File confDir = new File(basedir, "conf");
        this.jvmOptsFile = new File(confDir, "cassandra-jvm.properties");
        this.cassandraYamlFile = new File(confDir, "cassandra.yaml");
        this.invoker = invoker;
        if (this.isWindows()) {
            File wrapperDir = new File(basedir, "../bin/wrapper");
            this.wrapperEnvFile = new File(wrapperDir, "rhq-storage-wrapper.env");
        }
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(this.jvmOptsFile));
        Configuration config = new Configuration();
        String heapDumpOnOOMError = properties.getProperty("heap_dump_on_OOMError");
        String heapDumpDir = properties.getProperty("heap_dump_dir");
        config.put((Property)new PropertySimple("minHeapSize", (Object)this.getHeapMinProp(properties)));
        config.put((Property)new PropertySimple("maxHeapSize", (Object)this.getHeapMaxProp(properties)));
        config.put((Property)new PropertySimple("heapNewSize", (Object)this.getHeapNewProp(properties)));
        config.put((Property)new PropertySimple("threadStackSize", (Object)this.getStackSizeProp(properties)));
        if (!StringUtil.isEmpty((String)heapDumpOnOOMError)) {
            config.put((Property)new PropertySimple("heapDumpOnOOMError", (Object)true));
        } else {
            config.put((Property)new PropertySimple("heapDumpOnOOMError", (Object)false));
        }
        if (!StringUtil.isEmpty((String)heapDumpDir)) {
            config.put((Property)new PropertySimple("heapDumpDir", (Object)heapDumpDir));
        } else {
            File basedir = this.jvmOptsFile.getParentFile().getParentFile();
            config.put((Property)new PropertySimple("heapDumpDir", (Object)new File(basedir, "bin").getAbsolutePath()));
        }
        ConfigEditor yamlEditor = new ConfigEditor(this.cassandraYamlFile);
        yamlEditor.load();
        config.put((Property)new PropertySimple("cqlPort", (Object)yamlEditor.getNativeTransportPort()));
        config.put((Property)new PropertySimple("gossipPort", (Object)yamlEditor.getStoragePort()));
        config.put((Property)new PropertySimple("CommitLogLocation", (Object)yamlEditor.getCommitLogDirectory()));
        config.put((Property)new PropertySimple("SavedCachesLocation", (Object)yamlEditor.getSavedCachesDirectory()));
        PropertyList dataFileLocations = new PropertyList("AllDataFileLocations");
        for (String s : yamlEditor.getDataFileDirectories()) {
            dataFileLocations.add((Property)new PropertySimple("directory", (Object)s));
        }
        config.put((Property)dataFileLocations);
        return config;
    }

    private static String useForwardSlash(String path) {
        return null != path ? path.replace('\\', '/') : null;
    }

    private String getHeapMinProp(Properties properties) {
        String value = properties.getProperty("heap_min");
        if (StringUtil.isEmpty((String)value)) {
            return "";
        }
        if (!value.startsWith("-Xms")) {
            return value;
        }
        return value.substring(4);
    }

    private String getHeapMaxProp(Properties properties) {
        String value = properties.getProperty("heap_max");
        if (StringUtil.isEmpty((String)value)) {
            return "";
        }
        if (!value.startsWith("-Xmx")) {
            return value;
        }
        return value.substring(4);
    }

    private String getHeapNewProp(Properties properties) {
        String value = properties.getProperty("heap_new");
        if (StringUtil.isEmpty((String)value)) {
            return "";
        }
        if (!value.startsWith("-Xmn")) {
            return value;
        }
        return value.substring(4);
    }

    private String getStackSizeProp(Properties properties) {
        String value = properties.getProperty("thread_stack_size");
        if (StringUtil.isEmpty((String)value)) {
            return "";
        }
        if (!value.startsWith("-Xss") && !value.endsWith("k") && value.length() <= 5) {
            return value;
        }
        return value.substring(4, value.length() - 1);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
        this.updateResourceConfigurationAndRestartIfNecessary(configurationUpdateReport, false);
    }

    public void updateResourceConfigurationAndRestartIfNecessary(ConfigurationUpdateReport configurationUpdateReport, boolean restartIfNecessary) {
        try {
            boolean dataFilesChanged;
            Configuration config = configurationUpdateReport.getConfiguration();
            this.updateCassandraJvmProps(config);
            this.updateCassandraYaml(config);
            String dataFilesChangedString = config.getSimpleValue("dataDirectoriesChanged");
            boolean bl = dataFilesChanged = dataFilesChangedString != null && Boolean.parseBoolean(dataFilesChangedString);
            if (dataFilesChanged && this.invoker != null) {
                try {
                    OperationResult moveDataFilesResult = this.invoker.invokeOperation("moveDataFiles", config);
                    if (moveDataFilesResult.getErrorMessage() != null) {
                        configurationUpdateReport.setErrorMessage(moveDataFilesResult.getErrorMessage());
                    }
                    restartIfNecessary = false;
                }
                catch (Exception e) {
                    configurationUpdateReport.setErrorMessage(e.getMessage());
                }
            }
            if (this.isWindows()) {
                this.updateWrapperEnv(config);
            }
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (IllegalArgumentException e) {
            configurationUpdateReport.setErrorMessage("No configuration update was applied: " + e.getMessage());
        }
        catch (IOException e) {
            configurationUpdateReport.setErrorMessageFromThrowable((Throwable)e);
        }
        catch (ConfigEditorException e) {
            configurationUpdateReport.setErrorMessageFromThrowable((Throwable)e);
        }
        if (restartIfNecessary) {
            this.restartIfNecessary(configurationUpdateReport);
        }
    }

    private void restartIfNecessary(ConfigurationUpdateReport configurationUpdateReport) {
        boolean restartIsRequired = false;
        Configuration params = configurationUpdateReport.getConfiguration();
        if (configurationUpdateReport.getStatus().equals((Object)ConfigurationUpdateStatus.SUCCESS) && (params.getSimpleValue("maxHeapSize") != null || params.getSimpleValue("heapNewSize") != null || params.getSimpleValue("threadStackSize") != null)) {
            restartIsRequired = true;
        }
        if (restartIsRequired && this.invoker != null) {
            try {
                OperationResult restartResult = this.invoker.invokeOperation("restart", null);
                if (restartResult.getErrorMessage() != null) {
                    configurationUpdateReport.setErrorMessage(restartResult.getErrorMessage());
                }
            }
            catch (Exception e) {
                configurationUpdateReport.setErrorMessage(e.getMessage());
            }
        }
    }

    private void updateCassandraJvmProps(Configuration newConfig) throws IOException {
        String heapDumpDir;
        PropertySimple heapDumpOnOMMError;
        String threadStackSize;
        String heapNewSize;
        String maxHeapSize;
        PropertiesFileUpdate propertiesUpdater = new PropertiesFileUpdate(this.jvmOptsFile.getAbsolutePath());
        Properties properties = propertiesUpdater.loadExistingProperties();
        String jmxPort = newConfig.getSimpleValue("jmxPort");
        if (!StringUtil.isEmpty((String)jmxPort)) {
            this.validateIntegerArg("jmx_port", jmxPort);
            properties.setProperty("jmx_port", jmxPort);
        }
        if (!StringUtil.isEmpty((String)(maxHeapSize = newConfig.getSimpleValue("maxHeapSize")))) {
            this.validateHeapArg("maxHeapSize", maxHeapSize);
            properties.setProperty("heap_min", "-Xms" + maxHeapSize);
            properties.setProperty("heap_max", "-Xmx" + maxHeapSize);
        }
        if (!StringUtil.isEmpty((String)(heapNewSize = newConfig.getSimpleValue("heapNewSize")))) {
            this.validateHeapArg("heapNewSize", heapNewSize);
            properties.setProperty("heap_new", "-Xmn" + heapNewSize);
        }
        if (!StringUtil.isEmpty((String)(threadStackSize = newConfig.getSimpleValue("threadStackSize")))) {
            this.validateIntegerArg("threadStackSize", threadStackSize);
            properties.setProperty("thread_stack_size", "-Xss" + threadStackSize + "k");
        }
        if ((heapDumpOnOMMError = newConfig.getSimple("heapDumpOnOOMError")) != null) {
            if (heapDumpOnOMMError.getBooleanValue().booleanValue()) {
                properties.setProperty("heap_dump_on_OOMError", "-XX:+HeapDumpOnOutOfMemoryError");
            } else {
                properties.setProperty("heap_dump_on_OOMError", "");
            }
        }
        if (!StringUtil.isEmpty((String)(heapDumpDir = StorageNodeConfigDelegate.useForwardSlash(newConfig.getSimpleValue("heapDumpDir"))))) {
            properties.setProperty("heap_dump_dir", heapDumpDir);
        }
        propertiesUpdater.update(properties);
    }

    private void updateCassandraYaml(Configuration newConfig) {
        ConfigEditor editor = new ConfigEditor(this.cassandraYamlFile);
        try {
            PropertySimple gossipPortProperty;
            editor.load();
            PropertySimple cqlPortProperty = newConfig.getSimple("cqlPort");
            if (cqlPortProperty != null) {
                editor.setNativeTransportPort(cqlPortProperty.getIntegerValue());
            }
            if ((gossipPortProperty = newConfig.getSimple("gossipPort")) != null) {
                editor.setStoragePort(gossipPortProperty.getIntegerValue());
            }
            editor.save();
        }
        catch (ConfigEditorException e) {
            if (e.getCause() instanceof YAMLException) {
                this.log.error((Object)("Failed to update " + this.cassandraYamlFile));
                this.log.info((Object)("Attempting to restore " + this.cassandraYamlFile));
                try {
                    editor.restore();
                    throw e;
                }
                catch (ConfigEditorException e1) {
                    this.log.error((Object)("Failed to restore " + this.cassandraYamlFile + ". A copy of the file prior to any " + "modifications can be found at " + editor.getBackupFile()));
                    throw new ConfigEditorException("There was an error updating " + this.cassandraYamlFile + " and " + "undoing the changes failed. A copy of the file can be found at " + editor.getBackupFile() + ". See the agent logs for more details.", (Throwable)e);
                }
            }
            this.log.error((Object)("No updates were made to " + this.cassandraYamlFile + " due to an unexpected error"), (Throwable)e);
            throw e;
        }
    }

    private void updateWrapperEnv(Configuration config) throws IOException {
        String heapDumpDir;
        PropertySimple heapDumpOnOMMError;
        String threadStackSize;
        String heapNewSize;
        PropertiesFileUpdate propertiesUpdater = new PropertiesFileUpdate(this.wrapperEnvFile.getAbsolutePath());
        Properties properties = propertiesUpdater.loadExistingProperties();
        String maxHeapSize = config.getSimpleValue("maxHeapSize");
        if (!StringUtil.isEmpty((String)maxHeapSize)) {
            this.validateHeapArg("maxHeapSize", maxHeapSize);
            properties.setProperty("set.heap_min", "-Xms" + maxHeapSize);
            properties.setProperty("set.heap_max", "-Xmx" + maxHeapSize);
        }
        if (!StringUtil.isEmpty((String)(heapNewSize = config.getSimpleValue("heapNewSize")))) {
            this.validateHeapArg("heapNewSize", heapNewSize);
            properties.setProperty("set.heap_new", "-Xmn" + heapNewSize);
        }
        if (!StringUtil.isEmpty((String)(threadStackSize = config.getSimpleValue("threadStackSize")))) {
            this.validateIntegerArg("threadStackSize", threadStackSize);
            properties.setProperty("set.thread_stack_size", "-Xss" + threadStackSize + "k");
        }
        if ((heapDumpOnOMMError = config.getSimple("heapDumpOnOOMError")) != null) {
            if (heapDumpOnOMMError.getBooleanValue().booleanValue()) {
                properties.setProperty("set.heap_dump_on_OOMError", "-XX:+HeapDumpOnOutOfMemoryError");
            } else {
                properties.setProperty("set.heap_dump_on_OOMError", "");
            }
        }
        if (!StringUtil.isEmpty((String)(heapDumpDir = StorageNodeConfigDelegate.useForwardSlash(config.getSimpleValue("heapDumpDir"))))) {
            properties.setProperty("set.heap_dump_dir", "-XX:HeapDumpPath=" + heapDumpDir);
        }
        propertiesUpdater.update(properties);
    }

    private void validateHeapArg(String name, String value) {
        if (value.length() < 2) {
            throw new IllegalArgumentException(value + " is not a legal value for the property [" + name + "]");
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length - 1; ++i) {
            if (Character.isDigit(chars[i])) continue;
            throw new IllegalArgumentException(value + " is not a legal value for the property [" + name + "]");
        }
        char lastChar = Character.toUpperCase(chars[chars.length - 1]);
        if (lastChar != 'M' && lastChar != 'G') {
            throw new IllegalArgumentException(value + " is not a legal value for the property [" + name + "]");
        }
    }

    private void validateIntegerArg(String name, String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(value + " is not a legal value for the property [" + name + "]");
        }
    }

    private boolean isWindows() {
        return File.separatorChar == '\\';
    }
}

