/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.storage;

import java.util.Set;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.plugins.jmx.EmbeddedJMXServerDiscoveryComponent;
import org.rhq.plugins.jmx.JMXComponent;

public class JvmServerDiscoveryComponent
extends EmbeddedJMXServerDiscoveryComponent
implements ResourceUpgradeFacet<ResourceComponent<?>> {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent<?>> context) throws Exception {
        Set details = super.discoverResources(context);
        if (!details.isEmpty()) {
            DiscoveredResourceDetails res = (DiscoveredResourceDetails)details.iterator().next();
            res.setResourceName("JVM");
        }
        return details;
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext<ResourceComponent<?>> inventoriedResource) {
        ResourceUpgradeReport report = new ResourceUpgradeReport();
        if ("Cassandra Server JVM".equals(inventoriedResource.getName())) {
            report.setNewName("JVM");
            report.setNewDescription("The JVM of the Storage node");
            report.setForceGenericPropertyUpgrade(true);
            return report;
        }
        return null;
    }
}

