/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hyperic.sigar.DirUsage;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.ServiceConfig;
import org.hyperic.sigar.win32.Win32Exception;
import org.rhq.core.system.NativeSystemInfo;
import org.rhq.core.system.ServiceInfo;
import org.rhq.core.system.SystemInfoException;
import org.rhq.core.system.windows.DWordRegistryValue;
import org.rhq.core.system.windows.MultiSzRegistryValue;
import org.rhq.core.system.windows.RegistryEntry;
import org.rhq.core.system.windows.RegistryValue;
import org.rhq.core.system.windows.SzRegistryValue;

public class WindowsNativeSystemInfo
extends NativeSystemInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServiceInfo> getAllServices() throws SystemInfoException {
        ArrayList<ServiceInfo> services;
        block8: {
            services = new ArrayList<ServiceInfo>();
            try {
                List serviceNames = Service.getServiceNames();
                if (serviceNames == null) break block8;
                for (String serviceName : serviceNames) {
                    Service s = null;
                    try {
                        s = new Service(serviceName);
                        ServiceConfig sc = s.getConfig();
                        ServiceInfo si = new ServiceInfo(sc.getName(), sc.getDisplayName(), sc.getDescription(), sc.getPath(), sc.getDependencies());
                        services.add(si);
                    }
                    catch (Win32Exception e) {}
                    continue;
                    finally {
                        if (null == s) continue;
                        s.close();
                    }
                }
            }
            catch (Exception e) {
                throw new SystemInfoException("Cannot obtain Windows Services information", e);
            }
        }
        return services;
    }

    @Override
    public DirUsage getDirectoryUsage(String path) {
        throw new UnsupportedOperationException("Dir Usage not yet supported.");
    }

    public List<String> getRegistryChildKeys(RegistryEntry.Root root, String key) throws SystemInfoException {
        try {
            RegistryKey registry = null;
            switch (root) {
                case HKEY_CURRENT_USER: {
                    registry = RegistryKey.CurrentUser.openSubKey(key);
                    break;
                }
                case HKEY_LOCAL_MACHINE: {
                    registry = RegistryKey.LocalMachine.openSubKey(key);
                    break;
                }
                default: {
                    throw new SystemInfoException("Invalid root: " + (Object)((Object)root));
                }
            }
            ArrayList<String> list = new ArrayList<String>();
            String[] values = registry.getSubKeyNames();
            if (values != null) {
                list.addAll(Arrays.asList(values));
            }
            return list;
        }
        catch (Exception e) {
            throw new SystemInfoException(e);
        }
    }

    public List<String> getRegistryValueNames(RegistryEntry.Root root, String key) throws SystemInfoException {
        try {
            RegistryKey registry = null;
            switch (root) {
                case HKEY_CURRENT_USER: {
                    registry = RegistryKey.CurrentUser.openSubKey(key);
                    break;
                }
                case HKEY_LOCAL_MACHINE: {
                    registry = RegistryKey.LocalMachine.openSubKey(key);
                    break;
                }
                default: {
                    throw new SystemInfoException("Invalid root: " + (Object)((Object)root));
                }
            }
            ArrayList<String> list = new ArrayList<String>();
            String[] values = registry.getValueNames();
            if (values != null) {
                list.addAll(Arrays.asList(values));
            }
            return list;
        }
        catch (Exception e) {
            throw new SystemInfoException(e);
        }
    }

    public List<RegistryEntry> getRegistryEntries(RegistryEntry.Root root, String key) throws SystemInfoException {
        try {
            List<String> names = this.getRegistryValueNames(root, key);
            ArrayList<RegistryEntry> entries = new ArrayList<RegistryEntry>();
            for (String name : names) {
                RegistryEntry entry = this.getRegistryEntry(root, key, name);
                entries.add(entry);
            }
            return entries;
        }
        catch (Exception e) {
            throw new SystemInfoException(e);
        }
    }

    public RegistryEntry getRegistryEntry(RegistryEntry.Root root, String key, String name) throws SystemInfoException {
        RegistryValue value;
        switch (root) {
            case HKEY_LOCAL_MACHINE: {
                value = this.getLocalMachineRegistryValue(key, name);
                break;
            }
            case HKEY_CURRENT_USER: {
                value = this.getCurrentUserRegistryValue(key, name);
                break;
            }
            default: {
                throw new SystemInfoException("Invalid root: " + (Object)((Object)root));
            }
        }
        return new RegistryEntry(root, key, name, value);
    }

    private RegistryValue getLocalMachineRegistryValue(String key, String name) throws SystemInfoException {
        RegistryKey registry;
        try {
            registry = RegistryKey.LocalMachine.openSubKey(key);
        }
        catch (Exception e) {
            throw new SystemInfoException(e);
        }
        return this.getRegistryValue(registry, name);
    }

    private RegistryValue getCurrentUserRegistryValue(String key, String name) throws SystemInfoException {
        RegistryKey registry;
        try {
            registry = RegistryKey.CurrentUser.openSubKey(key);
        }
        catch (Exception e) {
            throw new SystemInfoException(e);
        }
        return this.getRegistryValue(registry, name);
    }

    private RegistryValue getRegistryValue(RegistryKey registry, String name) throws SystemInfoException {
        RegistryValue.Type valueType = this.guessType(registry, name);
        try {
            switch (valueType) {
                case DWORD: {
                    return new DWordRegistryValue(registry.getIntValue(name));
                }
                case SZ: {
                    return new SzRegistryValue(registry.getStringValue(name));
                }
                case MULTI_SZ: {
                    ArrayList values = new ArrayList();
                    registry.getMultiStringValue(name, values);
                    return new MultiSzRegistryValue(values.toArray(new String[0]));
                }
            }
        }
        catch (Exception e) {
            throw new SystemInfoException(e);
        }
        throw new IllegalStateException("Bad registry value type: " + (Object)((Object)valueType));
    }

    private RegistryValue.Type guessType(RegistryKey registry, String name) {
        try {
            registry.getIntValue(name);
            return RegistryValue.Type.DWORD;
        }
        catch (Exception e) {
            try {
                registry.getMultiStringValue(name, new ArrayList());
                return RegistryValue.Type.MULTI_SZ;
            }
            catch (Exception e2) {
                try {
                    registry.getStringValue(name);
                    return RegistryValue.Type.SZ;
                }
                catch (Exception exception) {
                    throw new SystemInfoException("Unknown registry value type for [" + name + "]");
                }
            }
        }
    }
}

