/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcFd;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.ProcTime;
import org.hyperic.sigar.SigarProxy;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfoException;

public class AggregateProcessInfo
extends ProcessInfo {
    private Map<Long, ProcessStats> childProcessStats = new HashMap<Long, ProcessStats>();
    private AggregateProcTime aggregateProcTime;
    private AggregateProcMem aggregateProcMem;
    private AggregateProcCpu aggregateProcCpu;
    private AggregateProcFd aggregateProcFd;

    public AggregateProcessInfo(long pid) {
        super(pid);
    }

    @Override
    public void refresh() throws SystemInfoException {
        super.refresh();
        try {
            long[] pids = null;
            try {
                pids = this.sigar.getProcList();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (pids != null) {
                HashSet<Long> runningPids = new HashSet<Long>();
                for (long pid : pids) {
                    runningPids.add(pid);
                    try {
                        ProcState processProcState = this.sigar.getProcState(pid);
                        if (processProcState.getPpid() != this.pid) continue;
                        ProcessStats ps = this.childProcessStats.get(pid);
                        if (ps == null) {
                            ps = new ProcessStats(pid);
                            ps.isRunning = true;
                            this.childProcessStats.put(pid, ps);
                        }
                        ps.refresh(this.sigar);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                for (ProcessStats ps : this.childProcessStats.values()) {
                    if (runningPids.contains(ps.childPid)) continue;
                    ps.isRunning = false;
                }
            }
            ArrayList<ProcTime> procTimes = new ArrayList<ProcTime>();
            ArrayList<ProcMem> procMems = new ArrayList<ProcMem>();
            ArrayList<ProcCpu> procCpus = new ArrayList<ProcCpu>();
            ArrayList<ProcFd> procFds = new ArrayList<ProcFd>();
            ProcessInfo.ProcessInfoSnapshot priorSnaphot = this.priorSnaphot();
            try {
                procTimes.add(priorSnaphot.getTime());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                procMems.add(priorSnaphot.getMemory());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                procCpus.add(priorSnaphot.getCpu());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                procFds.add(priorSnaphot.getFileDescriptor());
            }
            catch (Exception e) {
                // empty catch block
            }
            for (ProcessStats ps : this.childProcessStats.values()) {
                procTimes.add(ps.childProcTime);
                if (!ps.isRunning) continue;
                procMems.add(ps.childProcMem);
                procCpus.add(ps.childProcCpu);
                procFds.add(ps.childProcFd);
            }
            this.aggregateProcTime = new AggregateProcTime(procTimes);
            this.aggregateProcMem = new AggregateProcMem(procMems);
            this.aggregateProcCpu = new AggregateProcCpu(procCpus);
            this.aggregateProcFd = new AggregateProcFd(procFds);
        }
        catch (Exception e) {
            throw new SystemInfoException(e);
        }
    }

    public AggregateProcTime getAggregateTime() {
        return this.aggregateProcTime;
    }

    public AggregateProcMem getAggregateMemory() {
        return this.aggregateProcMem;
    }

    public AggregateProcCpu getAggregateCpu() {
        return this.aggregateProcCpu;
    }

    public AggregateProcFd getAggregateFileDescriptor() {
        return this.aggregateProcFd;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder(super.toString());
        if (this.childProcessStats != null) {
            str.append(", child-pids=" + this.childProcessStats.keySet());
        }
        return str.toString();
    }

    private static class ProcessStats {
        public long childPid;
        public boolean isRunning;
        public ProcTime childProcTime;
        public ProcMem childProcMem;
        public ProcCpu childProcCpu;
        public ProcFd childProcFd;

        public ProcessStats(long myPid) {
            this.childPid = myPid;
        }

        public void refresh(SigarProxy sigar) throws Exception {
            try {
                this.childProcTime = sigar.getProcTime(this.childPid);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.childProcMem = sigar.getProcMem(this.childPid);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.childProcCpu = sigar.getProcCpu(this.childPid);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.childProcFd = sigar.getProcFd(this.childPid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class AggregateProcFd {
        private long total;

        public long getTotal() {
            return this.total;
        }

        public AggregateProcFd(List<ProcFd> fds) {
            for (ProcFd fd : fds) {
                if (fd == null) continue;
                this.total += fd.getTotal();
            }
        }
    }

    public class AggregateProcMem {
        private long majorFaults;
        private long minorFaults;
        private long pageFaults;
        private long resident;
        private long share;
        private long size;

        public long getMajorFaults() {
            return this.majorFaults;
        }

        public long getMinorFaults() {
            return this.minorFaults;
        }

        public long getPageFaults() {
            return this.pageFaults;
        }

        public long getResident() {
            return this.resident;
        }

        public long getShare() {
            return this.share;
        }

        public long getSize() {
            return this.size;
        }

        public AggregateProcMem(List<ProcMem> mems) {
            for (ProcMem mem : mems) {
                if (mem == null) continue;
                this.majorFaults += mem.getMajorFaults();
                this.minorFaults += mem.getMinorFaults();
                this.pageFaults += mem.getPageFaults();
                this.resident += mem.getResident();
                this.share += mem.getShare();
                this.size += mem.getSize();
            }
        }
    }

    public class AggregateProcCpu {
        private long sys;
        private long user;
        private long total;
        private double percent;

        public long getSys() {
            return this.sys;
        }

        public long getUser() {
            return this.user;
        }

        public long getTotal() {
            return this.total;
        }

        public double getPercent() {
            return this.percent;
        }

        public AggregateProcCpu(List<ProcCpu> cpus) {
            for (ProcCpu cpu : cpus) {
                if (cpu == null) continue;
                this.sys += cpu.getSys();
                this.user += cpu.getUser();
                this.total += cpu.getTotal();
                this.percent += cpu.getPercent();
            }
        }
    }

    public class AggregateProcTime {
        long sys;
        long user;
        long total;

        public long getSys() {
            return this.sys;
        }

        public long getUser() {
            return this.user;
        }

        public long getTotal() {
            return this.total;
        }

        public AggregateProcTime(List<ProcTime> times) {
            for (ProcTime time : times) {
                if (time == null) continue;
                this.sys += time.getSys();
                this.user += time.getUser();
                this.total += time.getTotal();
            }
        }
    }
}

