/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ra.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.XsdString;

public class ConfigPropertyImpl
implements ConfigProperty {
    private static final long serialVersionUID = 2L;
    protected final ArrayList<LocalizedXsdString> description;
    protected final XsdString configPropertyName;
    protected final XsdString configPropertyType;
    protected final XsdString configPropertyValue;
    protected final String id;
    protected boolean mandatory;

    public ConfigPropertyImpl(List<LocalizedXsdString> description, XsdString configPropertyName, XsdString configPropertyType, XsdString configPropertyValue, String id) {
        this(description, configPropertyName, configPropertyType, configPropertyValue, id, false);
    }

    public ConfigPropertyImpl(List<LocalizedXsdString> description, XsdString configPropertyName, XsdString configPropertyType, XsdString configPropertyValue, String id, boolean mandatory) {
        if (description != null) {
            this.description = new ArrayList(description.size());
            this.description.addAll(description);
            for (LocalizedXsdString d : this.description) {
                d.setTag(ConfigProperty.Tag.DESCRIPTION.toString());
            }
        } else {
            this.description = new ArrayList(0);
        }
        this.configPropertyName = configPropertyName;
        if (!XsdString.isNull((XsdString)this.configPropertyName)) {
            this.configPropertyName.setTag(ConfigProperty.Tag.CONFIG_PROPERTY_NAME.toString());
        }
        this.configPropertyType = configPropertyType;
        if (!XsdString.isNull((XsdString)this.configPropertyType)) {
            this.configPropertyType.setTag(ConfigProperty.Tag.CONFIG_PROPERTY_TYPE.toString());
        }
        this.configPropertyValue = configPropertyValue;
        if (!XsdString.isNull((XsdString)this.configPropertyValue)) {
            this.configPropertyValue.setTag(ConfigProperty.Tag.CONFIG_PROPERTY_VALUE.toString());
        }
        this.id = id;
        this.mandatory = mandatory;
    }

    public List<LocalizedXsdString> getDescriptions() {
        return this.description == null ? null : Collections.unmodifiableList(this.description);
    }

    public XsdString getConfigPropertyName() {
        return this.configPropertyName;
    }

    public XsdString getConfigPropertyType() {
        return this.configPropertyType;
    }

    public XsdString getConfigPropertyValue() {
        return this.configPropertyValue;
    }

    public String getId() {
        return this.id;
    }

    public boolean isValueSet() {
        return this.getConfigPropertyValue() != null && this.getConfigPropertyValue().getValue() != null && !this.getConfigPropertyValue().getValue().trim().equals("");
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean v) {
        this.mandatory = v;
    }

    public CopyableMetaData copy() {
        return new ConfigPropertyImpl(CopyUtil.cloneList(this.description), (XsdString)CopyUtil.clone((CopyableMetaData)this.configPropertyName), (XsdString)CopyUtil.clone((CopyableMetaData)this.configPropertyType), (XsdString)CopyUtil.clone((CopyableMetaData)this.configPropertyValue), CopyUtil.cloneString((String)this.id), this.mandatory);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configPropertyName == null ? 0 : this.configPropertyName.hashCode());
        result = 31 * result + (this.configPropertyType == null ? 0 : this.configPropertyType.hashCode());
        result = 31 * result + (this.configPropertyValue == null ? 0 : this.configPropertyValue.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.mandatory ? 7 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigPropertyImpl)) {
            return false;
        }
        ConfigPropertyImpl other = (ConfigPropertyImpl)obj;
        if (this.configPropertyName == null ? other.configPropertyName != null : !this.configPropertyName.equals((Object)other.configPropertyName)) {
            return false;
        }
        if (this.configPropertyType == null ? other.configPropertyType != null : !this.configPropertyType.equals((Object)other.configPropertyType)) {
            return false;
        }
        if (this.configPropertyValue == null ? other.configPropertyValue != null : !this.configPropertyValue.equals((Object)other.configPropertyValue)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.mandatory == other.mandatory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<config-property");
        if (this.id != null) {
            sb.append(" ").append(ConfigProperty.Attribute.ID).append("=\"").append(this.id).append("\"");
        }
        sb.append(">");
        for (LocalizedXsdString d : this.description) {
            sb.append(d);
        }
        sb.append(this.configPropertyName);
        sb.append(this.configPropertyType);
        if (!XsdString.isNull((XsdString)this.configPropertyValue)) {
            sb.append(this.configPropertyValue);
        }
        sb.append("</config-property>");
        return sb.toString();
    }
}

