/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.web.WebMessages;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityActions {
    public static final PrivilegedAction<SecurityContext> GET_SECURITY_CONTEXT = new PrivilegedAction<SecurityContext>(){

        @Override
        public SecurityContext run() {
            return SecurityContextAssociation.getSecurityContext();
        }
    };
    public static final PrivilegedAction<Void> CLEAR_SECURITY_CONTEXT = new PrivilegedAction<Void>(){

        @Override
        public Void run() {
            SecurityContextAssociation.clearSecurityContext();
            return null;
        }
    };
    public static final String AUTH_EXCEPTION_KEY = "org.jboss.security.exception";

    SecurityActions() {
    }

    static SecurityContext createSecurityContext(final String domain) {
        if (System.getSecurityManager() == null) {
            try {
                return SecurityContextFactory.createSecurityContext((String)domain);
            }
            catch (Exception e) {
                throw WebMessages.MESSAGES.failToCreateSecurityContext(e);
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                try {
                    return SecurityContextFactory.createSecurityContext((String)domain);
                }
                catch (Exception e) {
                    throw WebMessages.MESSAGES.failToCreateSecurityContext(e);
                }
            }
        });
    }

    static void setSecurityContextOnAssociation(final SecurityContext sc) {
        if (System.getSecurityManager() == null) {
            SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                    return null;
                }
            });
        }
    }

    static SecurityContext getSecurityContext() {
        if (System.getSecurityManager() == null) {
            return SecurityContextAssociation.getSecurityContext();
        }
        return AccessController.doPrivileged(GET_SECURITY_CONTEXT);
    }

    static void clearSecurityContext() {
        if (System.getSecurityManager() == null) {
            SecurityContextAssociation.clearSecurityContext();
        } else {
            AccessController.doPrivileged(CLEAR_SECURITY_CONTEXT);
        }
    }

    static void pushRunAsIdentity(final RunAsIdentity principal, final SecurityContext sc) {
        if (sc == null) {
            throw WebMessages.MESSAGES.noSecurityContext();
        }
        if (System.getSecurityManager() == null) {
            sc.setOutgoingRunAs((RunAs)principal);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    sc.setOutgoingRunAs((RunAs)principal);
                    return null;
                }
            });
        }
    }

    static RunAs popRunAsIdentity(final SecurityContext sc) {
        if (sc == null) {
            throw WebMessages.MESSAGES.noSecurityContext();
        }
        if (System.getSecurityManager() == null) {
            RunAs principal = sc.getOutgoingRunAs();
            sc.setOutgoingRunAs(null);
            return principal;
        }
        return AccessController.doPrivileged(new PrivilegedAction<RunAs>(){

            @Override
            public RunAs run() {
                RunAs principal = sc.getOutgoingRunAs();
                sc.setOutgoingRunAs(null);
                return principal;
            }
        });
    }

    static void clearAuthException() {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    if (sc != null) {
                        sc.getData().put(SecurityActions.AUTH_EXCEPTION_KEY, null);
                    }
                    return null;
                }
            });
        } else {
            SecurityContext sc = SecurityActions.getSecurityContext();
            if (sc != null) {
                sc.getData().put(AUTH_EXCEPTION_KEY, null);
            }
        }
    }

    static Throwable getAuthException() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Throwable>(){

                @Override
                public Throwable run() {
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    Throwable exception = null;
                    if (sc != null) {
                        exception = (Throwable)sc.getData().get(SecurityActions.AUTH_EXCEPTION_KEY);
                    }
                    return exception;
                }
            });
        }
        SecurityContext sc = SecurityActions.getSecurityContext();
        Throwable exception = null;
        if (sc != null) {
            exception = (Throwable)sc.getData().get(AUTH_EXCEPTION_KEY);
        }
        return exception;
    }
}

