/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.ManifestHelper;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.javaee.spec.EmptyMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.merge.javaee.spec.SecurityRolesMetaDataMerger;
import org.jboss.metadata.merge.web.jboss.JBossWebMetaDataMerger;
import org.jboss.metadata.merge.web.spec.WebCommonMetaDataMerger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AbsoluteOrderingMetaData;
import org.jboss.metadata.web.spec.OrderingElementMetaData;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.metadata.web.spec.WebCommonMetaData;
import org.jboss.metadata.web.spec.WebFragmentMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.vfs.VirtualFile;

public class WarMetaDataProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        SecurityRolesMetaData earSecurityRolesMetaData;
        EarMetaData earMetaData;
        DeploymentUnit parent;
        WebMetaData jarAnnotatedMetaData;
        WebFragmentMetaData webFragmentMetaData;
        WebMetaData annotatedMetaData;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        assert (warMetaData != null);
        boolean isComplete = false;
        WebMetaData specMetaData = warMetaData.getWebMetaData();
        if (specMetaData != null) {
            isComplete = specMetaData instanceof Web25MetaData ? (isComplete |= ((Web25MetaData)specMetaData).isMetadataComplete()) : (specMetaData instanceof Web30MetaData ? (isComplete |= ((Web30MetaData)specMetaData).isMetadataComplete()) : true);
        }
        LinkedList<String> order = new LinkedList<String>();
        ArrayList<WebOrdering> orderings = new ArrayList<WebOrdering>();
        HashSet<String> jarsSet = new HashSet<String>();
        HashSet<VirtualFile> overlays = new HashSet<VirtualFile>();
        HashMap<String, VirtualFile> scis = new HashMap<String, VirtualFile>();
        boolean fragmentFound = false;
        Map<String, WebFragmentMetaData> webFragments = warMetaData.getWebFragmentsMetaData();
        List resourceRoots = DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit);
        for (ResourceRoot resourceRoot : resourceRoots) {
            VirtualFile sci;
            if (!resourceRoot.getRoot().getName().toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
            jarsSet.add(resourceRoot.getRootName());
            VirtualFile overlay = resourceRoot.getRoot().getChild("META-INF/resources");
            if (overlay.exists()) {
                overlays.add(overlay);
            }
            if (!(sci = resourceRoot.getRoot().getChild("META-INF/services/javax.servlet.ServletContainerInitializer")).exists()) continue;
            scis.put(resourceRoot.getRootName(), sci);
        }
        if (!isComplete) {
            HashSet<String> jarsWithoutFragmentsSet = new HashSet<String>();
            jarsWithoutFragmentsSet.addAll(jarsSet);
            for (String jarName : webFragments.keySet()) {
                fragmentFound = true;
                WebFragmentMetaData fragmentMetaData = webFragments.get(jarName);
                webFragments.put(jarName, fragmentMetaData);
                WebOrdering webOrdering = new WebOrdering();
                webOrdering.setName(fragmentMetaData.getName());
                webOrdering.setJar(jarName);
                jarsWithoutFragmentsSet.remove(jarName);
                if (fragmentMetaData.getOrdering() != null) {
                    if (fragmentMetaData.getOrdering().getAfter() != null) {
                        for (OrderingElementMetaData orderingElementMetaData : fragmentMetaData.getOrdering().getAfter().getOrdering()) {
                            if (orderingElementMetaData.isOthers()) {
                                webOrdering.setAfterOthers(true);
                                continue;
                            }
                            webOrdering.addAfter(orderingElementMetaData.getName());
                        }
                    }
                    if (fragmentMetaData.getOrdering().getBefore() != null) {
                        for (OrderingElementMetaData orderingElementMetaData : fragmentMetaData.getOrdering().getBefore().getOrdering()) {
                            if (orderingElementMetaData.isOthers()) {
                                webOrdering.setBeforeOthers(true);
                                continue;
                            }
                            webOrdering.addBefore(orderingElementMetaData.getName());
                        }
                    }
                }
                orderings.add(webOrdering);
            }
            for (String jarName : jarsWithoutFragmentsSet) {
                WebOrdering ordering = new WebOrdering();
                ordering.setJar(jarName);
                orderings.add(ordering);
            }
        }
        if (!fragmentFound) {
            orderings.clear();
        }
        AbsoluteOrderingMetaData absoluteOrderingMetaData = null;
        if (!isComplete && specMetaData instanceof Web30MetaData) {
            absoluteOrderingMetaData = ((Web30MetaData)specMetaData).getAbsoluteOrdering();
        }
        if (absoluteOrderingMetaData != null) {
            int otherPos = -1;
            int i = 0;
            for (OrderingElementMetaData orderingElementMetaData : absoluteOrderingMetaData.getOrdering()) {
                if (orderingElementMetaData.isOthers()) {
                    if (otherPos >= 0) {
                        throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidMultipleOthers());
                    }
                    otherPos = i;
                } else {
                    boolean found = false;
                    for (WebOrdering ordering : orderings) {
                        if (!orderingElementMetaData.getName().equals(ordering.getName())) continue;
                        order.add(ordering.getJar());
                        jarsSet.remove(ordering.getJar());
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidAbsoluteOrdering(orderingElementMetaData.getName()));
                    }
                }
                ++i;
            }
            if (otherPos >= 0) {
                order.addAll(otherPos, jarsSet);
                jarsSet.clear();
            }
        } else if (orderings.size() > 0) {
            try {
                WarMetaDataProcessor.resolveOrder(orderings, order);
            }
            catch (IllegalStateException e) {
                throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidRelativeOrdering(), (Throwable)e);
            }
            jarsSet.clear();
        } else {
            order.addAll(jarsSet);
            jarsSet.clear();
            warMetaData.setNoOrder(true);
        }
        Logger log = Logger.getLogger((String)"org.jboss.web");
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Resolved order: [ ");
            for (String jar : order) {
                builder.append(jar).append(' ');
            }
            builder.append(']');
            log.debug((Object)builder.toString());
        }
        warMetaData.setOrder(order);
        warMetaData.setOverlays(overlays);
        warMetaData.setScis(scis);
        Map<String, WebMetaData> annotationsMetaData = warMetaData.getAnnotationsMetaData();
        WebCommonMetaData mergedFragmentMetaData = new WebCommonMetaData();
        if (specMetaData == null) {
            specMetaData = new Web30MetaData();
            specMetaData.setVersion("3.0");
        }
        if ((annotatedMetaData = annotationsMetaData.get("classes")) == null && deploymentUnit.hasAttachment(Attachments.OSGI_MANIFEST)) {
            annotatedMetaData = annotationsMetaData.get(deploymentUnit.getName());
        }
        if (annotatedMetaData != null) {
            if (isComplete) {
                annotatedMetaData.setFilters(null);
                annotatedMetaData.setFilterMappings(null);
                annotatedMetaData.setListeners(null);
                annotatedMetaData.setServlets(null);
                annotatedMetaData.setServletMappings(null);
            }
            WebCommonMetaDataMerger.augment((WebCommonMetaData)specMetaData, (WebCommonMetaData)annotatedMetaData, null, (boolean)true);
        }
        for (String jar : order) {
            webFragmentMetaData = webFragments.get(jar);
            if (webFragmentMetaData == null || isComplete) {
                webFragmentMetaData = new WebFragmentMetaData();
                webFragmentMetaData.setDistributable(new EmptyMetaData());
            }
            jarAnnotatedMetaData = annotationsMetaData.get(jar);
            if ((isComplete || webFragmentMetaData.isMetadataComplete()) && jarAnnotatedMetaData != null) {
                jarAnnotatedMetaData.setFilters(null);
                jarAnnotatedMetaData.setFilterMappings(null);
                jarAnnotatedMetaData.setListeners(null);
                jarAnnotatedMetaData.setServlets(null);
                jarAnnotatedMetaData.setServletMappings(null);
            }
            if (jarAnnotatedMetaData != null) {
                WebCommonMetaDataMerger.augment((WebCommonMetaData)webFragmentMetaData, (WebCommonMetaData)jarAnnotatedMetaData, null, (boolean)true);
            }
            try {
                WebCommonMetaDataMerger.augment((WebCommonMetaData)mergedFragmentMetaData, (WebCommonMetaData)webFragmentMetaData, (WebCommonMetaData)specMetaData, (boolean)false);
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidWebFragment(jar), (Throwable)e);
            }
        }
        for (String jar : jarsSet) {
            webFragmentMetaData = new WebFragmentMetaData();
            webFragmentMetaData.setDistributable(new EmptyMetaData());
            jarAnnotatedMetaData = annotationsMetaData.get(jar);
            if (jarAnnotatedMetaData != null) {
                jarAnnotatedMetaData.setFilters(null);
                jarAnnotatedMetaData.setFilterMappings(null);
                jarAnnotatedMetaData.setListeners(null);
                jarAnnotatedMetaData.setServlets(null);
                jarAnnotatedMetaData.setServletMappings(null);
            }
            if (jarAnnotatedMetaData != null) {
                WebCommonMetaDataMerger.augment((WebCommonMetaData)webFragmentMetaData, (WebCommonMetaData)jarAnnotatedMetaData, null, (boolean)true);
            }
            try {
                WebCommonMetaDataMerger.augment((WebCommonMetaData)mergedFragmentMetaData, (WebCommonMetaData)webFragmentMetaData, (WebCommonMetaData)specMetaData, (boolean)false);
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidWebFragment(jar), (Throwable)e);
            }
        }
        WebCommonMetaDataMerger.augment((WebCommonMetaData)specMetaData, (WebCommonMetaData)mergedFragmentMetaData, null, (boolean)true);
        List<WebMetaData> additional = warMetaData.getAdditionalModuleAnnotationsMetadata();
        if (additional != null && !isComplete) {
            for (WebMetaData annotations : additional) {
                WebCommonMetaDataMerger.augment((WebCommonMetaData)specMetaData, (WebCommonMetaData)annotations, null, (boolean)true);
            }
        }
        JBossWebMetaData mergedMetaData = new JBossWebMetaData();
        JBossWebMetaData metaData = warMetaData.getJBossWebMetaData();
        JBossWebMetaDataMerger.merge((JBossWebMetaData)mergedMetaData, (JBossWebMetaData)metaData, (WebMetaData)specMetaData);
        String contextRoot = mergedMetaData.getContextRoot();
        Manifest manifest = (Manifest)deploymentUnit.getAttachment(Attachments.OSGI_MANIFEST);
        if (contextRoot == null && manifest != null) {
            contextRoot = ManifestHelper.getMainAttributeValue((Manifest)manifest, (String)"Web-ContextPath");
            mergedMetaData.setContextRoot(contextRoot);
        }
        warMetaData.setMergedJBossWebMetaData(mergedMetaData);
        if (mergedMetaData.isMetadataComplete()) {
            MetadataCompleteMarker.setMetadataComplete((DeploymentUnit)deploymentUnit, (boolean)true);
        }
        if (mergedMetaData.getJndiEnvironmentRefsGroup() != null) {
            DeploymentDescriptorEnvironment bindings = new DeploymentDescriptorEnvironment("java:module/env/", (RemoteEnvironment)mergedMetaData.getJndiEnvironmentRefsGroup());
            deploymentUnit.putAttachment(org.jboss.as.ee.component.Attachments.MODULE_DEPLOYMENT_DESCRIPTOR_ENVIRONMENT, (Object)bindings);
        }
        if (mergedMetaData.getModuleName() != null && !mergedMetaData.getModuleName().isEmpty()) {
            EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
            description.setModuleName(mergedMetaData.getModuleName());
        }
        if ((parent = deploymentUnit.getParent()) != null && (earMetaData = (EarMetaData)parent.getAttachment(org.jboss.as.ee.structure.Attachments.EAR_METADATA)) != null && (earSecurityRolesMetaData = earMetaData.getSecurityRoles()) != null) {
            if (mergedMetaData.getSecurityRoles() == null) {
                mergedMetaData.setSecurityRoles(new SecurityRolesMetaData());
            }
            SecurityRolesMetaDataMerger.merge((SecurityRolesMetaData)mergedMetaData.getSecurityRoles(), (SecurityRolesMetaData)mergedMetaData.getSecurityRoles(), (SecurityRolesMetaData)earSecurityRolesMetaData);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected static void resolveOrder(List<WebOrdering> webOrderings, List<String> order) {
        ArrayList<Ordering> work = new ArrayList<Ordering>();
        for (WebOrdering webOrdering : webOrderings) {
            Ordering ordering = new Ordering();
            ordering.ordering = webOrdering;
            ordering.afterOthers = webOrdering.isAfterOthers();
            ordering.beforeOthers = webOrdering.isBeforeOthers();
            if (ordering.afterOthers && ordering.beforeOthers) {
                throw new IllegalStateException(WebMessages.MESSAGES.invalidRelativeOrderingBeforeAndAfter(webOrdering.getJar()));
            }
            work.add(ordering);
        }
        for (Ordering ordering : work) {
            WebOrdering webOrdering = ordering.ordering;
            for (String name : webOrdering.getAfter()) {
                Iterator workIterator2 = work.iterator();
                boolean found = false;
                while (workIterator2.hasNext()) {
                    Ordering ordering2 = (Ordering)workIterator2.next();
                    if (!name.equals(ordering2.ordering.getName())) continue;
                    if (found) {
                        throw new IllegalStateException(WebMessages.MESSAGES.invalidRelativeOrderingDuplicateName(webOrdering.getJar()));
                    }
                    ordering.addAfter(ordering2);
                    ordering2.addBefore(ordering);
                    found = true;
                }
                if (found) continue;
                throw new IllegalStateException(WebMessages.MESSAGES.invalidRelativeOrderingUnknownName(webOrdering.getJar()));
            }
            for (String name : webOrdering.getBefore()) {
                Iterator workIterator2 = work.iterator();
                boolean found = false;
                while (workIterator2.hasNext()) {
                    Ordering ordering2 = (Ordering)workIterator2.next();
                    if (!name.equals(ordering2.ordering.getName())) continue;
                    if (found) {
                        throw new IllegalStateException(WebMessages.MESSAGES.invalidRelativeOrderingDuplicateName(webOrdering.getJar()));
                    }
                    ordering.addBefore(ordering2);
                    ordering2.addAfter(ordering);
                    found = true;
                }
                if (found) continue;
                throw new IllegalStateException(WebMessages.MESSAGES.invalidRelativeOrderingUnknownName(webOrdering.getJar()));
            }
        }
        Iterator workIterator = work.iterator();
        while (workIterator.hasNext()) {
            ((Ordering)workIterator.next()).validate();
        }
        ArrayList<Ordering> tempOrder = new ArrayList<Ordering>();
        for (Ordering ordering : work) {
            int pos;
            int i;
            int insertAfter;
            if (ordering.beforeOthers) {
                insertAfter = -1;
                boolean last = ordering.isLastBeforeOthers();
                int lastBeforeOthers = -1;
                for (i = 0; i < tempOrder.size(); ++i) {
                    if (ordering.isAfter((Ordering)tempOrder.get(i))) {
                        insertAfter = i;
                    }
                    if (!((Ordering)tempOrder.get((int)i)).beforeOthers) continue;
                    lastBeforeOthers = i;
                }
                pos = insertAfter;
                if (last && lastBeforeOthers > insertAfter) {
                    pos = lastBeforeOthers;
                }
                tempOrder.add(pos + 1, ordering);
                continue;
            }
            if (ordering.afterOthers) {
                int insertBefore = tempOrder.size();
                boolean first = ordering.isFirstAfterOthers();
                int firstAfterOthers = tempOrder.size();
                for (i = tempOrder.size() - 1; i >= 0; --i) {
                    if (ordering.isBefore((Ordering)tempOrder.get(i))) {
                        insertBefore = i;
                    }
                    if (!((Ordering)tempOrder.get((int)i)).afterOthers) continue;
                    firstAfterOthers = i;
                }
                pos = insertBefore;
                if (first && firstAfterOthers < insertBefore) {
                    pos = firstAfterOthers;
                }
                tempOrder.add(pos, ordering);
                continue;
            }
            insertAfter = -1;
            int insertBefore = tempOrder.size();
            for (int i2 = 0; i2 < tempOrder.size(); ++i2) {
                if (ordering.isAfter((Ordering)tempOrder.get(i2)) || ((Ordering)tempOrder.get((int)i2)).beforeOthers) {
                    insertAfter = i2;
                }
                if (!ordering.isBefore((Ordering)tempOrder.get(i2)) && !((Ordering)tempOrder.get((int)i2)).afterOthers) continue;
                insertBefore = i2;
            }
            if (insertAfter > insertBefore) {
                throw new IllegalStateException(WebMessages.MESSAGES.invalidRelativeOrderingConflict(ordering.ordering.getJar()));
            }
            tempOrder.add(insertAfter + 1, ordering);
        }
        for (Ordering ordering : tempOrder) {
            order.add(ordering.ordering.getJar());
        }
    }

    protected static class Ordering {
        protected WebOrdering ordering;
        protected Set<Ordering> after = new HashSet<Ordering>();
        protected Set<Ordering> before = new HashSet<Ordering>();
        protected boolean afterOthers = false;
        protected boolean beforeOthers = false;

        protected Ordering() {
        }

        public boolean addAfter(Ordering ordering) {
            return this.after.add(ordering);
        }

        public boolean addBefore(Ordering ordering) {
            return this.before.add(ordering);
        }

        public void validate() {
            this.isBefore(new Ordering());
            this.isAfter(new Ordering());
        }

        public boolean isBefore(Ordering ordering) {
            return this.isBeforeInternal(ordering, new HashSet<Ordering>());
        }

        protected boolean isBeforeInternal(Ordering ordering, Set<Ordering> checked) {
            checked.add(this);
            if (this.before.contains(ordering)) {
                return true;
            }
            for (Ordering check : this.before) {
                if (checked.contains(check)) {
                    throw new IllegalStateException(WebMessages.MESSAGES.invalidRelativeOrdering(this.ordering.getJar()));
                }
                if (!check.isBeforeInternal(ordering, checked)) continue;
                return false;
            }
            return false;
        }

        public boolean isAfter(Ordering ordering) {
            return this.isAfterInternal(ordering, new HashSet<Ordering>());
        }

        protected boolean isAfterInternal(Ordering ordering, Set<Ordering> checked) {
            checked.add(this);
            if (this.after.contains(ordering)) {
                return true;
            }
            for (Ordering check : this.after) {
                if (checked.contains(check)) {
                    throw new IllegalStateException(WebMessages.MESSAGES.invalidRelativeOrdering(this.ordering.getJar()));
                }
                if (!check.isAfterInternal(ordering, checked)) continue;
                return false;
            }
            return false;
        }

        public boolean isLastBeforeOthers() {
            if (!this.beforeOthers) {
                throw new IllegalStateException();
            }
            for (Ordering check : this.before) {
                if (!check.beforeOthers) {
                    return true;
                }
                if (!check.isLastBeforeOthers()) continue;
                return true;
            }
            return false;
        }

        public boolean isFirstAfterOthers() {
            if (!this.afterOthers) {
                throw new IllegalStateException();
            }
            for (Ordering check : this.after) {
                if (!check.afterOthers) {
                    return true;
                }
                if (!check.isFirstAfterOthers()) continue;
                return true;
            }
            return false;
        }
    }

    protected static class WebOrdering
    implements Serializable {
        private static final long serialVersionUID = 5603203103871892211L;
        protected String jar = null;
        protected String name = null;
        protected List<String> after = new ArrayList<String>();
        protected List<String> before = new ArrayList<String>();
        protected boolean afterOthers = false;
        protected boolean beforeOthers = false;

        protected WebOrdering() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getAfter() {
            return this.after;
        }

        public void addAfter(String name) {
            this.after.add(name);
        }

        public List<String> getBefore() {
            return this.before;
        }

        public void addBefore(String name) {
            this.before.add(name);
        }

        public String getJar() {
            return this.jar;
        }

        public void setJar(String jar) {
            this.jar = jar;
        }

        public boolean isAfterOthers() {
            return this.afterOthers;
        }

        public void setAfterOthers(boolean afterOthers) {
            this.afterOthers = afterOthers;
        }

        public boolean isBeforeOthers() {
            return this.beforeOthers;
        }

        public void setBeforeOthers(boolean beforeOthers) {
            this.beforeOthers = beforeOthers;
        }
    }
}

