/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.parser;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelImage;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssChannelTextInput;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.parser.RssParser;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class RssParserImpl090
extends RssParser {
    protected boolean inChannel = false;
    protected boolean inItem = false;
    protected boolean inTextInput = false;
    protected boolean inImage = false;
    private static final String VERSION = "0.90";

    RssParserImpl090(RssDocument document, Vector namespaces) {
        super(document, namespaces);
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) throws SAXException {
        if ("channel".equals(name)) {
            this.currentChannel = new RssChannel();
            this.inChannel = true;
        }
        if ("item".equals(name)) {
            this.currentItem = new RssChannelItem();
            this.inItem = true;
        }
        if ("textInput".equals(name)) {
            this.currentTextInput = new RssChannelTextInput();
            this.inTextInput = true;
        }
        if ("image".equals(name)) {
            this.currentImage = new RssChannelImage();
            this.inImage = true;
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if ("channel".equals(name)) {
            this.closeChannelElement();
            return;
        }
        if ("item".equals(name)) {
            this.closeItemElement();
            return;
        }
        if ("textInput".equals(name)) {
            this.closeTextInputElement();
            return;
        }
        if ("image".equals(name)) {
            this.closeImageElement();
            return;
        }
        if (!this.hasChars()) {
            return;
        }
        if ("title".equals(name)) {
            this.handleTitleAttribute();
        }
        if ("description".equals(name)) {
            this.handleDescriptionAttribute();
        }
        if ("link".equals(name)) {
            this.handleLinkAttribute();
        }
        if ("url".equals(name)) {
            this.handleUrlAttribute();
        }
        if ("name".equals(name)) {
            this.handleNameAttribute();
        }
        if (VERSION.equals(this.document.getVersion())) {
            this.resetChars();
        }
    }

    private void closeChannelElement() {
        if (this.currentChannel != null) {
            this.document.addChannel(this.currentChannel);
            this.currentChannel = null;
        }
        this.inChannel = false;
    }

    private void closeItemElement() {
        if (this.currentItem != null && this.currentChannel != null) {
            this.currentChannel.addItem(this.currentItem);
            this.currentItem = null;
        }
        this.inItem = false;
    }

    private void closeTextInputElement() {
        if (this.currentTextInput != null && this.currentChannel != null) {
            this.currentChannel.setChannelTextInput(this.currentTextInput);
            this.currentTextInput = null;
        }
        this.inTextInput = false;
    }

    private void closeImageElement() {
        if (this.currentImage != null && this.currentChannel != null) {
            this.currentChannel.setChannelImage(this.currentImage);
            this.currentImage = null;
        }
        this.inImage = false;
    }

    private void handleTitleAttribute() {
        if (this.inTextInput) {
            this.currentTextInput.setInputTitle(this.getChars());
        } else if (this.inImage) {
            this.currentImage.setImageTitle(this.getChars());
        } else if (this.inItem) {
            this.currentItem.setItemTitle(this.getChars());
        } else if (this.inChannel) {
            this.currentChannel.setChannelTitle(this.getChars());
        }
    }

    private void handleDescriptionAttribute() {
        if (this.inTextInput) {
            this.currentTextInput.setInputDescription(this.getChars());
        } else if (this.inChannel && !this.inItem && !this.inImage) {
            this.currentChannel.setChannelDescription(this.getChars());
        }
    }

    private void handleLinkAttribute() {
        if (this.inTextInput) {
            this.currentTextInput.setInputLink(this.getChars());
        } else if (this.inImage) {
            this.currentImage.setImageLink(this.getChars());
        } else if (this.inItem) {
            this.currentItem.setItemLink(this.getChars());
        } else if (this.inChannel) {
            this.currentChannel.setChannelLink(this.getChars());
        }
    }

    private void handleUrlAttribute() {
        if (this.inImage) {
            this.currentImage.setImageUrl(this.getChars());
        }
    }

    private void handleNameAttribute() {
        if (this.inTextInput) {
            this.currentTextInput.setInputName(this.getChars());
        }
    }
}

