/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.parser;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelImage;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssChannelTextInput;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.model.RssNamespace;
import churchillobjects.rss4j.model.RssVersion;
import churchillobjects.rss4j.parser.RssParseException;
import churchillobjects.rss4j.parser.RssParserImpl090;
import churchillobjects.rss4j.parser.RssParserImpl091;
import churchillobjects.rss4j.parser.RssParserImpl100;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class RssParser
extends DefaultHandler
implements RssVersion {
    private XMLReader parser;
    protected RssDocument document;
    protected RssChannel currentChannel;
    protected RssChannelItem currentItem;
    protected RssChannelTextInput currentTextInput;
    protected RssChannelImage currentImage;
    private StringBuffer characters;
    protected Vector namespaces;

    public static RssDocument parseRss(String rss) throws RssParseException {
        StringReader sr = new StringReader(rss);
        InputSource inputSource = new InputSource(sr);
        RssParser parser = new RssParser();
        return parser.parseRss(inputSource);
    }

    public static RssDocument parseRss(InputStream is) throws RssParseException {
        InputSource inputSource = new InputSource(is);
        RssParser parser = new RssParser();
        return parser.parseRss(inputSource);
    }

    public static RssDocument parseRss(Reader r) throws RssParseException {
        InputSource inputSource = new InputSource(r);
        RssParser parser = new RssParser();
        return parser.parseRss(inputSource);
    }

    public static RssDocument parseRss(File file) throws RssParseException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RssParseException(e);
        }
        InputSource inputSource = new InputSource(fis);
        RssParser parser = new RssParser();
        return parser.parseRss(inputSource);
    }

    RssParser() {
        this.namespaces = new Vector();
    }

    RssParser(RssDocument document, Vector namespaces) {
        this.document = document;
        this.namespaces = namespaces;
    }

    RssDocument parseRss(InputSource is) throws RssParseException {
        this.document = new RssDocument();
        this.namespaces = new Vector();
        this.characters = new StringBuffer();
        this.parser = new SAXParser();
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        try {
            this.parser.parse(is);
        }
        catch (SAXException e) {
            this.cleanUp();
            if (e.getException() instanceof RssParseException) {
                throw (RssParseException)e.getException();
            }
            throw new RssParseException(e.getException());
        }
        catch (IOException e) {
            this.cleanUp();
            throw new RssParseException(e);
        }
        RssDocument returnDoc = this.document;
        this.cleanUp();
        return returnDoc;
    }

    protected void cleanUp() {
        this.parser = null;
        this.document = null;
        this.currentChannel = null;
        this.currentItem = null;
        this.currentTextInput = null;
        this.currentImage = null;
        this.characters = null;
        this.namespaces = null;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.addElement(new RssNamespace(prefix, uri));
        if (prefix.length() == 0) {
            if ("http://my.netscape.com/rdf/simple/0.9/".equals(uri)) {
                this.document.setVersion("0.90");
                RssParserImpl090 handler = new RssParserImpl090(this.document, this.namespaces);
                this.parser.setContentHandler(handler);
                this.parser.setErrorHandler(handler);
            } else if ("http://purl.org/rss/1.0/".equals(uri)) {
                this.document.setVersion("1.0");
                RssParserImpl100 handler = new RssParserImpl100(this.document, this.namespaces);
                this.parser.setContentHandler(handler);
                this.parser.setErrorHandler(handler);
            } else {
                throw new SAXException(new RssParseException("Could not determine the RSS version from namespace: " + uri));
            }
        }
    }

    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        if (name.equals("rss")) {
            String version = atts.getValue("version");
            if (version.equals("0.91")) {
                this.document.setVersion("0.91");
                RssParserImpl091 handler = new RssParserImpl091(this.document, null);
                this.parser.setContentHandler(handler);
                this.parser.setErrorHandler(handler);
            } else {
                if (version.equals("0.92")) {
                    throw new SAXException(new RssParseException("RSS 0.92 not supported by this toolkit"));
                }
                throw new SAXException(new RssParseException("Could not determine the RSS version: " + version));
            }
        }
        if (name.equals("channel")) {
            throw new SAXException(new RssParseException("Could not determine the RSS version of this document."));
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.characters == null) {
            this.characters = new StringBuffer();
        }
        this.characters.append(ch, start, length);
    }

    protected String getChars() {
        if (this.characters == null) {
            return "";
        }
        String s = this.characters.toString().trim();
        this.resetChars();
        return s;
    }

    protected boolean hasChars() {
        if (this.characters == null) {
            return false;
        }
        return this.characters.toString().trim().length() > 0;
    }

    protected void resetChars() {
        this.characters = null;
    }

    protected String getAttribute(Attributes attrs, String name) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String qname = attrs.getQName(i);
            if (!qname.equals(name)) continue;
            return attrs.getValue(i);
        }
        return null;
    }
}

