/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.generator;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.RssDublinCore;
import churchillobjects.rss4j.RssJbnDependency;
import churchillobjects.rss4j.RssJbnPatch;
import churchillobjects.rss4j.generator.RssGenerationException;
import churchillobjects.rss4j.generator.RssGenerator;
import churchillobjects.rss4j.generator.RssGeneratorImpl100;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RssGeneratorTest
extends TestCase {
    public void testBuildFile() {
        String inputFilePath = "testFiles\\jbnPatchFeed_multiple_patchDependencies.xml";
        File inputFile = new File(inputFilePath);
        String expected = this.readFileToString(inputFile);
        String outputFilePath = "testFiles\\outputJbnPatchGenerator.xml";
        File outputFile = new File(outputFilePath);
        try {
            RssDocument actualDocument = this.createDocument();
            RssGenerator.generateRss(actualDocument, outputFile);
        }
        catch (ParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
        catch (RssGenerationException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
        String actual = this.readFileToString(outputFile);
        TestCase.assertEquals((String)expected, (String)actual);
    }

    private RssDocument createDocument() throws ParseException {
        RssDocument document = new RssDocument();
        document.setVersion("1.0");
        RssChannel channel = new RssChannel();
        channel.setChannelDescription("channelDescription");
        channel.setChannelLink("http://channelLink.com");
        channel.setChannelTitle("channelTitle");
        channel.setChannelUri("http://channelURI");
        document.addChannel(channel);
        RssChannelItem item = new RssChannelItem();
        item.setItemDescription("itemDescription");
        item.setItemLink("http://itemLink.com");
        item.setItemTitle("itemTitle");
        RssDublinCore dc = new RssDublinCore();
        dc.setDate("2006-01-01T01:01:Z");
        dc.setTitle("rawTitle");
        item.setDublinCore(dc);
        RssJbnPatch jbn = new RssJbnPatch();
        jbn.setCaseId("9876");
        jbn.setLicenseName("LGPL");
        jbn.setLicenseVersion("2.0");
        jbn.setDistributionStatus("available");
        jbn.setCreator("itemCreator");
        jbn.setFileName("fileName.txt");
        jbn.setFileSize("12345");
        jbn.setDownloadUrl("http://downloadUrl.com");
        jbn.setAutomatedDownloadUrl("http://automatedDownloadUrl.com");
        jbn.setJira("JBAS-1234");
        jbn.setMd5("12345678901234567890123456789012");
        jbn.setSha256("1234567890123456789012345678901234567890123456789012345678901234");
        jbn.setType("itemType");
        jbn.setLongDescription("longDescription");
        jbn.setShortDescription("shortDescription");
        jbn.setManualInstallation("manualInstallation");
        jbn.setAutomatedInstallation("automatedInstallation");
        jbn.setLastUpdated("2006-01-03T01:01:Z");
        jbn.setInstructionCompatibilityVersion("1.4");
        jbn.addProduct(new RssJbnDependency("http://product1.com", "product1; 1.0", "product1", "1.0", "jon_product1", "jon_1.0"));
        jbn.addProduct(new RssJbnDependency("http://product2.com", "product2; 1.0", "product2", "1.0", "jon_product2", "jon_1.0"));
        jbn.addReplacedBy(new RssJbnDependency("http://patch1.com", "PATCH-1"));
        jbn.addReplacedBy(new RssJbnDependency("http://patch2.com", "PATCH-2"));
        jbn.addReplaces(new RssJbnDependency("http://patch3.com", "PATCH-3"));
        jbn.addReplaces(new RssJbnDependency("http://patch4.com", "PATCH-4"));
        jbn.addRequires(new RssJbnDependency("http://patch5.com", "PATCH-5"));
        jbn.addRequires(new RssJbnDependency("http://patch6.com", "PATCH-6"));
        jbn.addRequires(new RssJbnDependency("http://patch7.com", "PATCH-7"));
        jbn.addCompatibleWith(new RssJbnDependency("http://product3.com", "product3; 1.0"));
        jbn.addCompatibleWith(new RssJbnDependency("http://product4.com", "product4; 1.0"));
        item.setJbnPatch(jbn);
        channel.addItem(item);
        return document;
    }

    private String readFileToString(File file) {
        StringBuffer buffer = new StringBuffer(100);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String input = null;
            do {
                if ((input = reader.readLine()) == null) continue;
                buffer.append(input.trim());
            } while (input != null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            TestCase.fail((String)ioe.getMessage());
        }
        return buffer.toString();
    }

    public void xxtestSubNodeWithAttributes() {
        try {
            Document expected = this.createDocumentFromFile("testFiles/testSubNodeWithAttributes.xml");
            RssGeneratorImpl100 gen = new RssGeneratorImpl100();
            gen.doc = gen.domImpl.createDocument("http://purl.org/rss/1.0/", "RDF", null);
            Element baseElement = gen.doc.getDocumentElement();
            ArrayList<RssJbnDependency> dependencies = new ArrayList<RssJbnDependency>(3);
            RssJbnDependency dep1 = new RssJbnDependency("attributeValue1", "innerNodeValue1");
            RssJbnDependency dep2 = new RssJbnDependency("attributeValue2", "innerNodeValue2");
            RssJbnDependency dep3 = new RssJbnDependency("attributeValue3", "innerNodeValue3");
            dependencies.add(dep1);
            dependencies.add(dep2);
            dependencies.add(dep3);
            gen.add(baseElement, "outerNodeName", "innerNodeName", "attributeName", dependencies);
            System.out.println("expected");
            RssGeneratorTest.printXMLfromDOMt(expected.getDocumentElement());
            System.out.println("actual");
            RssGeneratorTest.printXMLfromDOMt(gen.doc.getDocumentElement());
            TestCase.assertEquals((Object)expected, (Object)gen.doc);
        }
        catch (RssGenerationException e) {
            TestCase.fail((String)e.getMessage());
        }
    }

    private Document createDocumentFromFile(String filePath) {
        Document doc = null;
        try {
            File file = new File(filePath);
            TestCase.assertTrue((String)("the file does not exist: " + filePath), (boolean)file.exists());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
        }
        catch (ParserConfigurationException e) {
            TestCase.fail((String)e.getMessage());
        }
        catch (SAXException e) {
            TestCase.fail((String)e.getMessage());
        }
        catch (IOException e) {
            TestCase.fail((String)e.getMessage());
        }
        return doc;
    }

    private static void createStringXMLfromDOMt(Element element, StringBuffer buf) {
        int k;
        NodeList children = element.getChildNodes();
        buf.append("<");
        buf.append(element.getNodeName());
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            for (k = 0; k < attributes.getLength(); ++k) {
                buf.append(" ");
                buf.append(attributes.item(k).getNodeName());
                buf.append("=");
                buf.append(attributes.item(k).getNodeValue());
            }
        }
        if (element.hasChildNodes()) {
            buf.append(">\n");
            for (k = 0; k < children.getLength(); ++k) {
                if (children.item(k).getNodeType() == 1) {
                    RssGeneratorTest.createStringXMLfromDOMt((Element)children.item(k), buf);
                    continue;
                }
                if (children.item(k).getNodeType() != 3) continue;
                buf.append(children.item(k).getNodeValue());
            }
            buf.append("</");
            buf.append(element.getNodeName() + ">\n");
        } else {
            buf.append(" />\n");
        }
    }

    private static void printXMLfromDOMt(Element element) {
        int k;
        NodeList children = element.getChildNodes();
        System.out.print("<" + element.getNodeName());
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            for (k = 0; k < attributes.getLength(); ++k) {
                System.out.print(" " + attributes.item(k).getNodeName());
                System.out.print("=" + attributes.item(k).getNodeValue());
            }
        }
        if (element.hasChildNodes()) {
            System.out.print(">");
            for (k = 0; k < children.getLength(); ++k) {
                if (children.item(k).getNodeType() == 1) {
                    RssGeneratorTest.printXMLfromDOMt((Element)children.item(k));
                    continue;
                }
                if (children.item(k).getNodeType() != 3) continue;
                System.out.print(children.item(k).getNodeValue());
            }
            System.out.print("</" + element.getNodeName() + ">");
        } else {
            System.out.print(" />");
        }
    }
}

