/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

import org.hibernate.stat.SecondLevelCacheStatistics;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.jpa.hibernate4.management.ManagementLookup;
import org.jboss.as.jpa.spi.PersistenceUnitServiceRegistry;
import org.jboss.dmr.ModelNode;

public abstract class SecondLevelCacheMetricsHandler
extends AbstractRuntimeOnlyHandler {
    private final PersistenceUnitServiceRegistry persistenceUnitRegistry;

    private SecondLevelCacheMetricsHandler(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        this.persistenceUnitRegistry = persistenceUnitRegistry;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        SecondLevelCacheStatistics statistics = this.getSecondLevelCacheStatistics(operation);
        if (statistics != null) {
            this.handle(statistics, context, operation.require("name").asString());
        }
        context.stepCompleted();
    }

    protected abstract void handle(SecondLevelCacheStatistics var1, OperationContext var2, String var3);

    private SecondLevelCacheStatistics getSecondLevelCacheStatistics(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String puResourceName = address.getElement(address.size() - 2).getValue();
        String regionName = puResourceName + "." + address.getLastElement().getValue();
        ManagementLookup stats = ManagementLookup.create(this.persistenceUnitRegistry, puResourceName);
        return stats == null ? null : stats.getStatistics().getSecondLevelCacheStatistics(regionName);
    }

    static final SecondLevelCacheMetricsHandler getHitCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new SecondLevelCacheMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(SecondLevelCacheStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getHitCount();
                context.getResult().set(count);
            }
        };
    }

    static final SecondLevelCacheMetricsHandler getMissCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new SecondLevelCacheMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(SecondLevelCacheStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getMissCount();
                context.getResult().set(count);
            }
        };
    }

    static final SecondLevelCacheMetricsHandler getPutCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new SecondLevelCacheMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(SecondLevelCacheStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getPutCount();
                context.getResult().set(count);
            }
        };
    }

    static final SecondLevelCacheMetricsHandler getElementCountInMemory(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new SecondLevelCacheMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(SecondLevelCacheStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getElementCountInMemory();
                context.getResult().set(count);
            }
        };
    }
}

