/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.infinispan;

import java.security.AccessController;
import java.util.Properties;
import org.infinispan.AdvancedCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.jpa.hibernate4.infinispan.InfinispanRegionFactory;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;

public class SharedInfinispanRegionFactory
extends InfinispanRegionFactory {
    private static final long serialVersionUID = -3277051412715973863L;

    public SharedInfinispanRegionFactory() {
    }

    public SharedInfinispanRegionFactory(Properties props) {
        super(props);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager(Properties properties) {
        String container = properties.getProperty("hibernate.cache.infinispan.container", "hibernate");
        ServiceName serviceName = EmbeddedCacheManagerService.getServiceName((String)container);
        ServiceContainer registry = SharedInfinispanRegionFactory.currentServiceContainer();
        return (EmbeddedCacheManager)registry.getRequiredService(serviceName).getValue();
    }

    @Override
    protected void stopCacheManager() {
    }

    @Override
    protected AdvancedCache createCacheWrapper(AdvancedCache cache) {
        cache.start();
        return cache;
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }
}

