/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.ipfilter;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.netty.handler.ipfilter.CIDR;
import org.jboss.netty.handler.ipfilter.CIDR6;

public class CIDR4
extends CIDR {
    private int addressInt;
    private final int addressEndInt;

    protected CIDR4(Inet4Address newaddr, int mask) {
        this.cidrMask = mask;
        this.addressInt = CIDR4.ipv4AddressToInt(newaddr);
        int newmask = CIDR4.ipv4PrefixLengthToMask(mask);
        this.addressInt &= newmask;
        try {
            this.baseAddress = CIDR4.intToIPv4Address(this.addressInt);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        this.addressEndInt = this.addressInt + CIDR4.ipv4PrefixLengthToLength(this.cidrMask) - 1;
    }

    @Override
    public InetAddress getEndAddress() {
        try {
            return CIDR4.intToIPv4Address(this.addressEndInt);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public int compareTo(CIDR arg) {
        if (arg instanceof CIDR6) {
            byte[] address = CIDR4.getIpV4FromIpV6((Inet6Address)arg.baseAddress);
            int net = CIDR4.ipv4AddressToInt(address);
            if (net == this.addressInt && arg.cidrMask == this.cidrMask) {
                return 0;
            }
            if (net < this.addressInt) {
                return 1;
            }
            if (net > this.addressInt) {
                return -1;
            }
            if (arg.cidrMask < this.cidrMask) {
                return -1;
            }
            return 1;
        }
        CIDR4 o = (CIDR4)arg;
        if (o.addressInt == this.addressInt && o.cidrMask == this.cidrMask) {
            return 0;
        }
        if (o.addressInt < this.addressInt) {
            return 1;
        }
        if (o.addressInt > this.addressInt) {
            return -1;
        }
        if (o.cidrMask < this.cidrMask) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean contains(InetAddress inetAddress) {
        int search = CIDR4.ipv4AddressToInt(inetAddress);
        return search >= this.addressInt && search <= this.addressEndInt;
    }

    private static int ipv4PrefixLengthToLength(int prefixLength) {
        return 1 << 32 - prefixLength;
    }

    private static int ipv4PrefixLengthToMask(int prefixLength) {
        return ~((1 << 32 - prefixLength) - 1);
    }

    private static InetAddress intToIPv4Address(int addr) throws UnknownHostException {
        byte[] a = new byte[]{(byte)(addr >> 24 & 0xFF), (byte)(addr >> 16 & 0xFF), (byte)(addr >> 8 & 0xFF), (byte)(addr & 0xFF)};
        return InetAddress.getByAddress(a);
    }

    private static int ipv4AddressToInt(InetAddress addr) {
        byte[] address = addr instanceof Inet6Address ? CIDR4.getIpV4FromIpV6((Inet6Address)addr) : addr.getAddress();
        return CIDR4.ipv4AddressToInt(address);
    }

    private static int ipv4AddressToInt(byte[] address) {
        int net = 0;
        for (byte addres : address) {
            net <<= 8;
            net |= addres & 0xFF;
        }
        return net;
    }
}

