/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.protocol.v1;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.naming.remote.protocol.CancellableDataOutputStream;
import org.jboss.remoting3.Channel;
import org.xnio.IoUtils;

class WriteUtil {
    static final MarshallerFactory marshallerFactory = Marshalling.getProvidedMarshallerFactory("river");

    WriteUtil() {
    }

    static void write(Channel channel, Writer writer) throws IOException {
        CancellableDataOutputStream output = new CancellableDataOutputStream(channel.writeMessage());
        try {
            writer.write(output);
        }
        catch (IOException e) {
            output.cancel();
            throw e;
        }
        finally {
            IoUtils.safeClose(output);
        }
    }

    static void writeResponse(Channel channel, final byte command, final int correlationId) throws IOException {
        WriteUtil.write(channel, new Writer(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(command);
                output.writeInt(correlationId);
                output.writeByte(0);
            }
        });
    }

    static void writeExceptionResponse(Channel channel, final Exception e, final byte command, final int correlationId) throws IOException {
        WriteUtil.write(channel, new Writer(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(command);
                output.writeInt(correlationId);
                output.writeByte(1);
                output.writeByte(2);
                Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                marshaller.writeObject(e);
                marshaller.finish();
            }
        });
    }

    static void writeResponse(Channel channel, final Object response, final byte command, final int correlationId) throws IOException {
        WriteUtil.write(channel, new Writer(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(command);
                output.writeInt(correlationId);
                output.writeByte(0);
                output.writeByte(1);
                Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                marshaller.writeObject(response);
                marshaller.finish();
            }
        });
    }

    static Marshaller prepareForMarshalling(final DataOutput dataOutput) throws IOException {
        Marshaller marshaller = WriteUtil.getMarshaller(marshallerFactory);
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                int byteToWrite = b & 0xFF;
                dataOutput.write(byteToWrite);
            }

            @Override
            public void write(byte[] b) throws IOException {
                dataOutput.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                dataOutput.write(b, off, len);
            }
        };
        ByteOutput byteOutput = Marshalling.createByteOutput(outputStream);
        marshaller.start(byteOutput);
        return marshaller;
    }

    static Marshaller getMarshaller(MarshallerFactory marshallerFactory) throws IOException {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        return marshallerFactory.createMarshaller(marshallingConfiguration);
    }

    static {
        if (marshallerFactory == null) {
            throw new RuntimeException("Could not find a marshaller factory for river marshalling strategy");
        }
    }

    static interface Writer {
        public void write(DataOutput var1) throws IOException;
    }
}

