/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.xml.bind.DatatypeConverter;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.DefaultCallbackHandler;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.PropertiesValueResolver;
import org.jboss.ejb.client.RandomDeploymentNodeSelector;
import org.jboss.ejb.client.SecurityActions;
import org.jboss.ejb.client.remoting.RemotingConnectionUtil;
import org.jboss.logging.Logger;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class PropertiesBasedEJBClientConfiguration
implements EJBClientConfiguration {
    private static final Logger logger = Logger.getLogger(PropertiesBasedEJBClientConfiguration.class);
    private static final String PROPERTY_KEY_ENDPOINT_NAME = "endpoint.name";
    private static final String DEFAULT_ENDPOINT_NAME = "config-based-ejb-client-endpoint";
    private static final String PROPERTY_KEY_INVOCATION_TIMEOUT = "invocation.timeout";
    private static final String PROPERTY_KEY_RECONNECT_TASKS_TIMEOUT = "reconnect.tasks.timeout";
    private static final String PROPERTY_KEY_DEPLOYMENT_NODE_SELECTOR = "deployment.node.selector";
    private static final String ENDPOINT_CREATION_OPTIONS_PREFIX = "endpoint.create.options.";
    private static final OptionMap DEFAULT_ENDPOINT_CREATION_OPTIONS = OptionMap.create(Options.THREAD_DAEMON, true);
    private static final OptionMap DEFAULT_CONNECTION_PROVIDER_CREATION_OPTIONS = OptionMap.EMPTY;
    private static final String REMOTE_CONNECTION_PROVIDER_CREATE_OPTIONS_PREFIX = "remote.connectionprovider.create.options.";
    private static final String PROPERTY_KEY_REMOTE_CONNECTIONS = "remote.connections";
    private static final OptionMap DEFAULT_CONNECTION_CREATION_OPTIONS = OptionMap.EMPTY;
    private static final long DEFAULT_CONNECTION_TIMEOUT_IN_MILLIS = 5000L;
    private static final String PROPERTY_KEY_USERNAME = "username";
    private static final String PROPERTY_KEY_PASSWORD = "password";
    private static final String PROPERTY_KEY_PASSWORD_BASE64 = "password.base64";
    private static final String PROPERTY_KEY_REALM = "realm";
    private static final String PROPERTY_KEY_CALLBACK_HANDLER_CLASS = "callback.handler.class";
    private static final String PROPERTY_KEY_CLUSTERS = "remote.clusters";
    private final Properties ejbReceiversConfigurationProperties;
    private String endPointName;
    private OptionMap endPointCreationOptions;
    private OptionMap remoteConnectionProviderCreationOptions;
    private CallbackHandler callbackHandler;
    private Collection<EJBClientConfiguration.RemotingConnectionConfiguration> remotingConnectionConfigurations = new ArrayList<EJBClientConfiguration.RemotingConnectionConfiguration>();
    private Map<String, EJBClientConfiguration.ClusterConfiguration> clusterConfigurations = new HashMap<String, EJBClientConfiguration.ClusterConfiguration>();
    private long invocationTimeout = 0L;
    private long reconnectTasksTimeout = 0L;
    private DeploymentNodeSelector deploymentNodeSelector = new RandomDeploymentNodeSelector();
    private static final boolean expandPasswords = Boolean.valueOf(System.getProperty("jboss-ejb-client.expandPasswords", "false"));

    public PropertiesBasedEJBClientConfiguration(Properties properties) {
        Properties resolvedProperties = new Properties();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    boolean propertyIsAPassword;
                    boolean bl = propertyIsAPassword = ((String)entry.getKey()).indexOf(PROPERTY_KEY_PASSWORD) >= 0;
                    if (!propertyIsAPassword || propertyIsAPassword && expandPasswords) {
                        value = PropertiesValueResolver.replaceProperties((String)value);
                    }
                }
                resolvedProperties.put(entry.getKey(), value);
            }
        }
        this.ejbReceiversConfigurationProperties = resolvedProperties;
        this.parseProperties();
    }

    @Override
    public String getEndpointName() {
        return this.endPointName;
    }

    @Override
    public OptionMap getEndpointCreationOptions() {
        return this.endPointCreationOptions;
    }

    @Override
    public OptionMap getRemoteConnectionProviderCreationOptions() {
        return this.remoteConnectionProviderCreationOptions;
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public Iterator<EJBClientConfiguration.RemotingConnectionConfiguration> getConnectionConfigurations() {
        return this.remotingConnectionConfigurations.iterator();
    }

    @Override
    public Iterator<EJBClientConfiguration.ClusterConfiguration> getClusterConfigurations() {
        return this.clusterConfigurations.values().iterator();
    }

    @Override
    public EJBClientConfiguration.ClusterConfiguration getClusterConfiguration(String clusterName) {
        return this.clusterConfigurations.get(clusterName);
    }

    @Override
    public long getInvocationTimeout() {
        return this.invocationTimeout;
    }

    @Override
    public long getReconnectTasksTimeout() {
        return this.reconnectTasksTimeout;
    }

    @Override
    public DeploymentNodeSelector getDeploymentNodeSelector() {
        return this.deploymentNodeSelector;
    }

    private void parseProperties() {
        String deploymentNodeSelectorClassName;
        String reconnectTasksTimeoutValue;
        this.endPointName = this.ejbReceiversConfigurationProperties.getProperty(PROPERTY_KEY_ENDPOINT_NAME, DEFAULT_ENDPOINT_NAME);
        this.callbackHandler = this.getDefaultCallbackHandler();
        OptionMap endPointCreationOptionsFromConfiguration = this.getOptionMapFromProperties(this.ejbReceiversConfigurationProperties, ENDPOINT_CREATION_OPTIONS_PREFIX, PropertiesBasedEJBClientConfiguration.getClientClassLoader());
        this.endPointCreationOptions = this.mergeWithDefaults(DEFAULT_ENDPOINT_CREATION_OPTIONS, endPointCreationOptionsFromConfiguration);
        String invocationTimeoutValue = this.ejbReceiversConfigurationProperties.getProperty(PROPERTY_KEY_INVOCATION_TIMEOUT);
        if (invocationTimeoutValue != null && !invocationTimeoutValue.trim().isEmpty()) {
            try {
                this.invocationTimeout = Long.parseLong(invocationTimeoutValue.trim());
            }
            catch (NumberFormatException nfe) {
                Logs.MAIN.incorrectInvocationTimeoutValue(invocationTimeoutValue, String.valueOf(this.invocationTimeout));
            }
        }
        if ((reconnectTasksTimeoutValue = this.ejbReceiversConfigurationProperties.getProperty(PROPERTY_KEY_RECONNECT_TASKS_TIMEOUT)) != null && !reconnectTasksTimeoutValue.trim().isEmpty()) {
            try {
                this.reconnectTasksTimeout = Long.parseLong(reconnectTasksTimeoutValue.trim());
            }
            catch (NumberFormatException nfe) {
                Logs.MAIN.incorrectReconnectTasksTimeoutValue(reconnectTasksTimeoutValue, String.valueOf(this.reconnectTasksTimeout));
            }
        }
        if ((deploymentNodeSelectorClassName = this.ejbReceiversConfigurationProperties.getProperty(PROPERTY_KEY_DEPLOYMENT_NODE_SELECTOR)) != null) {
            ClassLoader classLoader = this.getClientClassLoader();
            try {
                Class<?> deploymentNodeSelectorClass = Class.forName(deploymentNodeSelectorClassName.trim(), true, classLoader);
                if (!DeploymentNodeSelector.class.isAssignableFrom(deploymentNodeSelectorClass)) {
                    throw Logs.MAIN.unexpectedDeploymentNodeSelectorClassType(deploymentNodeSelectorClass);
                }
                this.deploymentNodeSelector = (DeploymentNodeSelector)deploymentNodeSelectorClass.newInstance();
            }
            catch (Exception e) {
                throw Logs.MAIN.couldNotCreateDeploymentNodeSelector(e);
            }
        }
        OptionMap remoteConnectionProviderOptionsFromConfiguration = this.getOptionMapFromProperties(this.ejbReceiversConfigurationProperties, REMOTE_CONNECTION_PROVIDER_CREATE_OPTIONS_PREFIX, PropertiesBasedEJBClientConfiguration.getClientClassLoader());
        this.remoteConnectionProviderCreationOptions = this.mergeWithDefaults(DEFAULT_CONNECTION_PROVIDER_CREATION_OPTIONS, remoteConnectionProviderOptionsFromConfiguration);
        this.parseConnectionConfigurations();
        this.parseClusterConfigurations();
    }

    private OptionMap getOptionMapFromProperties(Properties properties, String propertyPrefix, ClassLoader classLoader) {
        OptionMap.Builder optionMapBuilder = OptionMap.builder().parseAll(properties, propertyPrefix, classLoader);
        OptionMap optionMap = optionMapBuilder.getMap();
        logger.debug(propertyPrefix + " has the following options " + optionMap);
        return optionMap;
    }

    private OptionMap mergeWithDefaults(OptionMap defaults, OptionMap overrides) {
        OptionMap.Builder combinedOptionsBuilder = OptionMap.builder().addAll(overrides);
        for (Option<?> defaultOption : defaults) {
            if (combinedOptionsBuilder.getMap().contains(defaultOption)) continue;
            Object defaultValue = defaults.get(defaultOption);
            combinedOptionsBuilder.set(defaultOption, defaultValue);
        }
        OptionMap combinedOptions = combinedOptionsBuilder.getMap();
        if (logger.isTraceEnabled()) {
            logger.trace("Options " + overrides + " have been merged with defaults " + defaults + " to form " + combinedOptions);
        }
        return combinedOptions;
    }

    private static ClassLoader getClientClassLoader() {
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        if (tccl != null) {
            return tccl;
        }
        return PropertiesBasedEJBClientConfiguration.class.getClassLoader();
    }

    private void parseClusterConfigurations() {
        String clusterNames = (String)this.ejbReceiversConfigurationProperties.get(PROPERTY_KEY_CLUSTERS);
        if (clusterNames == null || clusterNames.trim().isEmpty()) {
            logger.debug("No clusters configured in properties");
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(clusterNames, ",");
        while (tokenizer.hasMoreTokens()) {
            String clusterName = tokenizer.nextToken().trim();
            if (clusterName.isEmpty()) continue;
            EJBClientConfiguration.ClusterConfiguration clusterConfiguration = null;
            try {
                clusterConfiguration = this.createClusterConfiguration(clusterName);
            }
            catch (Exception e) {
                logger.warn((Object)("Could not create cluster configuration for cluster named " + clusterName), e);
            }
            if (clusterConfiguration == null) continue;
            logger.debug("Cluster configuration for cluster " + clusterName + " successfully created");
            this.clusterConfigurations.put(clusterName, clusterConfiguration);
        }
    }

    private EJBClientConfiguration.ClusterConfiguration createClusterConfiguration(String clusterName) {
        ClusterNodeSelector clusterNodeSelector;
        String clusterNodeSelectorClassName;
        String clusterSpecificPrefix = this.getClusterSpecificPrefix(clusterName);
        Map<String, String> clusterSpecificProperties = this.getPropertiesWithPrefix(clusterSpecificPrefix);
        if (clusterSpecificProperties.isEmpty()) {
            return null;
        }
        String maxConnectedNodesStringVal = clusterSpecificProperties.get("max-allowed-connected-nodes");
        long maxAllowedConnectedNodes = 10L;
        if (maxConnectedNodesStringVal != null && !maxConnectedNodesStringVal.trim().isEmpty()) {
            try {
                maxAllowedConnectedNodes = Long.parseLong(maxConnectedNodesStringVal.trim());
            }
            catch (NumberFormatException nfe) {
                Logs.MAIN.incorrectMaxAllowedConnectedNodesValueForCluster(maxConnectedNodesStringVal, clusterName, String.valueOf(maxAllowedConnectedNodes));
            }
        }
        String connectOptionsPrefix = this.getClusterSpecificConnectOptionsPrefix(clusterName);
        OptionMap connectOptionsFromConfiguration = this.getOptionMapFromProperties(this.ejbReceiversConfigurationProperties, connectOptionsPrefix, PropertiesBasedEJBClientConfiguration.getClientClassLoader());
        OptionMap connectOptions = this.mergeWithDefaults(DEFAULT_CONNECTION_CREATION_OPTIONS, connectOptionsFromConfiguration);
        long connectionTimeout = 5000L;
        String connectionTimeoutValue = clusterSpecificProperties.get("connect.timeout");
        if (connectionTimeoutValue != null && !connectionTimeoutValue.trim().isEmpty()) {
            try {
                connectionTimeout = Long.parseLong(connectionTimeoutValue.trim());
            }
            catch (NumberFormatException nfe) {
                Logs.MAIN.incorrectConnectionTimeoutValueForCluster(connectionTimeoutValue, clusterName, String.valueOf(5000L));
            }
        }
        if ((clusterNodeSelectorClassName = clusterSpecificProperties.get("clusternode.selector")) != null) {
            ClassLoader classLoader = this.getClientClassLoader();
            try {
                Class<?> clusterNodeSelectorClass = Class.forName(clusterNodeSelectorClassName.trim(), true, classLoader);
                if (!ClusterNodeSelector.class.isAssignableFrom(clusterNodeSelectorClass)) {
                    throw Logs.MAIN.unexpectedClusterNodeSelectorClassType(clusterNodeSelectorClass, clusterName);
                }
                clusterNodeSelector = (ClusterNodeSelector)clusterNodeSelectorClass.newInstance();
            }
            catch (Exception e) {
                throw Logs.MAIN.couldNotCreateClusterNodeSelector(e, clusterName);
            }
        } else {
            clusterNodeSelector = null;
        }
        CallbackHandler callbackHandler = this.createCallbackHandler(clusterSpecificProperties, this.getDefaultCallbackHandler());
        connectOptions = RemotingConnectionUtil.addSilentLocalAuthOptionsIfApplicable(callbackHandler, connectOptions);
        String channelOptionsPrefix = this.getClusterSpecificChannelOptionsPrefix(clusterName);
        OptionMap channelOptions = this.getOptionMapFromProperties(this.ejbReceiversConfigurationProperties, channelOptionsPrefix, PropertiesBasedEJBClientConfiguration.getClientClassLoader());
        ClusterConfigurationImpl clusterConfiguration = new ClusterConfigurationImpl(clusterName, maxAllowedConnectedNodes, connectOptions, callbackHandler, connectionTimeout, clusterNodeSelector, channelOptions);
        Collection<EJBClientConfiguration.ClusterNodeConfiguration> nodeConfigurations = this.parseClusterNodeConfigurations(clusterConfiguration, clusterSpecificProperties);
        clusterConfiguration.addNodeConfigurations(nodeConfigurations);
        return clusterConfiguration;
    }

    private Collection<EJBClientConfiguration.ClusterNodeConfiguration> parseClusterNodeConfigurations(EJBClientConfiguration.ClusterConfiguration clusterConfiguration, Map<String, String> clusterSpecificProperties) {
        ArrayList<EJBClientConfiguration.ClusterNodeConfiguration> nodeConfigurations = new ArrayList<EJBClientConfiguration.ClusterNodeConfiguration>();
        HashSet<String> parsedNodes = new HashSet<String>();
        for (String key : clusterSpecificProperties.keySet()) {
            EJBClientConfiguration.ClusterNodeConfiguration nodeConfiguration;
            String nodeName;
            String keyWithoutNodeDotPrefix;
            int nextDotIndex;
            if (!key.startsWith("node.") || (nextDotIndex = (keyWithoutNodeDotPrefix = key.substring("node.".length())).indexOf(".")) == -1 || parsedNodes.contains(nodeName = keyWithoutNodeDotPrefix.substring(0, nextDotIndex)) || (nodeConfiguration = this.createClusterNodeConfiguration(clusterConfiguration, nodeName)) == null) continue;
            nodeConfigurations.add(nodeConfiguration);
            parsedNodes.add(nodeConfiguration.getNodeName());
        }
        return nodeConfigurations;
    }

    private EJBClientConfiguration.ClusterNodeConfiguration createClusterNodeConfiguration(EJBClientConfiguration.ClusterConfiguration clusterConfiguration, String nodeName) {
        String clusterName = clusterConfiguration.getClusterName();
        String nodeSpecificPrefix = this.getClusterSpecificPrefix(clusterName) + "node." + nodeName + ".";
        Map<String, String> nodeSpecificProperties = this.getPropertiesWithPrefix(nodeSpecificPrefix);
        if (nodeSpecificProperties.isEmpty()) {
            return null;
        }
        String connectOptionsPrefix = this.getClusterNodeSpecificConnectOptionsPrefix(clusterName, nodeName);
        OptionMap connectOptionsFromConfiguration = this.getOptionMapFromProperties(this.ejbReceiversConfigurationProperties, connectOptionsPrefix, PropertiesBasedEJBClientConfiguration.getClientClassLoader());
        OptionMap connectOptions = this.mergeWithDefaults(clusterConfiguration.getConnectionCreationOptions(), connectOptionsFromConfiguration);
        long connectionTimeout = clusterConfiguration.getConnectionTimeout();
        String connectionTimeoutValue = nodeSpecificProperties.get("connect.timeout");
        if (connectionTimeoutValue != null && !connectionTimeoutValue.trim().isEmpty()) {
            try {
                connectionTimeout = Long.parseLong(connectionTimeoutValue.trim());
            }
            catch (NumberFormatException nfe) {
                Logs.MAIN.incorrectConnectionTimeoutValueForNodeInCluster(connectionTimeoutValue, nodeName, clusterName, String.valueOf(connectionTimeout));
            }
        }
        CallbackHandler callbackHandler = this.createCallbackHandler(nodeSpecificProperties, clusterConfiguration.getCallbackHandler());
        String channelOptionsPrefix = this.getClusterNodeSpecificChannelOptionsPrefix(clusterName, nodeName);
        OptionMap channelOptions = this.getOptionMapFromProperties(this.ejbReceiversConfigurationProperties, channelOptionsPrefix, PropertiesBasedEJBClientConfiguration.getClientClassLoader());
        return new ClusterNodeConfigurationImpl(nodeName, connectOptions, callbackHandler, connectionTimeout, channelOptions);
    }

    private void parseConnectionConfigurations() {
        String remoteConnectionNames = (String)this.ejbReceiversConfigurationProperties.get(PROPERTY_KEY_REMOTE_CONNECTIONS);
        if (remoteConnectionNames == null || remoteConnectionNames.trim().isEmpty()) {
            logger.debug("No remoting connections configured in properties");
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(remoteConnectionNames, ",");
        while (tokenizer.hasMoreTokens()) {
            String connectionName = tokenizer.nextToken().trim();
            if (connectionName.isEmpty()) continue;
            EJBClientConfiguration.RemotingConnectionConfiguration connectionConfiguration = null;
            try {
                connectionConfiguration = this.createConnectionConfiguration(connectionName);
            }
            catch (Exception e) {
                logger.warn((Object)("Could not create connection for connection named " + connectionName), e);
            }
            if (connectionConfiguration == null) continue;
            logger.debug("Connection " + connectionConfiguration + " successfully created for connection named " + connectionName);
            this.remotingConnectionConfigurations.add(connectionConfiguration);
        }
    }

    private EJBClientConfiguration.RemotingConnectionConfiguration createConnectionConfiguration(String connectionName) throws IOException, URISyntaxException {
        Integer port;
        String connectionSpecificPrefix = this.getConnectionSpecificPrefix(connectionName);
        Map<String, String> connectionSpecificProps = this.getPropertiesWithPrefix(connectionSpecificPrefix);
        if (connectionSpecificProps.isEmpty()) {
            return null;
        }
        String host = connectionSpecificProps.get("host");
        if (host == null || host.trim().isEmpty()) {
            Logs.MAIN.skippingConnectionCreationDueToMissingHostOrPort(connectionName);
            return null;
        }
        String portStringVal = connectionSpecificProps.get("port");
        if (portStringVal == null || portStringVal.trim().isEmpty()) {
            Logs.MAIN.skippingConnectionCreationDueToMissingHostOrPort(connectionName);
            return null;
        }
        try {
            port = Integer.parseInt(portStringVal.trim());
        }
        catch (NumberFormatException nfe) {
            Logs.MAIN.skippingConnectionCreationDueToInvalidPortNumber(portStringVal, connectionName);
            return null;
        }
        String connectOptionsPrefix = this.getConnectionSpecificConnectOptionsPrefix(connectionName);
        OptionMap connectOptionsFromConfiguration = this.getOptionMapFromProperties(this.ejbReceiversConfigurationProperties, connectOptionsPrefix, PropertiesBasedEJBClientConfiguration.getClientClassLoader());
        OptionMap connectOptions = this.mergeWithDefaults(DEFAULT_CONNECTION_CREATION_OPTIONS, connectOptionsFromConfiguration);
        long connectionTimeout = 5000L;
        String connectionTimeoutValue = connectionSpecificProps.get("connect.timeout");
        if (connectionTimeoutValue != null && !connectionTimeoutValue.trim().isEmpty()) {
            try {
                connectionTimeout = Long.parseLong(connectionTimeoutValue.trim());
            }
            catch (NumberFormatException nfe) {
                Logs.MAIN.incorrectConnectionTimeoutValueForConnection(connectionTimeoutValue, connectionName, String.valueOf(5000L));
            }
        }
        CallbackHandler callbackHandler = this.createCallbackHandler(connectionSpecificProps, this.getDefaultCallbackHandler());
        connectOptions = RemotingConnectionUtil.addSilentLocalAuthOptionsIfApplicable(callbackHandler, connectOptions);
        String channelOptionsPrefix = this.getConnectionSpecificChannelOptionsPrefix(connectionName);
        OptionMap channelOptions = this.getOptionMapFromProperties(this.ejbReceiversConfigurationProperties, channelOptionsPrefix, PropertiesBasedEJBClientConfiguration.getClientClassLoader());
        return new RemotingConnectionConfigurationImpl(host, port, connectOptions, connectionTimeout, callbackHandler, channelOptions);
    }

    private String getConnectionSpecificPrefix(String connectionName) {
        return "remote.connection." + connectionName + ".";
    }

    private String getConnectionSpecificConnectOptionsPrefix(String connectionName) {
        return "remote.connection." + connectionName + ".connect.options.";
    }

    private String getConnectionSpecificChannelOptionsPrefix(String connectionName) {
        return "remote.connection." + connectionName + ".channel.options.";
    }

    private Map<String, String> getPropertiesWithPrefix(String prefix) {
        HashMap<String, String> propertiesWithPrefix = new HashMap<String, String>();
        for (String fullPropName : this.ejbReceiversConfigurationProperties.stringPropertyNames()) {
            if (!fullPropName.startsWith(prefix)) continue;
            String propName = fullPropName.substring(prefix.length());
            String propValue = this.ejbReceiversConfigurationProperties.getProperty(fullPropName);
            propertiesWithPrefix.put(propName, propValue);
        }
        return propertiesWithPrefix;
    }

    private String getClusterSpecificPrefix(String clusterName) {
        return "remote.cluster." + clusterName + ".";
    }

    private String getClusterSpecificConnectOptionsPrefix(String clusterName) {
        return "remote.cluster." + clusterName + ".connect.options.";
    }

    private String getClusterSpecificChannelOptionsPrefix(String clusterName) {
        return "remote.cluster." + clusterName + ".channel.options.";
    }

    private String getClusterNodeSpecificConnectOptionsPrefix(String clusterName, String nodeName) {
        return "remote.cluster." + clusterName + ".node." + nodeName + ".connect.options.";
    }

    private String getClusterNodeSpecificChannelOptionsPrefix(String clusterName, String nodeName) {
        return "remote.cluster." + clusterName + ".node." + nodeName + ".channel.options.";
    }

    private CallbackHandler createCallbackHandler(Map<String, String> properties, CallbackHandler defaultCallbackHandler) {
        String realm;
        String passwordBase64;
        String password;
        String userName;
        String callbackClass = properties.get(PROPERTY_KEY_CALLBACK_HANDLER_CLASS);
        CallbackHandler handler = this.resolveCallbackHandler(callbackClass, userName = properties.get(PROPERTY_KEY_USERNAME), password = properties.get(PROPERTY_KEY_PASSWORD), passwordBase64 = properties.get(PROPERTY_KEY_PASSWORD_BASE64), realm = properties.get(PROPERTY_KEY_REALM));
        if (handler != null) {
            return handler;
        }
        return defaultCallbackHandler;
    }

    private CallbackHandler resolveCallbackHandler(String callbackClass, String userName, String password, String passwordBase64, String realm) {
        if (callbackClass != null && (userName != null || password != null)) {
            throw Logs.MAIN.cannotSpecifyBothCallbackHandlerAndUserPass();
        }
        if (callbackClass != null) {
            ClassLoader classLoader = PropertiesBasedEJBClientConfiguration.getClientClassLoader();
            try {
                Class<?> clazz = Class.forName(callbackClass, true, classLoader);
                return (CallbackHandler)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (userName != null) {
            String decodedPassword;
            if (password != null && passwordBase64 != null) {
                throw Logs.MAIN.cannotSpecifyBothPlainTextAndEncodedPassword();
            }
            if (passwordBase64 != null) {
                try {
                    decodedPassword = DatatypeConverter.printBase64Binary((byte[])passwordBase64.getBytes());
                }
                catch (Exception e) {
                    throw Logs.MAIN.couldNotDecodeBase64Password(e);
                }
            } else {
                decodedPassword = password != null ? password : null;
            }
            return new AuthenticationCallbackHandler(userName, decodedPassword == null ? null : decodedPassword.toCharArray(), realm);
        }
        return null;
    }

    private CallbackHandler getDefaultCallbackHandler() {
        String realm;
        String passwordBase64;
        String password;
        String userName;
        String callbackClass = this.ejbReceiversConfigurationProperties.getProperty(PROPERTY_KEY_CALLBACK_HANDLER_CLASS);
        CallbackHandler handler = this.resolveCallbackHandler(callbackClass, userName = this.ejbReceiversConfigurationProperties.getProperty(PROPERTY_KEY_USERNAME), password = this.ejbReceiversConfigurationProperties.getProperty(PROPERTY_KEY_PASSWORD), passwordBase64 = this.ejbReceiversConfigurationProperties.getProperty(PROPERTY_KEY_PASSWORD_BASE64), realm = this.ejbReceiversConfigurationProperties.getProperty(PROPERTY_KEY_REALM));
        if (handler != null) {
            return handler;
        }
        return new DefaultCallbackHandler();
    }

    private class ClusterNodeConfigurationImpl
    implements EJBClientConfiguration.ClusterNodeConfiguration {
        private final String nodeName;
        private final OptionMap connectionCreationOptions;
        private final CallbackHandler callbackHandler;
        private final long connectionTimeout;
        private final OptionMap channelCreationOptions;

        ClusterNodeConfigurationImpl(String nodeName, OptionMap connectionCreationOptions, CallbackHandler callbackHandler, long connectionTimeout, OptionMap channelCreationOptions) {
            this.nodeName = nodeName;
            this.connectionCreationOptions = connectionCreationOptions;
            this.callbackHandler = callbackHandler;
            this.connectionTimeout = connectionTimeout;
            this.channelCreationOptions = channelCreationOptions == null ? OptionMap.EMPTY : channelCreationOptions;
        }

        @Override
        public String getNodeName() {
            return this.nodeName;
        }

        @Override
        public OptionMap getConnectionCreationOptions() {
            return this.connectionCreationOptions;
        }

        @Override
        public CallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        @Override
        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Override
        public OptionMap getChannelCreationOptions() {
            return this.channelCreationOptions;
        }
    }

    private class ClusterConfigurationImpl
    implements EJBClientConfiguration.ClusterConfiguration {
        private final String clusterName;
        private final long maxAllowedConnectedNodes;
        private final Map<String, EJBClientConfiguration.ClusterNodeConfiguration> nodeConfigurations = new HashMap<String, EJBClientConfiguration.ClusterNodeConfiguration>();
        private final CallbackHandler callbackHandler;
        private final OptionMap connectionCreationOptions;
        private final long connectionTimeout;
        private final ClusterNodeSelector clusterNodeSelector;
        private final OptionMap channelCreationOptions;

        ClusterConfigurationImpl(String clusterName, long maxAllowedConnectedNodes, OptionMap connectionCreationOptions, CallbackHandler callbackHandler, long connectionTimeout, ClusterNodeSelector clusterNodeSelector, OptionMap channelCreationOptions) {
            this.clusterName = clusterName;
            this.maxAllowedConnectedNodes = maxAllowedConnectedNodes;
            this.connectionCreationOptions = connectionCreationOptions;
            this.callbackHandler = callbackHandler;
            this.connectionTimeout = connectionTimeout;
            this.clusterNodeSelector = clusterNodeSelector;
            this.channelCreationOptions = channelCreationOptions == null ? OptionMap.EMPTY : channelCreationOptions;
        }

        @Override
        public String getClusterName() {
            return this.clusterName;
        }

        @Override
        public long getMaximumAllowedConnectedNodes() {
            return this.maxAllowedConnectedNodes;
        }

        @Override
        public Iterator<EJBClientConfiguration.ClusterNodeConfiguration> getNodeConfigurations() {
            return this.nodeConfigurations.values().iterator();
        }

        @Override
        public EJBClientConfiguration.ClusterNodeConfiguration getNodeConfiguration(String nodeName) {
            return this.nodeConfigurations.get(nodeName);
        }

        @Override
        public OptionMap getConnectionCreationOptions() {
            return this.connectionCreationOptions;
        }

        @Override
        public CallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        @Override
        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Override
        public ClusterNodeSelector getClusterNodeSelector() {
            return this.clusterNodeSelector;
        }

        void addNodeConfigurations(Collection<EJBClientConfiguration.ClusterNodeConfiguration> nodeConfigurations) {
            if (nodeConfigurations != null) {
                for (EJBClientConfiguration.ClusterNodeConfiguration nodeConfiguration : nodeConfigurations) {
                    this.nodeConfigurations.put(nodeConfiguration.getNodeName(), nodeConfiguration);
                }
            }
        }

        @Override
        public OptionMap getChannelCreationOptions() {
            return this.channelCreationOptions;
        }
    }

    private class RemotingConnectionConfigurationImpl
    implements EJBClientConfiguration.RemotingConnectionConfiguration {
        final String host;
        final int port;
        final OptionMap connectionCreationOptions;
        final long connectionTimeout;
        final CallbackHandler callbackHandler;
        final OptionMap channelCreationOptions;

        RemotingConnectionConfigurationImpl(String host, int port, OptionMap connectionCreationOptions, long connectionTimeout, CallbackHandler callbackHandler, OptionMap channelCreationOptions) {
            this.host = host;
            this.port = port;
            this.connectionCreationOptions = connectionCreationOptions;
            this.connectionTimeout = connectionTimeout;
            this.callbackHandler = callbackHandler;
            this.channelCreationOptions = channelCreationOptions == null ? OptionMap.EMPTY : channelCreationOptions;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Override
        public OptionMap getConnectionCreationOptions() {
            return this.connectionCreationOptions;
        }

        @Override
        public CallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        @Override
        public OptionMap getChannelCreationOptions() {
            return this.channelCreationOptions;
        }
    }

    private class AuthenticationCallbackHandler
    implements CallbackHandler {
        private final String realm;
        private final String username;
        private final char[] password;

        private AuthenticationCallbackHandler(String username, char[] password, String realm) {
            this.username = username;
            this.password = password;
            this.realm = realm;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    if (this.realm == null) {
                        String defaultText = rcb.getDefaultText();
                        rcb.setText(defaultText);
                        continue;
                    }
                    rcb.setText(this.realm);
                    continue;
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.username);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthenticationCallbackHandler that = (AuthenticationCallbackHandler)o;
            if (!Arrays.equals(this.password, that.password)) {
                return false;
            }
            if (this.realm != null ? !this.realm.equals(that.realm) : that.realm != null) {
                return false;
            }
            return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
        }

        public int hashCode() {
            int result = this.realm != null ? this.realm.hashCode() : 0;
            result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
            result = 31 * result + (this.password != null ? Arrays.hashCode(this.password) : 0);
            return result;
        }
    }
}

