/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;

class SecurityActions {
    SecurityActions() {
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key, defaultValue);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    static Subject getSubject() {
        AccessControlContext acc = AccessController.getContext();
        return SecurityActions.getSubjectAction().getSubject(acc);
    }

    private static GetSubjectAction getSubjectAction() {
        return System.getSecurityManager() != null ? GetSubjectAction.PRIVILEGED : GetSubjectAction.NON_PRIVILEGED;
    }

    private static interface GetSubjectAction {
        public static final GetSubjectAction NON_PRIVILEGED = new GetSubjectAction(){

            @Override
            public Subject getSubject(AccessControlContext acc) {
                return Subject.getSubject(acc);
            }
        };
        public static final GetSubjectAction PRIVILEGED = new GetSubjectAction(){

            @Override
            public Subject getSubject(final AccessControlContext acc) {
                return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                    @Override
                    public Subject run() {
                        return NON_PRIVILEGED.getSubject(acc);
                    }
                });
            }
        };

        public Subject getSubject(AccessControlContext var1);
    }
}

