/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StabilityMonitor;

public abstract class AbstractRuntimeOnlyHandler
implements OperationStepHandler {
    public void waitFor(ServiceController<?> controller) throws OperationFailedException {
        if (controller.getState() == ServiceController.State.UP) {
            return;
        }
        StabilityMonitor monitor = new StabilityMonitor();
        monitor.addController(controller);
        try {
            monitor.awaitStability(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException(new ModelNode().set("Interrupted waiting for service: " + controller.getName()));
        }
        finally {
            monitor.removeController(controller);
        }
        if (controller.getState() != ServiceController.State.UP) {
            throw new OperationFailedException(new ModelNode().set("Required service is not available: " + controller.getName()));
        }
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (AbstractRuntimeOnlyHandler.this.resourceMustExist(context, operation)) {
                    context.readResource(PathAddress.EMPTY_ADDRESS, false);
                }
                AbstractRuntimeOnlyHandler.this.executeRuntimeStep(context, operation);
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }

    protected boolean resourceMustExist(OperationContext context, ModelNode operation) {
        return true;
    }

    protected abstract void executeRuntimeStep(OperationContext var1, ModelNode var2) throws OperationFailedException;
}

