/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.net.InetAddress;
import java.security.Principal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationClientException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SecurityActions;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.InetAddressPrincipal;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

abstract class AbstractOperationContext
implements OperationContext {
    private static final Set<String> NON_COPIED_HEADERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("allow-resource-service-restart", "rollback-on-runtime-failure", "rollout-plan")));
    static final ThreadLocal<Thread> controllingThread = new ThreadLocal();
    final Thread initiatingThread;
    private final EnumMap<OperationContext.Stage, Deque<Step>> steps;
    private final ModelController.OperationTransactionControl transactionControl;
    private final ControlledProcessState processState;
    private final boolean booting;
    private final ProcessType processType;
    private final RunningMode runningMode;
    private final Environment callEnvironment;
    boolean respectInterruption = true;
    OperationContext.Stage currentStage = OperationContext.Stage.MODEL;
    OperationContext.ResultAction resultAction;
    boolean cancelled;
    Step activeStep;
    Caller caller;
    private boolean executing;
    private final List<ModelNode> controllerOperations = new ArrayList<ModelNode>(2);
    private boolean auditLogged;
    private final AuditLogger auditLogger;

    AbstractOperationContext(ProcessType processType, RunningMode runningMode, ModelController.OperationTransactionControl transactionControl, ControlledProcessState processState, boolean booting, AuditLogger auditLogger) {
        this.processType = processType;
        this.runningMode = runningMode;
        this.transactionControl = transactionControl;
        this.processState = processState;
        this.booting = booting;
        this.auditLogger = auditLogger;
        this.steps = new EnumMap(OperationContext.Stage.class);
        for (OperationContext.Stage stage : OperationContext.Stage.values()) {
            if (booting && stage == OperationContext.Stage.VERIFY) {
                this.steps.put(stage, new LinkedBlockingDeque());
                continue;
            }
            this.steps.put(stage, new ArrayDeque());
        }
        this.initiatingThread = Thread.currentThread();
        this.callEnvironment = new Environment(processState, processType);
    }

    @Override
    public boolean isBooting() {
        return this.booting;
    }

    @Override
    public void addStep(OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(step, stage, false);
    }

    @Override
    public void addStep(ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        ModelNode response = this.activeStep == null ? new ModelNode().setEmptyObject() : this.activeStep.response;
        this.addStep(response, operation, null, step, stage);
    }

    @Override
    public void addStep(ModelNode operation, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        ModelNode response = this.activeStep == null ? new ModelNode().setEmptyObject() : this.activeStep.response;
        this.addStep(response, operation, null, step, stage, addFirst);
    }

    @Override
    public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(response, operation, null, step, stage);
    }

    @Override
    public void addStep(OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        ModelNode response = this.activeStep == null ? new ModelNode().setEmptyObject() : this.activeStep.response;
        this.addStep(response, this.activeStep.operation, this.activeStep.address, step, stage, addFirst);
    }

    void addStep(ModelNode response, ModelNode operation, PathAddress address, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(response, operation, address, step, stage, false);
    }

    @Override
    public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        this.addStep(response, operation, null, step, stage, addFirst);
    }

    void addStep(ModelNode response, ModelNode operation, PathAddress address, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        assert (this.isControllingThread());
        if (response == null) {
            throw ControllerMessages.MESSAGES.nullVar("response");
        }
        if (operation == null) {
            throw ControllerMessages.MESSAGES.nullVar("operation");
        }
        if (step == null) {
            throw ControllerMessages.MESSAGES.nullVar("step");
        }
        if (stage == null) {
            throw ControllerMessages.MESSAGES.nullVar("stage");
        }
        if (this.currentStage == OperationContext.Stage.DONE) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        if (stage.compareTo(this.currentStage) < 0 && (stage != OperationContext.Stage.IMMEDIATE || this.currentStage == OperationContext.Stage.DONE)) {
            throw ControllerMessages.MESSAGES.stageAlreadyComplete(stage);
        }
        if (stage == OperationContext.Stage.DOMAIN && this.processType != ProcessType.HOST_CONTROLLER) {
            throw ControllerMessages.MESSAGES.invalidStage(stage, this.processType);
        }
        if (stage == OperationContext.Stage.DONE) {
            throw ControllerMessages.MESSAGES.invalidStepStage();
        }
        if (!this.booting && this.activeStep != null && this.activeStep.operation.hasDefined("operation-headers")) {
            ModelNode activeHeaders = this.activeStep.operation.get("operation-headers");
            for (Property property : activeHeaders.asPropertyList()) {
                String key = property.getName();
                if (NON_COPIED_HEADERS.contains(key)) continue;
                operation.get(new String[]{"operation-headers", key}).set(property.getValue());
            }
        }
        if (stage == OperationContext.Stage.IMMEDIATE) {
            this.steps.get((Object)this.currentStage).addFirst(new Step(step, response, operation, address));
        } else {
            Deque<Step> deque = this.steps.get((Object)stage);
            if (addFirst) {
                deque.addFirst(new Step(step, response, operation, address));
            } else {
                deque.addLast(new Step(step, response, operation, address));
            }
        }
        if (!this.executing) {
            this.recordControllerOperation(operation);
        }
    }

    @Override
    public final ModelNode getFailureDescription() {
        return this.activeStep.response.get("failure-description");
    }

    @Override
    public final boolean hasFailureDescription() {
        return this.activeStep.response.has("failure-description");
    }

    @Override
    public final ModelNode getResponseHeaders() {
        return this.activeStep.response.get("response-headers");
    }

    @Override
    public final OperationContext.ResultAction completeStep() {
        return this.completeStepInternal();
    }

    OperationContext.ResultAction executeOperation() {
        return this.completeStepInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationContext.ResultAction completeStepInternal() {
        try {
            this.doCompleteStep();
            if (this.resultAction == OperationContext.ResultAction.KEEP) {
                this.report(MessageSeverity.INFO, ControllerMessages.MESSAGES.operationSucceeded());
            } else {
                this.report(MessageSeverity.INFO, ControllerMessages.MESSAGES.operationRollingBack());
            }
            OperationContext.ResultAction resultAction = this.resultAction;
            return resultAction;
        }
        finally {
            this.respectInterruption = false;
        }
    }

    @Override
    public final void completeStep(OperationContext.RollbackHandler rollbackHandler) {
        if (rollbackHandler == null) {
            throw ControllerMessages.MESSAGES.nullVar("rollbackHandler");
        }
        if (rollbackHandler == OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER) {
            this.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        } else {
            this.completeStep(new RollbackDelegatingResultHandler(rollbackHandler));
        }
    }

    @Override
    public final void completeStep(OperationContext.ResultHandler resultHandler) {
        if (resultHandler == null) {
            throw ControllerMessages.MESSAGES.nullVar("resultHandler");
        }
        this.activeStep.resultHandler = resultHandler;
    }

    @Override
    public final void stepCompleted() {
        this.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }

    abstract void awaitModelControllerContainerMonitor() throws InterruptedException;

    abstract ConfigurationPersister.PersistenceResource createPersistenceResource() throws ConfigurationPersistenceException;

    abstract void releaseStepLocks(Step var1);

    abstract void waitForRemovals() throws InterruptedException;

    boolean isControllingThread() {
        return Thread.currentThread() == this.initiatingThread || controllingThread.get() == this.initiatingThread;
    }

    void logAuditRecord() {
        if (!this.auditLogged) {
            try {
                AccessAuditContext accessContext = SecurityActions.currentAccessAuditContext();
                Caller caller = this.getCaller();
                Subject subject = SecurityActions.getSubject(caller);
                this.auditLogger.log(!this.isModelAffected(), this.resultAction, caller == null ? null : caller.getName(), accessContext == null ? null : accessContext.getDomainUuid(), accessContext == null ? null : accessContext.getAccessMechanism(), this.getSubjectInetAddress(subject), this.getModel(), this.controllerOperations);
                this.auditLogged = true;
            }
            catch (Exception e) {
                ControllerLogger.MGMT_OP_LOGGER.failedToUpdateAuditLog(e);
            }
        }
    }

    private InetAddress getSubjectInetAddress(Subject subject) {
        InetAddressPrincipal principal = this.getPrincipal(subject, InetAddressPrincipal.class);
        return principal != null ? principal.getInetAddress() : null;
    }

    private <T extends Principal> T getPrincipal(Subject subject, Class<T> clazz) {
        if (subject == null) {
            return null;
        }
        Set<T> principals = subject.getPrincipals(clazz);
        assert (principals.size() <= 1);
        if (principals.size() == 0) {
            return null;
        }
        return (T)((Principal)principals.iterator().next());
    }

    private void recordControllerOperation(ModelNode operation) {
        this.controllerOperations.add(operation);
    }

    abstract Resource getModel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompleteStep() {
        ModelNode response;
        assert (this.isControllingThread());
        if (this.currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        this.executing = true;
        if (!this.canContinueProcessing()) {
            this.respectInterruption = false;
            this.logAuditRecord();
            return;
        }
        ModelNode modelNode = response = this.activeStep == null ? null : this.activeStep.response;
        do {
            Step step;
            if ((step = this.steps.get((Object)this.currentStage).pollFirst()) == null) {
                if (!this.currentStage.hasNext()) continue;
                this.currentStage = this.currentStage.next();
                if (this.currentStage != OperationContext.Stage.VERIFY) continue;
                try {
                    this.awaitModelControllerContainerMonitor();
                }
                catch (InterruptedException e) {
                    this.cancelled = true;
                    if (response != null) {
                        response.get("outcome").set("cancelled");
                        response.get("failure-description").set(ControllerMessages.MESSAGES.operationCancelled());
                        response.get("rolled-back").set(true);
                    }
                    this.resultAction = OperationContext.ResultAction.ROLLBACK;
                    this.respectInterruption = false;
                    this.logAuditRecord();
                    Thread.currentThread().interrupt();
                    if (this.activeStep != null && this.activeStep.resultHandler != null) {
                        this.activeStep.finalizeStep(null);
                    }
                    return;
                }
            }
            Throwable toThrow = null;
            boolean exit = false;
            try {
                this.executeStep(step);
            }
            catch (RuntimeException re) {
                toThrow = re;
            }
            catch (Error e) {
                toThrow = e;
            }
            finally {
                if (step.resultHandler == null) {
                    AbstractOperationContext.throwThrowable(toThrow);
                    exit = true;
                } else if (!this.canContinueProcessing()) {
                    this.respectInterruption = false;
                    this.logAuditRecord();
                    step.finalizeStep(toThrow);
                    exit = true;
                } else {
                    AbstractOperationContext.throwThrowable(toThrow);
                    response = this.activeStep.response;
                }
            }
            if (!exit) continue;
            return;
        } while (this.currentStage != OperationContext.Stage.DONE);
        ConfigurationPersister.PersistenceResource persistenceResource = null;
        if (this.isModelAffected() && this.resultAction != OperationContext.ResultAction.ROLLBACK) {
            try {
                persistenceResource = this.createPersistenceResource();
            }
            catch (ConfigurationPersistenceException e) {
                ControllerLogger.MGMT_OP_LOGGER.failedToPersistConfigurationChange(e);
                if (response != null) {
                    response.get("outcome").set("failed");
                    response.get("failure-description").set(ControllerMessages.MESSAGES.failedToPersistConfigurationChange(e.getLocalizedMessage()));
                }
                this.resultAction = OperationContext.ResultAction.ROLLBACK;
                this.logAuditRecord();
                return;
            }
        }
        final AtomicReference<OperationContext.ResultAction> ref = new AtomicReference<OperationContext.ResultAction>(this.transactionControl == null ? OperationContext.ResultAction.KEEP : OperationContext.ResultAction.ROLLBACK);
        if (this.transactionControl != null) {
            if (ControllerLogger.MGMT_OP_LOGGER.isTraceEnabled()) {
                ControllerLogger.MGMT_OP_LOGGER.trace("Prepared response is " + response);
            }
            this.transactionControl.operationPrepared(new ModelController.OperationTransaction(){

                @Override
                public void commit() {
                    ref.set(OperationContext.ResultAction.KEEP);
                }

                @Override
                public void rollback() {
                    ref.set(OperationContext.ResultAction.ROLLBACK);
                }
            }, response);
        }
        this.resultAction = ref.get();
        if (persistenceResource != null) {
            if (this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                persistenceResource.rollback();
            } else {
                persistenceResource.commit();
            }
        }
        this.logAuditRecord();
    }

    private boolean canContinueProcessing() {
        if (Thread.currentThread().isInterrupted()) {
            this.cancelled = true;
        }
        if (this.cancelled) {
            if (this.activeStep != null) {
                this.activeStep.response.get("outcome").set("cancelled");
                this.activeStep.response.get("failure-description").set(ControllerMessages.MESSAGES.operationCancelled());
                this.activeStep.response.get("rolled-back").set(true);
            }
            this.resultAction = OperationContext.ResultAction.ROLLBACK;
        } else if (this.activeStep != null && this.activeStep.response.hasDefined("failure-description") && (this.isRollbackOnRuntimeFailure() || this.currentStage == OperationContext.Stage.MODEL)) {
            this.activeStep.response.get("outcome").set("failed");
            this.activeStep.response.get("rolled-back").set(true);
            this.resultAction = OperationContext.ResultAction.ROLLBACK;
        }
        return this.resultAction != OperationContext.ResultAction.ROLLBACK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStep(Step step) {
        block20: {
            step.predecessor = this.activeStep;
            this.activeStep = step;
            try {
                try {
                    ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(step.handler.getClass());
                    try {
                        step.handler.execute(this, step.operation);
                    }
                    finally {
                        SecurityActions.setThreadContextClassLoader(oldTccl);
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof OperationClientException)) {
                        this.logAuditRecord();
                        throw t;
                    }
                    if (this.currentStage != OperationContext.Stage.DONE) {
                        ModelNode failDesc = ((OperationClientException)OperationClientException.class.cast(t)).getFailureDescription();
                        step.response.get("failure-description").set(failDesc);
                        if (this.isBooting()) {
                            ControllerLogger.MGMT_OP_LOGGER.operationFailed(step.operation.get("operation"), step.operation.get("address"), step.response.get("failure-description"));
                        } else {
                            ControllerLogger.MGMT_OP_LOGGER.operationFailedOnClientError(step.operation.get("operation"), step.operation.get("address"), step.response.get("failure-description"));
                        }
                        this.completeStepInternal();
                        break block20;
                    }
                    throw t;
                }
            }
            catch (Throwable t) {
                if (t instanceof StackOverflowError) {
                    ControllerLogger.MGMT_OP_LOGGER.operationFailed(t, step.operation.get("operation"), step.operation.get("address"), "jboss.boot.thread.stack.size", 0x200000);
                } else {
                    ControllerLogger.MGMT_OP_LOGGER.operationFailed(t, step.operation.get("operation"), step.operation.get("address"));
                }
                if (this.currentStage != OperationContext.Stage.DONE) {
                    if (!step.response.hasDefined("failure-description")) {
                        step.response.get("failure-description").set(ControllerMessages.MESSAGES.operationHandlerFailed(t.getLocalizedMessage()));
                    }
                    step.response.get("outcome").set("failed");
                    this.resultAction = this.getFailedResultAction(t);
                    if (this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                        step.response.get("rolled-back").set(true);
                    }
                } else {
                    this.report(MessageSeverity.WARN, ControllerMessages.MESSAGES.stepHandlerFailed(step.handler));
                }
            }
            finally {
                this.finishStep(step);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishStep(Step step) {
        boolean finalize = true;
        Throwable toThrow = null;
        try {
            if (step.resultHandler != null) {
                if (!this.hasMoreSteps()) {
                    this.completeStepInternal();
                } else {
                    finalize = false;
                }
            }
        }
        catch (RuntimeException re) {
            toThrow = re;
        }
        catch (Error e) {
            toThrow = e;
        }
        finally {
            if (finalize) {
                step.finalizeStep(toThrow);
            } else {
                AbstractOperationContext.throwThrowable(toThrow);
            }
        }
    }

    private static void throwThrowable(Throwable toThrow) {
        if (toThrow != null) {
            if (toThrow instanceof RuntimeException) {
                throw (RuntimeException)toThrow;
            }
            throw (Error)toThrow;
        }
    }

    private OperationContext.ResultAction getFailedResultAction(Throwable cause) {
        if (this.currentStage == OperationContext.Stage.MODEL || this.cancelled || this.isRollbackOnRuntimeFailure() || this.isRollbackOnly() || cause != null && !(cause instanceof OperationFailedException)) {
            return OperationContext.ResultAction.ROLLBACK;
        }
        return OperationContext.ResultAction.KEEP;
    }

    @Override
    public final ProcessType getProcessType() {
        return this.processType;
    }

    @Override
    public final RunningMode getRunningMode() {
        return this.runningMode;
    }

    @Override
    @Deprecated
    public final OperationContext.Type getType() {
        return OperationContext.Type.getType(this.processType, this.runningMode);
    }

    @Override
    public final boolean isNormalServer() {
        return this.processType.isServer() && this.runningMode == RunningMode.NORMAL;
    }

    @Override
    public final boolean isRollbackOnly() {
        return this.resultAction == OperationContext.ResultAction.ROLLBACK;
    }

    @Override
    public final void setRollbackOnly() {
        this.resultAction = OperationContext.ResultAction.ROLLBACK;
    }

    final boolean isRollingBack() {
        return this.currentStage == OperationContext.Stage.DONE && this.resultAction == OperationContext.ResultAction.ROLLBACK;
    }

    @Override
    public final void reloadRequired() {
        if (this.processState.isReloadSupported()) {
            this.activeStep.restartStamp = this.processState.setReloadRequired();
            this.activeStep.response.get(new String[]{"response-headers", "operation-requires-reload"}).set(true);
        } else {
            this.restartRequired();
        }
    }

    @Override
    public final void restartRequired() {
        this.activeStep.restartStamp = this.processState.setRestartRequired();
        this.activeStep.response.get(new String[]{"response-headers", "operation-requires-restart"}).set(true);
    }

    @Override
    public final void revertReloadRequired() {
        if (this.processState.isReloadSupported()) {
            this.processState.revertReloadRequired(this.activeStep.restartStamp);
            if (this.activeStep.response.get("response-headers").hasDefined("operation-requires-reload")) {
                this.activeStep.response.get("response-headers").remove("operation-requires-reload");
                if (this.activeStep.response.get("response-headers").asInt() == 0) {
                    this.activeStep.response.remove("response-headers");
                }
            }
        } else {
            this.revertRestartRequired();
        }
    }

    @Override
    public final void revertRestartRequired() {
        this.processState.revertRestartRequired(this.activeStep.restartStamp);
        if (this.activeStep.response.get("response-headers").hasDefined("operation-requires-restart")) {
            this.activeStep.response.get("response-headers").remove("operation-requires-restart");
            if (this.activeStep.response.get("response-headers").asInt() == 0) {
                this.activeStep.response.remove("response-headers");
            }
        }
    }

    @Override
    public final void runtimeUpdateSkipped() {
        this.activeStep.response.get(new String[]{"response-headers", "runtime-update-skipped"}).set(true);
    }

    @Override
    public final ModelNode getResult() {
        return this.activeStep.response.get("result");
    }

    @Override
    public final boolean hasResult() {
        return this.activeStep.response.has("result");
    }

    @Override
    public final ModelNode getServerResults() {
        if (this.processType != ProcessType.HOST_CONTROLLER) {
            throw ControllerMessages.MESSAGES.serverResultsAccessNotAllowed(ProcessType.HOST_CONTROLLER, this.processType);
        }
        return this.activeStep.response.get("server-groups");
    }

    private boolean hasMoreSteps() {
        boolean more;
        OperationContext.Stage stage = this.currentStage;
        boolean bl = more = !this.steps.get((Object)stage).isEmpty();
        while (!more && stage.hasNext()) {
            more = !this.steps.get((Object)(stage = stage.next())).isEmpty();
        }
        return more;
    }

    @Override
    public Caller getCaller() {
        Caller response;
        this.caller = response = SecurityActions.getCaller(this.caller);
        return response;
    }

    @Override
    public Environment getCallEnvironment() {
        return this.callEnvironment;
    }

    static class OperationId {
        final PathAddress address;
        final String name;

        OperationId(ModelNode operation) {
            this(PathAddress.pathAddress(operation.get("address")), operation.hasDefined("operation") ? operation.get("operation").asString() : null);
        }

        private OperationId(PathAddress address, String name) {
            this.address = address;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperationId that = (OperationId)o;
            return this.address.equals(that.address) && !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            int result = this.address.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }

    private static class RollbackDelegatingResultHandler
    implements OperationContext.ResultHandler {
        private final OperationContext.RollbackHandler delegate;

        private RollbackDelegatingResultHandler(OperationContext.RollbackHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                this.delegate.handleRollback(context, operation);
            }
        }
    }

    class Step {
        private final OperationStepHandler handler;
        final ModelNode response;
        final ModelNode operation;
        final PathAddress address;
        final OperationId operationId;
        private Object restartStamp;
        private OperationContext.ResultHandler resultHandler;
        Step predecessor;

        private Step(OperationStepHandler handler, ModelNode response, ModelNode operation, PathAddress address) {
            this.handler = handler;
            this.response = response;
            this.operation = operation;
            this.address = address == null ? PathAddress.pathAddress(operation.get("address")) : address;
            String opName = operation.hasDefined("operation") ? operation.require("operation").asString() : null;
            this.operationId = new OperationId(this.address, opName);
            response.get("outcome");
        }

        private void finalizeStep(Throwable toThrow) {
            block10: {
                try {
                    this.finalizeInternal();
                }
                catch (RuntimeException t) {
                    if (toThrow == null) {
                        toThrow = t;
                    }
                }
                catch (Error t) {
                    if (toThrow != null) break block10;
                    toThrow = t;
                }
            }
            Step step = this.predecessor;
            while (step != null) {
                if (step.resultHandler != null) {
                    block11: {
                        try {
                            step.finalizeInternal();
                        }
                        catch (RuntimeException t) {
                            if (toThrow == null) {
                                toThrow = t;
                            }
                        }
                        catch (Error t) {
                            if (toThrow != null) break block11;
                            toThrow = t;
                        }
                    }
                    step = step.predecessor;
                    continue;
                }
                AbstractOperationContext.this.activeStep = step;
                break;
            }
            AbstractOperationContext.throwThrowable(toThrow);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finalizeInternal() {
            AbstractOperationContext.this.activeStep = this;
            try {
                this.handleRollback();
                if (AbstractOperationContext.this.currentStage != null && AbstractOperationContext.this.currentStage != OperationContext.Stage.DONE) {
                    AbstractOperationContext.this.currentStage = OperationContext.Stage.DONE;
                    if (!this.response.hasDefined("failure-description")) {
                        this.response.get("failure-description").set(ControllerMessages.MESSAGES.operationHandlerFailedToComplete());
                    }
                    this.response.get("outcome").set(AbstractOperationContext.this.cancelled ? "cancelled" : "failed");
                    this.response.get("rolled-back").set(true);
                    AbstractOperationContext.this.resultAction = AbstractOperationContext.this.getFailedResultAction(null);
                } else if (AbstractOperationContext.this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                    this.response.get("outcome").set(AbstractOperationContext.this.cancelled ? "cancelled" : "failed");
                    this.response.get("rolled-back").set(true);
                } else {
                    this.response.get("outcome").set(this.response.hasDefined("failure-description") ? "failed" : "success");
                }
            }
            finally {
                AbstractOperationContext.this.releaseStepLocks(this);
                if (this.predecessor == null) {
                    AbstractOperationContext.this.currentStage = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRollback() {
            if (this.resultHandler != null) {
                try {
                    ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(this.handler.getClass());
                    try {
                        this.resultHandler.handleResult(AbstractOperationContext.this.resultAction, AbstractOperationContext.this, this.operation);
                    }
                    finally {
                        SecurityActions.setThreadContextClassLoader(oldTccl);
                        AbstractOperationContext.this.waitForRemovals();
                    }
                }
                catch (Exception e) {
                    AbstractOperationContext.this.report(MessageSeverity.ERROR, ControllerMessages.MESSAGES.stepHandlerFailedRollback(this.handler, this.operation.asString(), this.address, e));
                }
                finally {
                    this.resultHandler = null;
                }
            }
        }
    }

    static enum ContextFlag {
        ROLLBACK_ON_FAIL,
        ALLOW_RESOURCE_SERVICE_RESTART;

    }
}

