/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.commands;

import java.io.File;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.io.FileUtils;
import org.jboss.as.jdr.commands.JdrCommand;

public class RHQStatusCommand
extends JdrCommand {
    private static final String RHQ_PREFIX = "rhq" + File.separator;
    private static final String RHQ_SERVER_STATE_JSON = RHQ_PREFIX + "rhq-server-state.json";

    public void execute() throws Exception {
        File keyFile = new File(System.getProperty("jboss.server.data.dir"), "jdr-token");
        if (!keyFile.exists() || !keyFile.canRead()) {
            this.env.getZip().add("Cannot read access token file provided by [JDR Support] RHQ server plugin", RHQ_SERVER_STATE_JSON);
            return;
        }
        String token = FileUtils.readFileToString((File)keyFile);
        try {
            Socket socket = new Socket(InetAddress.getByName(null), 7079);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            out.println(token);
            this.env.getZip().add(socket.getInputStream(), RHQ_SERVER_STATE_JSON);
            out.close();
            socket.close();
        }
        catch (SocketException se) {
            this.env.getZip().add(se.getMessage() + " - Make sure [JDR Support] server plugin is enabled", RHQ_SERVER_STATE_JSON);
        }
        catch (Exception e) {
            this.env.getZip().add("Failed to retrieve status : " + e.getMessage(), RHQ_SERVER_STATE_JSON);
        }
    }
}

