/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.jdr.commands.JdrCommand;
import org.jboss.as.jdr.util.Sanitizer;
import org.jboss.as.jdr.util.Utils;
import org.jboss.as.jdr.vfs.Filters;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class RHQCollectFiles
extends JdrCommand {
    private static final String RHQ_PREFIX = "rhq" + File.separator;
    private VirtualFileFilter filter = Filters.TRUE;
    private Filters.BlacklistFilter blacklistFilter = Filters.wildcardBlackList();
    private LinkedList<Sanitizer> sanitizers = new LinkedList();
    private Comparator<VirtualFile> sorter = new Comparator<VirtualFile>(){

        @Override
        public int compare(VirtualFile resource, VirtualFile resource1) {
            return Long.signum(resource.getLastModified() - resource1.getLastModified());
        }
    };
    private long limit = -1L;

    public RHQCollectFiles(VirtualFileFilter filter) {
        this.filter = filter;
    }

    public RHQCollectFiles(String pattern) {
        this.filter = Filters.wildcard((String)pattern);
    }

    public RHQCollectFiles sanitizer(Sanitizer ... sanitizers) {
        for (Sanitizer s : sanitizers) {
            this.sanitizers.add(s);
        }
        return this;
    }

    public RHQCollectFiles sorter(Comparator<VirtualFile> sorter) {
        this.sorter = sorter;
        return this;
    }

    public RHQCollectFiles limit(long limit) {
        this.limit = limit;
        return this;
    }

    public RHQCollectFiles omit(String pattern) {
        this.blacklistFilter.add(new String[]{pattern});
        return this;
    }

    public void execute() throws Exception {
        String basedir = System.getProperty("rhq.server.home");
        if (basedir == null) {
            throw new IllegalStateException("Did not find 'rhq.server.home'");
        }
        File dir = new File(basedir);
        if (!dir.exists()) {
            throw new IllegalArgumentException("Directory " + dir.getAbsolutePath() + " does not exist");
        }
        if (!dir.canExecute() || !dir.canRead()) {
            throw new IllegalArgumentException("Directory " + dir.getAbsolutePath() + " can not be accessed");
        }
        VirtualFile root = VFS.getChild((URI)dir.toURI());
        List matches = root.getChildrenRecursively(Filters.and((VirtualFileFilter[])new VirtualFileFilter[]{this.filter, this.blacklistFilter}));
        if (this.sorter != null) {
            Collections.sort(matches, this.sorter);
        }
        Limiter limiter = new Limiter(this.limit);
        Iterator iter = matches.iterator();
        while (iter.hasNext() && !limiter.isDone()) {
            VirtualFile f = (VirtualFile)iter.next();
            InputStream stream = limiter.limit(f);
            for (Sanitizer sanitizer : this.sanitizers) {
                if (!sanitizer.accepts(f)) continue;
                stream = sanitizer.sanitize(stream);
            }
            this.env.getZip().add(stream, RHQ_PREFIX + f.getName());
            Utils.safelyClose((InputStream)stream);
        }
    }

    private static class Limiter {
        private long amountRead = 0L;
        private long limit = -1L;
        private boolean done = false;

        public Limiter(long limit) {
            this.limit = limit;
        }

        public boolean isDone() {
            return this.done;
        }

        public InputStream limit(VirtualFile resource) throws IOException {
            InputStream is = resource.openStream();
            long resourceSize = resource.getSize();
            if (this.limit != -1L) {
                long leftToRead = this.limit - this.amountRead;
                if (leftToRead < resourceSize) {
                    Utils.skip((InputStream)is, (long)(resourceSize - leftToRead));
                    this.done = true;
                } else {
                    this.amountRead += resourceSize;
                }
            }
            return is;
        }
    }
}

