/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event;

import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.event.EnversListenerDuplicationStrategy;
import org.hibernate.envers.event.EnversPostCollectionRecreateEventListenerImpl;
import org.hibernate.envers.event.EnversPostDeleteEventListenerImpl;
import org.hibernate.envers.event.EnversPostInsertEventListenerImpl;
import org.hibernate.envers.event.EnversPostUpdateEventListenerImpl;
import org.hibernate.envers.event.EnversPreCollectionRemoveEventListenerImpl;
import org.hibernate.envers.event.EnversPreCollectionUpdateEventListenerImpl;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreCollectionRemoveEventListener;
import org.hibernate.event.spi.PreCollectionUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jboss.logging.Logger;

public class EnversIntegrator
implements Integrator {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EnversIntegrator.class.getName());
    public static final String AUTO_REGISTER = "hibernate.listeners.envers.autoRegister";
    private AuditConfiguration enversConfiguration;

    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        boolean autoRegister = ConfigurationHelper.getBoolean((String)AUTO_REGISTER, (Map)configuration.getProperties(), (boolean)true);
        if (!autoRegister) {
            LOG.debug((Object)"Skipping Envers listener auto registration");
            return;
        }
        EventListenerRegistry listenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy((DuplicationStrategy)EnversListenerDuplicationStrategy.INSTANCE);
        this.enversConfiguration = AuditConfiguration.getFor(configuration, (ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class));
        if (this.enversConfiguration.getEntCfg().hasAuditedEntities()) {
            listenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{new EnversPostDeleteEventListenerImpl(this.enversConfiguration)});
            listenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{new EnversPostInsertEventListenerImpl(this.enversConfiguration)});
            listenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{new EnversPostUpdateEventListenerImpl(this.enversConfiguration)});
            listenerRegistry.appendListeners(EventType.POST_COLLECTION_RECREATE, (Object[])new PostCollectionRecreateEventListener[]{new EnversPostCollectionRecreateEventListenerImpl(this.enversConfiguration)});
            listenerRegistry.appendListeners(EventType.PRE_COLLECTION_REMOVE, (Object[])new PreCollectionRemoveEventListener[]{new EnversPreCollectionRemoveEventListenerImpl(this.enversConfiguration)});
            listenerRegistry.appendListeners(EventType.PRE_COLLECTION_UPDATE, (Object[])new PreCollectionUpdateEventListener[]{new EnversPreCollectionUpdateEventListenerImpl(this.enversConfiguration)});
        }
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (this.enversConfiguration != null) {
            this.enversConfiguration.destroy();
        }
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

