/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.drift;

import java.io.Serializable;
import java.util.Date;
import org.rhq.core.domain.drift.DriftCategory;
import org.rhq.core.util.file.FileUtil;

public class FileEntry
implements Serializable,
Comparable<FileEntry> {
    private static final long serialVersionUID = 1L;
    private String file;
    private String oldSHA;
    private String newSHA;
    private DriftCategory type;
    private Long lastModified;
    private Long size;

    public static FileEntry removedFileEntry(String file, String sha) {
        FileEntry entry = new FileEntry();
        entry.file = FileUtil.useForwardSlash((String)file);
        entry.oldSHA = sha;
        entry.newSHA = "0";
        entry.type = DriftCategory.FILE_REMOVED;
        entry.lastModified = -1L;
        entry.size = -1L;
        return entry;
    }

    public static FileEntry addedFileEntry(String file, String sha, Long lastModified, Long size) {
        FileEntry entry = new FileEntry();
        entry.file = FileUtil.useForwardSlash((String)file);
        entry.oldSHA = "0";
        entry.newSHA = sha;
        entry.type = DriftCategory.FILE_ADDED;
        entry.lastModified = lastModified;
        entry.size = size;
        return entry;
    }

    public static FileEntry changedFileEntry(String file, String oldSHA, String newSHA, Long lastModified, Long size) {
        FileEntry entry = new FileEntry();
        entry.file = FileUtil.useForwardSlash((String)file);
        entry.oldSHA = oldSHA;
        entry.newSHA = newSHA;
        entry.type = DriftCategory.FILE_CHANGED;
        entry.lastModified = lastModified;
        entry.size = size;
        return entry;
    }

    private FileEntry() {
    }

    public FileEntry(String newSHA, String oldSHA, String file, String type, Long lastModified, Long size) {
        this.newSHA = newSHA;
        this.oldSHA = oldSHA;
        this.file = file;
        this.type = DriftCategory.fromCode((String)type);
        this.lastModified = lastModified;
        this.size = size;
    }

    public String getFile() {
        return this.file;
    }

    public String getOldSHA() {
        return this.oldSHA;
    }

    public String getNewSHA() {
        return this.newSHA;
    }

    public DriftCategory getType() {
        return this.type;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public Long getSize() {
        return this.size;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[newSHA: " + this.newSHA + ", oldSHA: " + this.oldSHA + ", file: " + this.file + ", type: " + this.type.code() + ", lastModified: " + new Date(this.lastModified) + ", size: " + this.size + "]";
    }

    @Override
    public int compareTo(FileEntry o) {
        return this.file.compareTo(o.getFile());
    }
}

