/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.io.IOException;
import org.jboss.as.patching.installation.Identity;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.RollbackPatch;
import org.jboss.as.patching.validation.AbstractArtifact;
import org.jboss.as.patching.validation.Artifact;
import org.jboss.as.patching.validation.Context;
import org.jboss.as.patching.validation.PatchHistoryDir;
import org.jboss.as.patching.validation.PatchingHistory;

public class PatchArtifact
extends AbstractArtifact<PatchingHistory.State, State> {
    public static final PatchArtifact INSTANCE = new PatchArtifact();

    private PatchArtifact() {
        this.addArtifact(PatchHistoryDir.INSTANCE);
    }

    @Override
    protected State getInitialState(PatchingHistory.State parent, Context ctx) {
        PatchableTarget.TargetInfo identityInfo;
        State lastApplied = parent.getLastAppliedPatch();
        if (lastApplied != null) {
            return lastApplied;
        }
        Identity identity = ctx.getInstallationManager().getIdentity();
        try {
            identityInfo = identity.loadTargetInfo();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        String patchId = identityInfo.getCumulativePatchID();
        Patch.PatchType type = Patch.PatchType.CUMULATIVE;
        if (!identityInfo.getPatchIDs().isEmpty()) {
            type = Patch.PatchType.ONE_OFF;
            patchId = identityInfo.getPatchIDs().get(0);
        } else if (patchId.equals("base")) {
            return null;
        }
        lastApplied = new State(patchId, type);
        parent.setLastAppliedPatch(lastApplied);
        return lastApplied;
    }

    public class State
    implements Artifact.State {
        private final String patchId;
        private Patch.PatchType type;
        private PatchHistoryDir.State historyDir;
        protected State previous;

        State(String patchId, Patch.PatchType type) {
            this.patchId = patchId;
            this.type = type;
        }

        State(RollbackPatch patch, Context ctx) throws IOException {
            PatchableTarget.TargetInfo info = patch.getIdentityState().getIdentity().loadTargetInfo();
            if (info.getPatchIDs().isEmpty()) {
                this.patchId = info.getCumulativePatchID();
                this.type = Patch.PatchType.CUMULATIVE;
            } else {
                this.patchId = info.getPatchIDs().get(0);
                this.type = Patch.PatchType.ONE_OFF;
            }
        }

        public String getPatchId() {
            return this.patchId;
        }

        public Patch.PatchType getType() {
            return this.type;
        }

        @Override
        public void validate(Context ctx) {
        }

        public PatchHistoryDir.State getHistoryDir() {
            return this.historyDir;
        }

        public void setHistoryDir(PatchHistoryDir.State historyDir) {
            this.historyDir = historyDir;
        }

        public boolean hasPrevious(Context ctx) {
            PatchableTarget.TargetInfo targetInfo;
            if (!this.historyDir.getRollbackXml().getFile().exists()) {
                return false;
            }
            RollbackPatch patch = (RollbackPatch)this.historyDir.getRollbackXml().getPatch();
            try {
                targetInfo = patch.getIdentityState().getIdentity().loadTargetInfo();
            }
            catch (IOException e) {
                ctx.getErrorHandler().error("Failed to load identity info for patch " + patch.getPatchId(), e);
                return false;
            }
            return !"base".equals(targetInfo.getCumulativePatchID()) || !targetInfo.getPatchIDs().isEmpty();
        }

        public State getPrevious(Context ctx) {
            if (this.previous == null) {
                if (!this.hasPrevious(ctx)) {
                    return null;
                }
                try {
                    this.previous = new State((RollbackPatch)this.historyDir.getRollbackXml().getPatch(), ctx);
                }
                catch (IOException e) {
                    ctx.getErrorHandler().error("Failed to load previous patch", e);
                    return null;
                }
                PatchArtifact.this.validateForState(ctx, this.previous);
            }
            return this.previous;
        }
    }
}

