/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchLogger;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.runner.AbstractFileTask;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;

class FileAddTask
extends AbstractFileTask {
    FileAddTask(PatchingTaskDescription description, File target, File backup) {
        super(description, target, backup);
    }

    @Override
    ContentModification createRollbackEntry(ContentModification original, MiscContentItem item, byte[] targetHash) {
        return new ContentModification(item, targetHash, ModificationType.REMOVE);
    }

    @Override
    byte[] backup(PatchingTaskContext context) throws IOException {
        byte[] backupHash = super.backup(context);
        if (!Arrays.equals(backupHash, IoUtils.NO_CONTENT)) {
            PatchLogger.ROOT_LOGGER.debugf("item should not exist (%s)", this.contentItem);
        }
        return backupHash;
    }
}

