/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.util;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.LoaderClassPath;

public class ClassPoolFactory {
    private static final WeakHashMap<ClassLoader, ClassPool> CLASS_POOL_PER_CLASS_LOADER = new WeakHashMap();

    private ClassPoolFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassPool getClassPool(ClassLoader classLoader) {
        WeakHashMap<ClassLoader, ClassPool> weakHashMap = CLASS_POOL_PER_CLASS_LOADER;
        synchronized (weakHashMap) {
            ClassPool ret = CLASS_POOL_PER_CLASS_LOADER.get(classLoader);
            if (ret == null) {
                ret = classLoader == null ? new ClassPool() : new ClassLoaderBoundClassPool(classLoader);
                ClassPoolFactory.initClassPool(ret);
                CLASS_POOL_PER_CLASS_LOADER.put(classLoader, ret);
            }
            return ret;
        }
    }

    public static ClassPool getClassPoolForCurrentContextClassLoader() {
        return ClassPoolFactory.getClassPool(Thread.currentThread().getContextClassLoader());
    }

    private static void initClassPool(ClassPool classPool) {
        classPool.appendClassPath((ClassPath)new ClassClassPath(ClassPoolFactory.class));
        classPool.appendSystemPath();
    }

    private static class ClassLoaderBoundClassPool
    extends ClassPool {
        private WeakReference<ClassLoader> classLoader;

        public ClassLoaderBoundClassPool(ClassLoader classLoader) {
            this.classLoader = new WeakReference<ClassLoader>(classLoader);
            this.insertClassPath((ClassPath)new LoaderClassPath(classLoader));
        }

        public ClassLoader getClassLoader() {
            ClassLoader cl = (ClassLoader)this.classLoader.get();
            if (cl == null) {
                throw new IllegalStateException("The bound classloader has been garbage collected.");
            }
            return cl;
        }
    }
}

