/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.export;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.rhq.bindings.export.ExportException;
import org.rhq.bindings.output.TabularWriter;

public class Exporter {
    private String format = "raw";
    private String file;
    private int pageWidth = 160;
    private TabularWriter tabularWriter;
    private PrintWriter fileWriter;
    private boolean newWriterNeeded;

    public void setTarget(String format, String file) {
        this.setFormat(format);
        this.setFile(file);
        this.initWriter();
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int width) {
        this.pageWidth = width;
    }

    public void write(Object object) {
        this.initWriter();
        this.tabularWriter.print(object);
        this.fileWriter.flush();
    }

    public void close() {
        if (this.fileWriter != null) {
            this.fileWriter.close();
            this.newWriterNeeded = true;
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        this.newWriterNeeded = true;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
        this.newWriterNeeded = true;
    }

    private void initWriter() {
        if (this.newWriterNeeded || this.tabularWriter == null) {
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
            if (this.format == null) {
                throw new IllegalStateException("No format is set. Please set it to 'raw' or 'csv'.");
            }
            if (this.file == null) {
                throw new IllegalStateException("No file is set. Please specify the file to outut the data to.");
            }
            this.newWriterNeeded = false;
            try {
                this.fileWriter = new PrintWriter(new FileWriter(this.file));
                this.tabularWriter = new TabularWriter(this.fileWriter, this.format);
                this.tabularWriter.setExportMode(true);
            }
            catch (IOException e) {
                if (this.fileWriter != null) {
                    this.fileWriter.close();
                }
                throw new ExportException("Failed to initialize the exporter.", e);
            }
        }
        this.tabularWriter.setWidth(this.pageWidth);
    }
}

