/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.ClassPool;
import javassist.util.proxy.MethodHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.client.ResourceClientFactory;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.util.ClassPoolFactory;
import org.rhq.bindings.util.ConfigurationClassBuilder;
import org.rhq.bindings.util.ContentUploader;
import org.rhq.bindings.util.LazyLoadScenario;
import org.rhq.bindings.util.ResourceTypeFingerprint;
import org.rhq.bindings.util.ShortOutput;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PluginConfigurationUpdate;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.criteria.MeasurementDefinitionCriteria;
import org.rhq.core.domain.criteria.OperationDefinitionCriteria;
import org.rhq.core.domain.criteria.PackageVersionCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceOperationHistoryCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.domain.util.Summary;
import org.rhq.core.server.MeasurementConverter;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.configuration.ConfigurationManagerRemote;
import org.rhq.enterprise.server.content.ContentManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerRemote;
import org.rhq.enterprise.server.operation.OperationManagerRemote;
import org.rhq.enterprise.server.resource.ResourceManagerRemote;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;

public class ResourceClientProxy {
    private static final Log LOG = LogFactory.getLog(ResourceClientProxy.class);
    private ResourceClientFactory proxyFactory;
    private RhqFacade remoteClient;
    private int resourceId;
    private Resource resource;
    Map<String, Object> allProperties = new HashMap<String, Object>();
    ResourceTypeFingerprint fingerprint;
    private List<MeasurementDefinition> measurementDefinitions;
    private Map<String, Measurement> measurementMap = new HashMap<String, Measurement>();
    private List<OperationDefinition> operationDefinitions;
    private Map<String, Operation> operationMap = new HashMap<String, Operation>();
    private Map<String, ContentType> contentTypes = new HashMap<String, ContentType>();
    private List<ResourceClientProxy> children;
    ConfigurationDefinition resourceConfigurationDefinition;
    ConfigurationDefinition pluginConfigurationDefinition;

    public ResourceClientProxy() {
    }

    public ResourceClientProxy(ResourceClientProxy parentProxy) {
        this.proxyFactory = parentProxy.proxyFactory;
        this.remoteClient = parentProxy.remoteClient;
        this.resourceId = parentProxy.resourceId;
        this.resource = parentProxy.resource;
        this.allProperties = parentProxy.allProperties;
        this.measurementDefinitions = parentProxy.measurementDefinitions;
        this.measurementMap = parentProxy.measurementMap;
        this.children = parentProxy.children;
    }

    public ResourceClientProxy(ResourceClientFactory factory, int resourceId) {
        this.proxyFactory = factory;
        this.remoteClient = factory.getRemoteClient();
        this.resourceId = resourceId;
        this.init();
    }

    @Summary(index=0)
    public int getId() {
        return this.resourceId;
    }

    @Summary(index=1)
    public String getName() {
        return this.resource.getName();
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    @Summary(index=2)
    public String getVersion() {
        return this.resource.getVersion();
    }

    @Summary(index=3)
    public ResourceType getResourceType() {
        return this.resource.getResourceType();
    }

    public Date getCreatedDate() {
        return new Date(this.resource.getCtime());
    }

    public Date getModifiedDate() {
        return new Date(this.resource.getCtime());
    }

    public Measurement getMeasurement(String name) {
        return this.measurementMap.get(name);
    }

    public Measurement[] getMeasurements() {
        return this.measurementMap.values().toArray(new Measurement[this.measurementMap.size()]);
    }

    public Operation[] getOperations() {
        return this.operationMap.values().toArray(new Operation[this.operationMap.size()]);
    }

    public Map<String, ContentType> getContentTypes() {
        return this.contentTypes;
    }

    public ResourceClientProxy[] getChildren() {
        if (this.children == null && LazyLoadScenario.isShouldLoad()) {
            this.children = new ArrayList<ResourceClientProxy>();
            this.initChildren();
        }
        return this.children.toArray(new ResourceClientProxy[this.children.size()]);
    }

    public ResourceClientProxy getChild(String name) {
        for (ResourceClientProxy child : this.getChildren()) {
            if (!name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public String toString() {
        return "[" + this.resourceId + "] " + this.resource.getName() + " (" + this.resource.getResourceType().getName() + "::" + this.resource.getResourceType().getPlugin() + ")";
    }

    public void init() {
        this.resource = this.remoteClient.getProxy(ResourceManagerRemote.class).getResource(this.remoteClient.getSubject(), this.resourceId);
        this.initMeasurements();
        this.initOperations();
        this.initConfigDefs();
        this.initContent();
        ArrayList<PackageType> packageTypes = new ArrayList<PackageType>();
        for (ContentType ct : this.contentTypes.values()) {
            packageTypes.add(ct.getPackageType());
        }
        this.fingerprint = new ResourceTypeFingerprint(this.resource.getResourceType(), this.measurementDefinitions, this.operationDefinitions, packageTypes, this.pluginConfigurationDefinition, this.resourceConfigurationDefinition);
    }

    private void initConfigDefs() {
        ConfigurationManagerRemote configurationManager = this.remoteClient.getProxy(ConfigurationManagerRemote.class);
        this.resourceConfigurationDefinition = configurationManager.getResourceConfigurationDefinitionWithTemplatesForResourceType(this.remoteClient.getSubject(), this.resource.getResourceType().getId());
        this.pluginConfigurationDefinition = configurationManager.getPluginConfigurationDefinitionForResourceType(this.remoteClient.getSubject(), this.resource.getResourceType().getId());
    }

    private void initChildren() {
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterParentResourceId(Integer.valueOf(this.resourceId));
        criteria.clearPaging();
        PageList childResources = this.remoteClient.getProxy(ResourceManagerRemote.class).findResourcesByCriteria(this.remoteClient.getSubject(), criteria);
        for (Resource child : childResources) {
            this.children.add(this.proxyFactory.getResource(child.getId()));
        }
    }

    private void initMeasurements() {
        MeasurementDefinitionCriteria criteria = new MeasurementDefinitionCriteria();
        criteria.addFilterResourceTypeId(Integer.valueOf(this.resource.getResourceType().getId()));
        this.measurementDefinitions = this.remoteClient.getProxy(MeasurementDefinitionManagerRemote.class).findMeasurementDefinitionsByCriteria(this.remoteClient.getSubject(), criteria);
        this.measurementMap = new HashMap<String, Measurement>();
        for (MeasurementDefinition def : this.measurementDefinitions) {
            Measurement m = new Measurement(def);
            String name = def.getDisplayName().replaceAll("\\W", "");
            name = ResourceClientProxy.decapitalize(name);
            this.measurementMap.put(name, m);
            this.allProperties.put(name, m);
        }
    }

    public void initOperations() {
        OperationDefinitionCriteria criteria = new OperationDefinitionCriteria();
        criteria.addFilterResourceIds(new Integer[]{this.resourceId});
        criteria.fetchParametersConfigurationDefinition(true);
        criteria.fetchResultsConfigurationDefinition(true);
        this.operationDefinitions = this.remoteClient.getProxy(OperationManagerRemote.class).findOperationDefinitionsByCriteria(this.remoteClient.getSubject(), criteria);
        for (OperationDefinition def : this.operationDefinitions) {
            Operation o = new Operation(def);
            this.operationMap.put(o.getName(), o);
            this.allProperties.put(o.getName(), o);
        }
    }

    private void initContent() {
        ContentManagerRemote contentManager = this.remoteClient.getProxy(ContentManagerRemote.class);
        List types = null;
        try {
            types = contentManager.findPackageTypes(this.remoteClient.getSubject(), this.resource.getResourceType().getName(), this.resource.getResourceType().getPlugin());
            for (PackageType packageType : types) {
                this.contentTypes.put(packageType.getName(), new ContentType(packageType));
            }
        }
        catch (ResourceTypeNotFoundException e) {
            LOG.error((Object)("Could not find resource type while creating content mappings of the resource proxy for resource with id " + this.resourceId), (Throwable)e);
        }
    }

    static String simpleName(String name) {
        return ResourceClientProxy.decapitalize(name.replaceAll("\\W", ""));
    }

    private static String decapitalize(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1, name.length());
    }

    static String getterName(String name) {
        return "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1, name.length());
    }

    public static interface ContentBackedResource {
        public InstalledPackage getBackingContent();

        @Deprecated
        public void updateBackingContent(String var1);

        public void updateBackingContent(String var1, String var2);

        public void retrieveBackingContent(String var1) throws IOException;
    }

    public static interface ResourceConfigurable {
        public Configuration getResourceConfiguration();

        public ConfigurationDefinition getResourceConfigurationDefinition();

        public ResourceConfigurationUpdate updateResourceConfiguration(Configuration var1);
    }

    public static interface PluginConfigurable {
        public Configuration getPluginConfiguration();

        public ConfigurationDefinition getPluginConfigurationDefinition();

        public PluginConfigurationUpdate updatePluginConfiguration(Configuration var1);
    }

    public static class ClientProxyMethodHandler
    implements MethodHandler,
    ContentBackedResource,
    PluginConfigurable,
    ResourceConfigurable {
        ResourceClientProxy resourceClientProxy;
        RhqFacade remoteClient;

        public ClientProxyMethodHandler(ResourceClientProxy resourceClientProxy, RhqFacade remoteClient) {
            this.resourceClientProxy = resourceClientProxy;
            this.remoteClient = remoteClient;
        }

        @Override
        public Configuration getPluginConfiguration() {
            if (!LazyLoadScenario.isShouldLoad()) {
                return null;
            }
            return this.remoteClient.getProxy(ConfigurationManagerRemote.class).getPluginConfiguration(this.remoteClient.getSubject(), this.resourceClientProxy.resourceId);
        }

        @Override
        public ConfigurationDefinition getPluginConfigurationDefinition() {
            return this.resourceClientProxy.pluginConfigurationDefinition;
        }

        @Override
        public PluginConfigurationUpdate updatePluginConfiguration(Configuration configuration) {
            PluginConfigurationUpdate update = this.remoteClient.getProxy(ConfigurationManagerRemote.class).updatePluginConfiguration(this.remoteClient.getSubject(), this.resourceClientProxy.getId(), configuration);
            return update;
        }

        @Override
        public Configuration getResourceConfiguration() {
            if (!LazyLoadScenario.isShouldLoad()) {
                return null;
            }
            ResourceConfigurationUpdate update = this.remoteClient.getProxy(ConfigurationManagerRemote.class).getLatestResourceConfigurationUpdate(this.remoteClient.getSubject(), this.resourceClientProxy.resourceId);
            return update == null ? null : update.getConfiguration();
        }

        @Override
        public ConfigurationDefinition getResourceConfigurationDefinition() {
            return this.resourceClientProxy.resourceConfigurationDefinition;
        }

        @Override
        public ResourceConfigurationUpdate updateResourceConfiguration(Configuration configuration) {
            ResourceConfigurationUpdate update = this.remoteClient.getProxy(ConfigurationManagerRemote.class).updateResourceConfiguration(this.remoteClient.getSubject(), this.resourceClientProxy.getId(), configuration);
            return update;
        }

        @Override
        public InstalledPackage getBackingContent() {
            return this.remoteClient.getProxy(ContentManagerRemote.class).getBackingPackageForResource(this.remoteClient.getSubject(), this.resourceClientProxy.resourceId);
        }

        @Override
        @Deprecated
        public void updateBackingContent(String filename) {
            this.updateBackingContent(filename, null);
        }

        @Override
        public void updateBackingContent(String filename, String displayVersion) {
            File file = new File(filename);
            if (!file.exists()) {
                throw new IllegalArgumentException("File not found: " + file.getAbsolutePath());
            }
            if (file.isDirectory()) {
                throw new IllegalArgumentException("File expected, found directory: " + file.getAbsolutePath());
            }
            String sha = null;
            try {
                sha = new MessageDigestGenerator("SHA-256").calcDigestString(file);
            }
            catch (Exception e) {
                LOG.error((Object)"Message digest for the package bits failed.", (Throwable)e);
            }
            String packageVersion = "[sha256=" + sha + "]";
            InstalledPackage oldPackage = this.getBackingContent();
            ContentManagerRemote contentManager = this.remoteClient.getProxy(ContentManagerRemote.class);
            ContentUploader contentUploader = new ContentUploader(contentManager);
            String temporaryContentHandle = contentUploader.upload(file);
            PackageVersion pv = contentManager.createPackageVersionWithDisplayVersion(this.remoteClient.getSubject(), oldPackage.getPackageVersion().getGeneralPackage().getName(), oldPackage.getPackageVersion().getGeneralPackage().getPackageType().getId(), packageVersion, displayVersion, Integer.valueOf(oldPackage.getPackageVersion().getArchitecture().getId()), temporaryContentHandle);
            contentManager.deployPackagesWithNote(this.remoteClient.getSubject(), new int[]{this.resourceClientProxy.getId()}, new int[]{pv.getId()}, "CLI deployment request");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void retrieveBackingContent(String fileName) throws IOException {
            InstalledPackage installedPackage = this.getBackingContent();
            if (installedPackage != null) {
                if (fileName == null) {
                    fileName = installedPackage.getPackageVersion().getFileName();
                }
                File file = new File(fileName);
                byte[] data = this.remoteClient.getProxy(ContentManagerRemote.class).getPackageBytes(this.remoteClient.getSubject(), this.resourceClientProxy.resourceId, installedPackage.getId());
                FileOutputStream fos = new FileOutputStream(file);
                try {
                    fos.write(data);
                }
                finally {
                    fos.close();
                }
            } else {
                throw new RuntimeException("Content not available in the content repository. If you recently deployed content to this resource, then the content repository has not yet received the content or content information. The content for a resource is available only after the deployment and discovery process completes. Please try again in a few minutes.");
            }
        }

        public Object invoke(Object proxy, Method method, Method proceedMethod, Object[] args) throws Throwable {
            if (proceedMethod != null) {
                Method realMethod = this.getResourceClientProxyClass().getMethod(method.getName(), method.getParameterTypes());
                return realMethod.invoke((Object)this.resourceClientProxy, args);
            }
            try {
                Method localMethod = this.getClass().getMethod(method.getName(), method.getParameterTypes());
                return localMethod.invoke((Object)this, args);
            }
            catch (NoSuchMethodException nsme) {
                String name = method.getName();
                Object key = this.resourceClientProxy.allProperties.get(name);
                if (key == null) {
                    name = ResourceClientProxy.decapitalize(method.getName().substring(3, method.getName().length()));
                    key = this.resourceClientProxy.allProperties.get(name);
                }
                if (key != null) {
                    if (key instanceof Measurement) {
                        return key;
                    }
                    if (key instanceof Operation) {
                        this.resourceClientProxy.proxyFactory.getOutputWriter().println("Invoking operation " + ((Operation)key).getName());
                        return ((Operation)key).invoke(args);
                    }
                }
                throw new RuntimeException("Can't find custom method: " + method);
            }
        }

        protected Class<? extends ResourceClientProxy> getResourceClientProxyClass() {
            return ResourceClientProxy.class;
        }
    }

    public class Operation {
        OperationDefinition definition;

        public Operation(OperationDefinition definition) {
            this.definition = definition;
        }

        @Summary(index=0)
        public String getName() {
            return ResourceClientProxy.simpleName(this.definition.getDisplayName());
        }

        @Summary(index=1)
        public String getDescription() {
            return this.definition.getDescription();
        }

        public OperationDefinition getDefinition() {
            return this.definition;
        }

        public Object invoke(Object[] args) throws Exception {
            if (!LazyLoadScenario.isShouldLoad()) {
                return null;
            }
            ClassPool pool = ClassPoolFactory.getClassPoolForCurrentContextClassLoader();
            Configuration parameters = ConfigurationClassBuilder.translateParametersToConfig(pool, this.definition.getParametersConfigurationDefinition(), args);
            OperationManagerRemote operationManager = ResourceClientProxy.this.remoteClient.getProxy(OperationManagerRemote.class);
            ResourceOperationSchedule schedule = operationManager.scheduleResourceOperation(ResourceClientProxy.this.remoteClient.getSubject(), ResourceClientProxy.this.resourceId, this.definition.getName(), 0L, 0L, 0, 30000, parameters, "Executed from commandline");
            ResourceOperationHistoryCriteria criteria = new ResourceOperationHistoryCriteria();
            criteria.addFilterJobId(schedule.getJobId());
            criteria.addFilterResourceIds(new Integer[]{ResourceClientProxy.this.resourceId});
            criteria.addSortStartTime(PageOrdering.DESC);
            criteria.setPaging(0, 1);
            criteria.fetchOperationDefinition(true);
            criteria.fetchParameters(true);
            criteria.fetchResults(true);
            int retries = 10;
            ResourceOperationHistory history = null;
            while (history == null && retries-- > 0) {
                Thread.sleep(1000L);
                PageList histories = operationManager.findResourceOperationHistoriesByCriteria(ResourceClientProxy.this.remoteClient.getSubject(), criteria);
                if (histories.size() <= 0 || ((ResourceOperationHistory)histories.get(0)).getStatus() == OperationRequestStatus.INPROGRESS) continue;
                history = (ResourceOperationHistory)histories.get(0);
            }
            Configuration result = history != null ? history.getResults() : null;
            Object returnResults = ConfigurationClassBuilder.translateResults(pool, this.definition.getResultsConfigurationDefinition(), result);
            return returnResults;
        }

        public String toString() {
            return this.getName();
        }
    }

    public class Measurement
    implements ShortOutput {
        MeasurementDefinition definition;

        public Measurement(MeasurementDefinition definition) {
            this.definition = definition;
        }

        @Summary(index=0)
        public String getName() {
            return this.definition.getDisplayName();
        }

        @Summary(index=1)
        public String getDisplayValue() {
            Object val = this.getValue();
            if (val instanceof Number) {
                return MeasurementConverter.format((Double)((Number)val).doubleValue(), (MeasurementUnits)this.getUnits(), (boolean)true);
            }
            return String.valueOf(val);
        }

        @Summary(index=2)
        public String getDescription() {
            return this.definition.getDescription();
        }

        public DataType getDataType() {
            return this.definition.getDataType();
        }

        public MeasurementCategory getCategory() {
            return this.definition.getCategory();
        }

        public MeasurementUnits getUnits() {
            return this.definition.getUnits();
        }

        public Object getValue() {
            Object result = "?";
            try {
                Set d = ResourceClientProxy.this.remoteClient.getProxy(MeasurementDataManagerRemote.class).findLiveData(ResourceClientProxy.this.remoteClient.getSubject(), ResourceClientProxy.this.resourceId, new int[]{this.definition.getId()});
                if (!d.isEmpty()) {
                    MeasurementData data = (MeasurementData)d.iterator().next();
                    result = data.getValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public String getShortOutput() {
            return this.getDisplayValue();
        }
    }

    public class ContentType {
        private PackageType packageType;

        public ContentType(PackageType packageType) {
            this.packageType = packageType;
        }

        public PackageType getPackageType() {
            return this.packageType;
        }

        public List<PackageVersion> getInstalledPackages() {
            ContentManagerRemote contentManager = ResourceClientProxy.this.remoteClient.getProxy(ContentManagerRemote.class);
            PackageVersionCriteria criteria = new PackageVersionCriteria();
            criteria.addFilterResourceId(Integer.valueOf(ResourceClientProxy.this.resourceId));
            return contentManager.findPackageVersionsByCriteria(ResourceClientProxy.this.remoteClient.getSubject(), criteria);
        }

        public String toString() {
            return this.packageType.getDisplayName();
        }
    }
}

