/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.taglib;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import net.sf.navigator.displayer.MenuDisplayer;
import net.sf.navigator.displayer.MenuDisplayerMapping;
import net.sf.navigator.displayer.MessageResourcesMenuDisplayer;
import net.sf.navigator.menu.MenuRepository;
import net.sf.navigator.menu.PermissionsAdapter;
import net.sf.navigator.menu.RolesPermissionsAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UseMenuDisplayerTag
extends TagSupport {
    private static Log log = LogFactory.getLog((Class)(class$net$sf$navigator$taglib$UseMenuDisplayerTag == null ? (class$net$sf$navigator$taglib$UseMenuDisplayerTag = UseMenuDisplayerTag.class$("net.sf.navigator.taglib.UseMenuDisplayerTag")) : class$net$sf$navigator$taglib$UseMenuDisplayerTag));
    protected static final String PRIVATE_REPOSITORY = "net.sf.navigator.repositoryKey";
    public static final String DISPLAYER_KEY = "net.sf.navigator.taglib.DISPLAYER";
    public static final String ROLES_ADAPTER = "rolesAdapter";
    protected static ResourceBundle messages = ResourceBundle.getBundle("net.sf.navigator.taglib.LocalStrings");
    protected MenuDisplayer menuDisplayer;
    protected String localeKey;
    protected String name;
    protected String bundleKey;
    private String config = "net.sf.navigator.displayer.DisplayerStrings";
    private String permissions;
    private String repository;
    protected ResourceBundle rb;
    static /* synthetic */ Class class$net$sf$navigator$taglib$UseMenuDisplayerTag;

    public String getBundle() {
        return this.bundleKey;
    }

    public void setBundle(String bundle) {
        this.bundleKey = bundle;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setting config to: " + config));
        }
        this.config = config;
    }

    public String getLocale() {
        return this.localeKey;
    }

    public void setLocale(String locale) {
        this.localeKey = locale;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public int doStartTag() throws JspException {
        MenuRepository rep;
        if (this.repository == null) {
            this.repository = "net.sf.navigator.menu.MENU_REPOSITORY";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking for repository named '" + this.repository + "'"));
        }
        if ((rep = (MenuRepository)this.pageContext.findAttribute(this.repository)) == null) {
            throw new JspException(messages.getString("menurepository.not.found"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"stuffing repository into pageContext...");
        }
        this.pageContext.setAttribute(PRIVATE_REPOSITORY, (Object)rep);
        MenuDisplayerMapping displayerMapping = rep.getMenuDisplayerMapping(this.name);
        if (displayerMapping == null) {
            throw new JspException(messages.getString("displayer.mapping.not.found"));
        }
        PermissionsAdapter permissions = this.getPermissionsAdapter();
        MenuDisplayer displayerInstance = null;
        try {
            this.menuDisplayer = displayerInstance = (MenuDisplayer)Class.forName(displayerMapping.getType()).newInstance();
            if (displayerMapping.getConfig() != null) {
                this.setConfig(displayerMapping.getConfig());
            }
        }
        catch (Exception e) {
            throw new JspException(e.getMessage());
        }
        if (this.bundleKey == null) {
            this.bundleKey = "org.apache.struts.action.MESSAGE";
        }
        if (this.bundleKey != null && !"".equals(this.bundleKey) && displayerInstance instanceof MessageResourcesMenuDisplayer) {
            MessageResourcesMenuDisplayer mrDisplayerInstance = (MessageResourcesMenuDisplayer)displayerInstance;
            Locale locale = null;
            if (this.localeKey == null) {
                locale = (Locale)this.pageContext.findAttribute("org.apache.struts.action.LOCALE");
                if (locale == null) {
                    locale = this.pageContext.getRequest().getLocale();
                }
            } else {
                locale = (Locale)this.pageContext.findAttribute(this.localeKey);
            }
            mrDisplayerInstance.setLocale(locale);
            if (this.rb != null) {
                mrDisplayerInstance.setMessageResources(this.rb);
            } else {
                Object resources = this.pageContext.findAttribute(this.bundleKey);
                if (resources == null) {
                    try {
                        this.rb = ResourceBundle.getBundle(this.bundleKey, locale);
                        mrDisplayerInstance.setMessageResources(this.rb);
                    }
                    catch (MissingResourceException mre) {
                        log.error((Object)mre.getMessage());
                    }
                } else {
                    mrDisplayerInstance.setMessageResources(resources);
                }
            }
        }
        displayerInstance.setConfig(this.config);
        displayerInstance.init(this.pageContext, displayerMapping);
        displayerInstance.setPermissionsAdapter(permissions);
        this.pageContext.setAttribute(DISPLAYER_KEY, (Object)displayerInstance);
        return 1;
    }

    protected PermissionsAdapter getPermissionsAdapter() throws JspException {
        PermissionsAdapter adapter = null;
        if (this.permissions != null) {
            if (this.permissions.equalsIgnoreCase(ROLES_ADAPTER)) {
                adapter = new RolesPermissionsAdapter((HttpServletRequest)this.pageContext.getRequest());
            } else {
                adapter = (PermissionsAdapter)this.pageContext.findAttribute(this.permissions);
                if (adapter == null) {
                    throw new JspException(messages.getString("permissions.not.found"));
                }
            }
        }
        return adapter;
    }

    public int doEndTag() throws JspException {
        this.menuDisplayer.end(this.pageContext);
        this.pageContext.removeAttribute(DISPLAYER_KEY);
        this.pageContext.removeAttribute(PRIVATE_REPOSITORY);
        return 6;
    }

    public void release() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"release() called");
        }
        this.menuDisplayer = null;
        this.bundleKey = null;
        this.config = "net.sf.navigator.displayer.DisplayerStrings";
        this.localeKey = null;
        this.name = null;
        this.menuDisplayer = null;
        this.repository = null;
        this.permissions = null;
        this.rb = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

