/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.http.server.security.PrincipalUtil;
import org.jboss.as.domain.http.server.security.SubjectHttpPrincipal;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.Authenticator;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpPrincipal;
import org.jboss.com.sun.net.httpserver.HttpsExchange;
import org.jboss.sasl.callback.VerifyPasswordCallback;

public class BasicAuthenticator
extends org.jboss.com.sun.net.httpserver.BasicAuthenticator {
    private final SecurityRealm securityRealm;
    private final boolean verifyPasswordCallback;
    private final ThreadLocal<AuthorizingCallbackHandler> callbackHandler = new ThreadLocal();

    public BasicAuthenticator(SecurityRealm realm) {
        super(realm.getName());
        this.securityRealm = realm;
        Map mechanismConfig = this.securityRealm.getMechanismConfig(AuthenticationMechanism.PLAIN);
        this.verifyPasswordCallback = mechanismConfig.containsKey("org.jboss.as.domain.management.verify_password_callback_supported") ? Boolean.parseBoolean((String)mechanismConfig.get("org.jboss.as.domain.management.verify_password_callback_supported")) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authenticator.Result authenticate(HttpExchange httpExchange) {
        this.callbackHandler.set(this.securityRealm.getAuthorizingCallbackHandler(AuthenticationMechanism.PLAIN));
        try {
            Authenticator.Result result = this._authenticate(httpExchange);
            return result;
        }
        finally {
            this.callbackHandler.set(null);
        }
    }

    private Authenticator.Result _authenticate(HttpExchange httpExchange) {
        HttpsExchange httpsExch;
        SSLSession session;
        Authenticator.Result response = null;
        if (httpExchange instanceof HttpsExchange && (session = (httpsExch = (HttpsExchange)httpExchange).getSSLSession()) != null) {
            try {
                Principal p = session.getPeerPrincipal();
                response = new Authenticator.Success((HttpPrincipal)new SubjectHttpPrincipal(p.getName(), this.realm));
            }
            catch (SSLPeerUnverifiedException e) {
                // empty catch block
            }
        }
        if (response == null) {
            response = super.authenticate(httpExchange);
        }
        if (response instanceof Authenticator.Success) {
            HttpPrincipal existingPrincipal = ((Authenticator.Success)response).getPrincipal();
            SubjectHttpPrincipal replacementPrincipal = new SubjectHttpPrincipal(existingPrincipal.getName(), existingPrincipal.getName());
            try {
                HashSet<HttpPrincipal> principalCol = new HashSet<HttpPrincipal>();
                principalCol.add(existingPrincipal);
                SubjectUserInfo userInfo = this.callbackHandler.get().createSubjectUserInfo(principalCol);
                Subject subject = userInfo.getSubject();
                PrincipalUtil.addInetPrincipal(httpExchange, subject.getPrincipals());
                replacementPrincipal.setSubject(subject);
                return new Authenticator.Success((HttpPrincipal)replacementPrincipal);
            }
            catch (IOException e) {
                HttpServerLogger.ROOT_LOGGER.debug("Unable to create SubjectUserInfo", e);
                response = new Authenticator.Failure(500);
            }
        }
        return response;
    }

    public boolean checkCredentials(String username, String password) {
        NameCallback ncb = new NameCallback("Username", username);
        Object passwordCallback = this.verifyPasswordCallback ? new VerifyPasswordCallback(password) : new PasswordCallback("Password", false);
        Callback[] callbacks = new Callback[]{ncb, passwordCallback};
        try {
            this.callbackHandler.get().handle(callbacks);
        }
        catch (IOException e) {
            HttpServerLogger.ROOT_LOGGER.debug("Callback handle failed.", e);
            return false;
        }
        catch (UnsupportedCallbackException e) {
            throw HttpServerMessages.MESSAGES.callbackRejected(e);
        }
        if (this.verifyPasswordCallback) {
            return passwordCallback.isVerified();
        }
        char[] expectedPassword = ((PasswordCallback)passwordCallback).getPassword();
        return Arrays.equals(password.toCharArray(), expectedPassword);
    }

    public static boolean requiredCallbacksSupported(Class<Callback>[] callbacks) {
        if (!BasicAuthenticator.contains(NameCallback.class, callbacks)) {
            return false;
        }
        return BasicAuthenticator.contains(PasswordCallback.class, callbacks) || BasicAuthenticator.contains(VerifyPasswordCallback.class, callbacks);
    }

    private static boolean contains(Class clazz, Class<Callback>[] classes) {
        for (Class<Callback> current : classes) {
            if (!current.equals(clazz)) continue;
            return true;
        }
        return false;
    }
}

