/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.database.ConnectionPoolingSupport;
import org.rhq.plugins.database.DatabaseComponent;

public class DatabasePluginUtil {
    private static final Log LOG = LogFactory.getLog(DatabasePluginUtil.class);

    public static boolean canProvideConnection(ResourceComponent component) {
        return DatabasePluginUtil.hasConnectionPoolingSupport(component) || component instanceof DatabaseComponent;
    }

    public static boolean hasConnectionPoolingSupport(ResourceComponent component) {
        if (component instanceof ConnectionPoolingSupport) {
            return ((ConnectionPoolingSupport)component).supportsConnectionPooling();
        }
        return false;
    }

    public static Connection getConnectionFromComponent(ResourceComponent component) throws SQLException {
        if (DatabasePluginUtil.hasConnectionPoolingSupport(component)) {
            return DatabasePluginUtil.getConnectionFromPool((ConnectionPoolingSupport)component);
        }
        if (component instanceof DatabaseComponent) {
            return DatabasePluginUtil.getConnectionFromDatabaseComponent((DatabaseComponent)component);
        }
        throw new ComponentCannotProvideConnectionException(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Double> getNumericQueryValues(ResourceComponent component, String query, Object ... parameters) {
        HashMap<String, Double> hashMap;
        boolean componentHasConnectionPoolingSupport = DatabasePluginUtil.hasConnectionPoolingSupport(component);
        DatabasePluginUtil.checkComponent(component, componentHasConnectionPoolingSupport);
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DatabasePluginUtil.getConnection0(component, componentHasConnectionPoolingSupport);
            statement = connection.prepareStatement(query);
            DatabasePluginUtil.bindParameters(statement, parameters);
            resultSet = statement.executeQuery();
            HashMap<String, Double> row = new HashMap<String, Double>();
            ResultSetMetaData md = resultSet.getMetaData();
            String[] names = DatabasePluginUtil.getColumns(md);
            if (resultSet.next()) {
                for (String name : names) {
                    try {
                        row.put(name, resultSet.getDouble(name));
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            hashMap = row;
        }
        catch (SQLException e) {
            block8: {
                try {
                    LOG.debug((Object)"Unable to read value", (Throwable)e);
                    if (componentHasConnectionPoolingSupport) break block8;
                    ((DatabaseComponent)component).removeConnection();
                }
                catch (Throwable throwable) {
                    DatabasePluginUtil.safeClose(null, statement, resultSet);
                    if (!componentHasConnectionPoolingSupport) throw throwable;
                    DatabasePluginUtil.safeClose(connection);
                    throw throwable;
                }
            }
            DatabasePluginUtil.safeClose(null, statement, resultSet);
            if (!componentHasConnectionPoolingSupport) return Collections.emptyMap();
            DatabasePluginUtil.safeClose(connection);
            return Collections.emptyMap();
        }
        DatabasePluginUtil.safeClose(null, statement, resultSet);
        if (!componentHasConnectionPoolingSupport) return hashMap;
        DatabasePluginUtil.safeClose(connection);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Double> getNumericQueryValueMap(ResourceComponent component, String query, Object ... parameters) {
        HashMap<String, Double> hashMap;
        boolean componentHasConnectionPoolingSupport = DatabasePluginUtil.hasConnectionPoolingSupport(component);
        DatabasePluginUtil.checkComponent(component, componentHasConnectionPoolingSupport);
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DatabasePluginUtil.getConnection0(component, componentHasConnectionPoolingSupport);
            statement = connection.prepareStatement(query);
            DatabasePluginUtil.bindParameters(statement, parameters);
            resultSet = statement.executeQuery();
            HashMap<String, Double> map = new HashMap<String, Double>();
            while (resultSet.next()) {
                try {
                    map.put(resultSet.getString(1), resultSet.getDouble(2));
                }
                catch (SQLException e) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("A query column value is not a double, ignoring:" + ThrowableUtil.getAllMessages((Throwable)e)));
                }
            }
            hashMap = map;
        }
        catch (SQLException e) {
            block7: {
                try {
                    LOG.info((Object)"Unable to read value", (Throwable)e);
                    if (componentHasConnectionPoolingSupport) break block7;
                    ((DatabaseComponent)component).removeConnection();
                }
                catch (Throwable throwable) {
                    DatabasePluginUtil.safeClose(null, statement, resultSet);
                    if (!componentHasConnectionPoolingSupport) throw throwable;
                    DatabasePluginUtil.safeClose(connection);
                    throw throwable;
                }
            }
            DatabasePluginUtil.safeClose(null, statement, resultSet);
            if (!componentHasConnectionPoolingSupport) return Collections.emptyMap();
            DatabasePluginUtil.safeClose(connection);
            return Collections.emptyMap();
        }
        DatabasePluginUtil.safeClose(null, statement, resultSet);
        if (!componentHasConnectionPoolingSupport) return hashMap;
        DatabasePluginUtil.safeClose(connection);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double getSingleNumericQueryValue(ResourceComponent component, String query, Object ... parameters) {
        ResultSet resultSet;
        PreparedStatement statement;
        Connection connection;
        boolean componentHasConnectionPoolingSupport;
        block8: {
            Double d;
            componentHasConnectionPoolingSupport = DatabasePluginUtil.hasConnectionPoolingSupport(component);
            DatabasePluginUtil.checkComponent(component, componentHasConnectionPoolingSupport);
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = DatabasePluginUtil.getConnection0(component, componentHasConnectionPoolingSupport);
                statement = connection.prepareStatement(query);
                DatabasePluginUtil.bindParameters(statement, parameters);
                resultSet = statement.executeQuery();
                if (!resultSet.next()) break block8;
                d = resultSet.getDouble(1);
            }
            catch (SQLException e) {
                block9: {
                    try {
                        if (componentHasConnectionPoolingSupport) break block9;
                        ((DatabaseComponent)component).removeConnection();
                    }
                    catch (Throwable throwable) {
                        DatabasePluginUtil.safeClose(null, statement, resultSet);
                        if (componentHasConnectionPoolingSupport) {
                            DatabasePluginUtil.safeClose(connection);
                        }
                        throw throwable;
                    }
                }
                DatabasePluginUtil.safeClose(null, statement, resultSet);
                if (componentHasConnectionPoolingSupport) {
                    DatabasePluginUtil.safeClose(connection);
                }
            }
            DatabasePluginUtil.safeClose(null, statement, resultSet);
            if (componentHasConnectionPoolingSupport) {
                DatabasePluginUtil.safeClose(connection);
            }
            return d;
        }
        DatabasePluginUtil.safeClose(null, statement, resultSet);
        if (componentHasConnectionPoolingSupport) {
            DatabasePluginUtil.safeClose(connection);
        }
        return Double.NaN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> getGridValues(ResourceComponent component, String query, Object ... parameters) throws SQLException {
        boolean componentHasConnectionPoolingSupport = DatabasePluginUtil.hasConnectionPoolingSupport(component);
        DatabasePluginUtil.checkComponent(component, componentHasConnectionPoolingSupport);
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
        try {
            connection = DatabasePluginUtil.getConnection0(component, componentHasConnectionPoolingSupport);
            statement = connection.prepareStatement(query);
            DatabasePluginUtil.bindParameters(statement, parameters);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String[] names;
                HashMap<String, Object> row = new HashMap<String, Object>();
                l.add(row);
                ResultSetMetaData md = resultSet.getMetaData();
                for (String name : names = DatabasePluginUtil.getColumns(md)) {
                    Object o = resultSet.getObject(name);
                    row.put(name, o);
                }
            }
        }
        catch (Throwable throwable) {
            DatabasePluginUtil.safeClose(null, statement, resultSet);
            if (componentHasConnectionPoolingSupport) {
                DatabasePluginUtil.safeClose(connection);
            }
            throw throwable;
        }
        DatabasePluginUtil.safeClose(null, statement, resultSet);
        if (componentHasConnectionPoolingSupport) {
            DatabasePluginUtil.safeClose(connection);
        }
        return l;
    }

    public static void safeClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void safeClose(Connection connection, Statement statement) {
        DatabasePluginUtil.safeClose(statement);
        DatabasePluginUtil.safeClose(connection);
    }

    public static void safeClose(Connection connection, Statement statement, ResultSet resultSet) {
        DatabasePluginUtil.safeClose(resultSet);
        DatabasePluginUtil.safeClose(statement);
        DatabasePluginUtil.safeClose(connection);
    }

    public static void safeClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void safeClose(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void checkComponent(ResourceComponent component, boolean componentHasConnectionPoolingSupport) {
        if (!componentHasConnectionPoolingSupport && !(component instanceof DatabaseComponent)) {
            throw new ComponentCannotProvideConnectionException(component);
        }
    }

    private static Connection getConnection0(ResourceComponent component, boolean componentHasConnectionPoolingSupport) throws SQLException {
        return componentHasConnectionPoolingSupport ? DatabasePluginUtil.getConnectionFromPool((ConnectionPoolingSupport)component) : DatabasePluginUtil.getConnectionFromDatabaseComponent((DatabaseComponent)component);
    }

    private static Connection getConnectionFromPool(ConnectionPoolingSupport component) throws SQLException {
        return component.getPooledConnectionProvider().getPooledConnection();
    }

    private static Connection getConnectionFromDatabaseComponent(DatabaseComponent component) {
        return component.getConnection();
    }

    private static void bindParameters(PreparedStatement statement, Object ... parameters) throws SQLException {
        int i = 1;
        for (Object p : parameters) {
            if (p instanceof String) {
                statement.setString(i++, (String)p);
                continue;
            }
            if (p instanceof Byte) {
                statement.setByte(i++, (Byte)p);
                continue;
            }
            if (p instanceof Short) {
                statement.setShort(i++, (Short)p);
                continue;
            }
            if (p instanceof Integer) {
                statement.setInt(i++, (Integer)p);
                continue;
            }
            if (p instanceof Long) {
                statement.setLong(i++, (Long)p);
                continue;
            }
            if (p instanceof Float) {
                statement.setFloat(i++, ((Float)p).floatValue());
                continue;
            }
            if (p instanceof Double) {
                statement.setDouble(i++, (Double)p);
                continue;
            }
            statement.setObject(i++, p);
        }
    }

    private static String[] getColumns(ResultSetMetaData rsmd) throws SQLException {
        String[] names = new String[rsmd.getColumnCount()];
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            names[i] = rsmd.getColumnName(i + 1);
        }
        return names;
    }

    private DatabasePluginUtil() {
    }

    public static final class ComponentCannotProvideConnectionException
    extends IllegalArgumentException {
        private final ResourceComponent component;

        public ComponentCannotProvideConnectionException(ResourceComponent component) {
            super(component + " cannot provide a JDBC Connection");
            this.component = component;
        }

        public ResourceComponent getComponent() {
            return this.component;
        }
    }
}

