/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CachedOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final File DEFAULT_TEMP_DIR;
    private static int defaultThreshold;
    private static long defaultMaxSize;
    protected boolean outputLocked;
    protected OutputStream currentStream;
    private long threshold = defaultThreshold;
    private long maxSize = defaultMaxSize;
    private long totalLength;
    private boolean inmem;
    private boolean tempFileFailed;
    private File tempFile;
    private File outputDir = DEFAULT_TEMP_DIR;
    private boolean allowDeleteOfFile = true;
    private List<Object> streamList = new ArrayList<Object>();

    public CachedOutputStream(PipedInputStream stream) throws IOException {
        this.currentStream = new PipedOutputStream(stream);
        this.inmem = true;
    }

    public CachedOutputStream() {
        this.currentStream = new LoadingByteArrayOutputStream(2048);
        this.inmem = true;
    }

    public CachedOutputStream(long threshold) {
        this.threshold = threshold;
        this.currentStream = new LoadingByteArrayOutputStream(2048);
        this.inmem = true;
    }

    public void holdTempFile() {
        this.allowDeleteOfFile = false;
    }

    public void releaseTempFileHold() {
        this.allowDeleteOfFile = true;
    }

    @Override
    public void flush() throws IOException {
        this.currentStream.flush();
    }

    public void lockOutputStream() throws IOException {
        if (this.outputLocked) {
            return;
        }
        this.currentStream.flush();
        this.outputLocked = true;
        this.streamList.remove(this.currentStream);
    }

    @Override
    public void close() throws IOException {
        this.currentStream.flush();
        this.outputLocked = true;
        this.currentStream.close();
        this.maybeDeleteTempFile(this.currentStream);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CachedOutputStream) {
            return this.currentStream.equals(((CachedOutputStream)obj).currentStream);
        }
        return this.currentStream.equals(obj);
    }

    public long size() {
        return this.totalLength;
    }

    public byte[] getBytes() throws IOException {
        this.flush();
        if (this.inmem) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return ((ByteArrayOutputStream)this.currentStream).toByteArray();
            }
            throw new IOException("Unknown format of currentStream");
        }
        FileInputStream fin = new FileInputStream(this.tempFile);
        return CachedOutputStream.readBytesFromStream(fin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(StringBuilder out, String charsetName) throws IOException {
        this.flush();
        if (this.inmem) {
            if (!(this.currentStream instanceof ByteArrayOutputStream)) throw new IOException("Unknown format of currentStream");
            byte[] bytes = ((ByteArrayOutputStream)this.currentStream).toByteArray();
            out.append(new String(bytes, charsetName));
            return;
        }
        FileInputStream fin = new FileInputStream(this.tempFile);
        byte[] bytes = new byte[1024];
        try {
            int x = fin.read(bytes);
            while (x != -1) {
                out.append(new String(bytes, 0, x, charsetName));
                x = fin.read(bytes);
            }
            return;
        }
        finally {
            fin.close();
        }
    }

    public OutputStream getOut() {
        return this.currentStream;
    }

    public int hashCode() {
        return this.currentStream.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("[").append(CachedOutputStream.class.getName()).append(" Content: ");
        try {
            this.writeCacheTo(builder, "UTF-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.append("]").toString();
    }

    protected void onWrite() throws IOException {
    }

    private void enforceLimits() throws IOException {
        if (this.maxSize > 0L && this.totalLength > this.maxSize) {
            throw new IOException();
        }
        if (this.inmem && this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
            this.createFileOutputStream();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            this.totalLength += (long)len;
            this.enforceLimits();
            this.currentStream.write(b, off, len);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            this.totalLength += (long)b.length;
            this.enforceLimits();
            this.currentStream.write(b);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            ++this.totalLength;
            this.enforceLimits();
            this.currentStream.write(b);
        }
    }

    private void createFileOutputStream() throws IOException {
        if (this.tempFileFailed) {
            return;
        }
        ByteArrayOutputStream bout = (ByteArrayOutputStream)this.currentStream;
        try {
            this.tempFile = File.createTempFile("jbossws-cached-output-stream-", ".tmp", this.outputDir);
            this.currentStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
            bout.writeTo(this.currentStream);
            this.inmem = false;
            this.streamList.add(this.currentStream);
        }
        catch (Exception ex) {
            this.tempFileFailed = true;
            if (this.currentStream != bout) {
                this.currentStream.close();
            }
            this.deleteTempFile();
            this.inmem = true;
            this.currentStream = bout;
        }
    }

    public File getTempFile() {
        return this.tempFile != null && this.tempFile.exists() ? this.tempFile : null;
    }

    public InputStream getInputStream() throws IOException {
        this.flush();
        if (this.inmem) {
            if (this.currentStream instanceof LoadingByteArrayOutputStream) {
                return ((LoadingByteArrayOutputStream)this.currentStream).createInputStream();
            }
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return new ByteArrayInputStream(((ByteArrayOutputStream)this.currentStream).toByteArray());
            }
            if (this.currentStream instanceof PipedOutputStream) {
                return new PipedInputStream((PipedOutputStream)this.currentStream);
            }
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.tempFile){
                boolean closed;

                @Override
                public void close() throws IOException {
                    if (!this.closed) {
                        super.close();
                        CachedOutputStream.this.maybeDeleteTempFile(this);
                    }
                    this.closed = true;
                }
            };
            this.streamList.add(fileInputStream);
            return fileInputStream;
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cached file was deleted, " + e.toString());
        }
    }

    private synchronized void deleteTempFile() {
        if (this.tempFile != null) {
            File file = this.tempFile;
            this.tempFile = null;
            CachedOutputStream.delete(file);
        }
    }

    private void maybeDeleteTempFile(Object stream) {
        this.streamList.remove(stream);
        if (!this.inmem && this.tempFile != null && this.streamList.isEmpty() && this.allowDeleteOfFile) {
            if (this.currentStream != null) {
                try {
                    this.currentStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.deleteTempFile();
            this.currentStream = new LoadingByteArrayOutputStream(1024);
            this.inmem = true;
        }
    }

    public void setOutputDir(File outputDir) throws IOException {
        this.outputDir = outputDir;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public static void setDefaultMaxSize(long l) {
        defaultMaxSize = l;
    }

    public static void setDefaultThreshold(int i) {
        if (i < 0) {
            i = 65536;
        }
        defaultThreshold = i;
    }

    private static byte[] readBytesFromStream(InputStream in) throws IOException {
        int i = in.available();
        if (i < 4096) {
            i = 4096;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(i);
        CachedOutputStream.copy(in, bos, 4096);
        in.close();
        return bos.toByteArray();
    }

    private static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int avail = input.available();
        if (avail > 262144) {
            avail = 262144;
        }
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            if (n == 0) {
                throw new IOException("0 bytes read in violation of InputStream.read(byte[])");
            }
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        return total;
    }

    private static void delete(File f) {
        if (!f.delete()) {
            if (CachedOutputStream.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
    }

    private static boolean isWindows() {
        String osName = CachedOutputStream.getSystemProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    private static String getSystemProperty(final String name) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        };
        return AccessController.doPrivileged(action);
    }

    static {
        File f;
        String s = CachedOutputStream.getSystemProperty("java.io.tmpdir");
        DEFAULT_TEMP_DIR = s != null ? ((f = new File(s)).exists() && f.isDirectory() ? f : null) : null;
        CachedOutputStream.setDefaultThreshold(-1);
        CachedOutputStream.setDefaultMaxSize(-1L);
    }

    private static class LoadingByteArrayOutputStream
    extends ByteArrayOutputStream {
        public LoadingByteArrayOutputStream(int i) {
            super(i);
        }

        public ByteArrayInputStream createInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count){

                public String toString() {
                    return new String(this.buf, 0, this.count);
                }
            };
        }

        @Override
        public byte[] toByteArray() {
            if (this.count != this.buf.length) {
                this.buf = super.toByteArray();
            }
            return this.buf;
        }
    }
}

