/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.ServiceLoader;
import org.jboss.ws.common.IOUtils;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.BundleUtils;
import org.jboss.ws.core.soap.EnvelopeBuilder;
import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.SOAPPartImpl;
import org.jboss.ws.core.soap.attachment.MultipartRelatedDecoder;
import org.jboss.ws.core.soap.utils.MessageContextAssociation;
import org.jboss.ws.core.soap.utils.Style;

public class MessageFactoryImpl
extends MessageFactory {
    private static final ResourceBundle bundle = BundleUtils.getBundle(MessageFactoryImpl.class);
    private static Logger log = Logger.getLogger(MessageFactoryImpl.class);
    private String envNamespace;
    private Style style;
    private boolean dynamic;

    public MessageFactoryImpl() {
        this.envNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
    }

    public MessageFactoryImpl(String protocol) throws SOAPException {
        if ("SOAP 1.1 Protocol".equals(protocol) || "SOAP 1.1 Protocol".equals(protocol)) {
            this.envNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
        } else if ("SOAP 1.2 Protocol".equals(protocol)) {
            this.envNamespace = "http://www.w3.org/2003/05/soap-envelope";
        } else if ("Dynamic Protocol".equals(protocol)) {
            this.dynamic = true;
        } else {
            throw new SOAPException(BundleUtils.getMessage(bundle, "UNKNOWN_PROTOCOL", protocol));
        }
    }

    public String getEnvNamespace() {
        return this.envNamespace;
    }

    public void setEnvNamespace(String envelopeURI) {
        this.envNamespace = envelopeURI;
    }

    public Style getStyle() {
        if (this.style == null) {
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext != null && msgContext.getOperationMetaData() != null) {
                this.style = msgContext.getOperationMetaData().getStyle();
            }
            log.trace((Object)("Using style: " + this.style));
        }
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public SOAPMessage createMessage() throws SOAPException {
        if (this.dynamic) {
            throw new UnsupportedOperationException(BundleUtils.getMessage(bundle, "CANNOT_CREATE_DEFAULT_MESSAGE", new Object[0]));
        }
        SOAPMessageImpl soapMessage = new SOAPMessageImpl();
        SOAPPartImpl soapPart = (SOAPPartImpl)soapMessage.getSOAPPart();
        new SOAPEnvelopeImpl(soapPart, this.envNamespace, true);
        return soapMessage;
    }

    public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream ins) throws IOException, SOAPException {
        return this.createMessage(mimeHeaders, ins, false);
    }

    public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream inputStream, boolean ignoreParseError) throws IOException, SOAPException {
        if (mimeHeaders == null) {
            mimeHeaders = new MimeHeaders();
        } else if (log.isTraceEnabled()) {
            Iterator itMimeHeaders = mimeHeaders.getAllHeaders();
            while (itMimeHeaders.hasNext()) {
                MimeHeader mh = (MimeHeader)itMimeHeaders.next();
                log.trace((Object)mh);
            }
        }
        ContentType contentType = MessageFactoryImpl.getContentType(mimeHeaders);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createMessage: [contentType=" + contentType + "]"));
        }
        SOAPMessageImpl soapMessage = new SOAPMessageImpl();
        String encoding = contentType.getParameterList().get("charset");
        if (encoding != null) {
            soapMessage.setProperty("javax.xml.soap.character-set-encoding", encoding);
        }
        if (inputStream != null) {
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                IOUtils.copyStream((OutputStream)baos, (InputStream)inputStream);
                byte[] bytes = baos.toByteArray();
                log.trace((Object)("createMessage\n" + new String(bytes)));
                inputStream = new ByteArrayInputStream(bytes);
            }
            Collection<AttachmentPart> attachments = null;
            if (this.isMultipartRelatedContent(contentType)) {
                MultipartRelatedDecoder decoder;
                try {
                    decoder = new MultipartRelatedDecoder(contentType);
                    decoder.decodeMultipartRelatedMessage(inputStream);
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new SOAPException(BundleUtils.getMessage(bundle, "CANNOT_DECODE_MULTIPART_RELATED_MESSAGE", new Object[0]), (Throwable)ex);
                }
                inputStream = decoder.getRootPart().getDataHandler().getInputStream();
                attachments = decoder.getRelatedParts();
            } else if (!this.isSoapContent(contentType)) {
                throw new SOAPException(BundleUtils.getMessage(bundle, "UNSUPPORTED_CONTENT_TYPE", contentType));
            }
            if (mimeHeaders != null) {
                soapMessage.setMimeHeaders(mimeHeaders);
            }
            if (attachments != null) {
                soapMessage.setAttachments(attachments);
            }
            EnvelopeBuilder envBuilder = (EnvelopeBuilder)ServiceLoader.loadService((String)EnvelopeBuilder.class.getName(), null, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            if (inputStream.markSupported()) {
                inputStream.mark(1);
                int bytesRead = inputStream.read(new byte[1]);
                inputStream.reset();
                if (bytesRead == -1) {
                    return soapMessage;
                }
            }
            envBuilder.setStyle(this.getStyle());
            envBuilder.build((SOAPMessage)soapMessage, inputStream, ignoreParseError);
        }
        return soapMessage;
    }

    private static ContentType getContentType(MimeHeaders headers) throws SOAPException {
        ContentType contentType = null;
        try {
            String[] type = headers.getHeader("Content-Type");
            contentType = type != null ? new ContentType(type[0]) : new ContentType("text/xml");
            return contentType;
        }
        catch (ParseException e) {
            throw new SOAPException(BundleUtils.getMessage(bundle, "COULD_NOT_PARSE_CONTENT_TYPE", new Object[]{e}));
        }
    }

    private boolean isSoapContent(ContentType type) {
        String baseType = type.getBaseType();
        return "text/xml".equalsIgnoreCase(baseType) || "application/soap+xml".equalsIgnoreCase(baseType);
    }

    private boolean isMultipartRelatedContent(ContentType type) {
        String baseType = type.getBaseType();
        return "multipart/related".equalsIgnoreCase(baseType);
    }
}

