/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client.serviceref;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeLoggers;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.core.jaxrpc.client.ServiceExt;
import org.jboss.ws.core.jaxrpc.client.ServiceImpl;
import org.jboss.ws.core.jaxrpc.client.ServiceProxy;
import org.jboss.ws.core.jaxrpc.client.serviceref.SecurityActions;
import org.jboss.ws.core.server.PortComponentResolver;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.management.EndpointResolver;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public final class NativeServiceObjectFactoryJAXRPC {
    private static final Logger log = Logger.getLogger(NativeServiceObjectFactoryJAXRPC.class);

    public Object getObjectInstance(UnifiedServiceRefMetaData serviceRef) {
        try {
            ServiceImpl jaxrpcService = null;
            URL wsdlLocation = serviceRef.getWsdlLocation();
            if (wsdlLocation != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Create jaxrpc service from wsdl");
                }
                QName serviceName = serviceRef.getServiceQName();
                JavaWsdlMapping javaWsdlMapping = this.getJavaWsdlMapping(serviceRef);
                jaxrpcService = new ServiceImpl(serviceName, wsdlLocation, javaWsdlMapping, serviceRef);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Create jaxrpc service with no wsdl");
                }
                jaxrpcService = new ServiceImpl(new QName("http://www.jboss.org/jbossws", "AnonymousService"));
            }
            ServiceMetaData serviceMetaData = jaxrpcService.getServiceMetaData();
            String pcLink = this.getPortComponentLink(serviceRef);
            if (pcLink != null) {
                log.debug((Object)("Resolving port-component-link: " + pcLink));
                String endpointAddress = null;
                try {
                    SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
                    EndpointRegistry epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
                    Endpoint endpoint = epRegistry.resolve((EndpointResolver)new PortComponentResolver(pcLink));
                    if (endpoint == null) {
                        throw NativeMessages.MESSAGES.cannotResolvePortComponentLink(pcLink);
                    }
                    ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class);
                    endpointAddress = sepMetaData.getEndpointAddress();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                if (endpointAddress == null) {
                    String servletPath = this.getPortComponentLinkServlet();
                    servletPath = servletPath + "?pcLink=" + URLEncoder.encode(pcLink, "UTF-8");
                    InputStream is = new URL(servletPath).openStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    endpointAddress = br.readLine();
                    br.close();
                    is.close();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved to: " + endpointAddress));
                }
                if (serviceMetaData.getEndpoints().size() == 1) {
                    EndpointMetaData epMetaData = serviceMetaData.getEndpoints().get(0);
                    epMetaData.setEndpointAddress(endpointAddress);
                } else {
                    NativeLoggers.JAXRPC_LOGGER.cannotSetEndpointAddressForPCL();
                }
            }
            this.narrowPortSelection(serviceRef, serviceMetaData);
            ClassLoader contextCL = SecurityActions.getContextClassLoader();
            Class<?> siClass = SecurityActions.loadClass(contextCL, serviceRef.getServiceInterface());
            if (!Service.class.isAssignableFrom(siClass)) {
                throw NativeMessages.MESSAGES.interfaceDoesNotImplementJAXRPCService(siClass.getName());
            }
            for (UnifiedPortComponentRefMetaData pcr : serviceRef.getPortComponentRefs()) {
                Class<?> seiClass;
                String seiName = pcr.getServiceEndpointInterface();
                if (seiName == null || Remote.class.isAssignableFrom(seiClass = contextCL.loadClass(seiName))) continue;
                throw new IllegalArgumentException(NativeMessages.MESSAGES.notImplementRemote(seiClass.getName()));
            }
            this.setupHandlerChain(jaxrpcService);
            ServiceProxy handler = new ServiceProxy(jaxrpcService, siClass);
            return Proxy.newProxyInstance(contextCL, new Class[]{siClass, ServiceExt.class}, (InvocationHandler)handler);
        }
        catch (Exception ex) {
            NativeLoggers.JAXRPC_LOGGER.cannotCreateService(ex);
            throw new RuntimeException(ex);
        }
    }

    private String getPortComponentLink(UnifiedServiceRefMetaData refMetaData) {
        Iterator i$ = refMetaData.getPortComponentRefs().iterator();
        if (i$.hasNext()) {
            UnifiedPortComponentRefMetaData pcr = (UnifiedPortComponentRefMetaData)i$.next();
            return pcr.getPortComponentLink();
        }
        return null;
    }

    private String getPortComponentLinkServlet() throws Exception {
        try {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            ServerConfig config = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
            String host = config.getWebServiceHost();
            int port = config.getWebServicePort();
            String servletURL = "http://" + host + ":" + port + "/jbossws/pclink";
            return servletURL;
        }
        catch (Exception ex) {
            throw NativeMessages.MESSAGES.cannotObtainPathToPCLServlet(ex);
        }
    }

    protected void narrowPortSelection(UnifiedServiceRefMetaData serviceRef, ServiceMetaData serviceMetaData) {
        if (serviceMetaData.getEndpoints().size() > 1) {
            HashMap<String, UnifiedPortComponentRefMetaData> pcrefs = new HashMap<String, UnifiedPortComponentRefMetaData>();
            for (UnifiedPortComponentRefMetaData pcref : serviceRef.getPortComponentRefs()) {
                String seiName = pcref.getServiceEndpointInterface();
                if (pcrefs.get(seiName) != null) {
                    throw NativeMessages.MESSAGES.notAllowedToUseInServiceRef(seiName);
                }
                pcrefs.put(seiName, pcref);
            }
            for (String sei : pcrefs.keySet()) {
                ArrayList<QName> narrowedEndpoints = new ArrayList<QName>();
                UnifiedPortComponentRefMetaData pcref = (UnifiedPortComponentRefMetaData)pcrefs.get(sei);
                if (pcref.getServiceEndpointInterface() != null && pcref.getPortQName() != null) {
                    ArrayList<QName> pcRef2EndpointMapping = new ArrayList<QName>();
                    for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                        if (!pcref.getServiceEndpointInterface().equals(epMetaData.getServiceEndpointInterfaceName())) continue;
                        pcRef2EndpointMapping.add(epMetaData.getPortName());
                    }
                    for (QName q : pcRef2EndpointMapping) {
                        EndpointMetaData mappedEndpoint = serviceMetaData.getEndpoint(q);
                        if (pcref.getPortQName().equals(mappedEndpoint.getPortName())) continue;
                        narrowedEndpoints.add(q);
                    }
                    if (pcRef2EndpointMapping.size() > 0 && pcRef2EndpointMapping.size() == narrowedEndpoints.size()) {
                        throw NativeMessages.MESSAGES.failedToNarrowavailableEpsByPcRef();
                    }
                    for (QName q : narrowedEndpoints) {
                        EndpointMetaData removed = serviceMetaData.removeEndpoint(q);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Narrowed endpoint " + q + "(" + removed + ")"));
                    }
                    continue;
                }
                NativeLoggers.JAXRPC_LOGGER.unableToNarrowPortSelection(pcref);
            }
        }
    }

    private void setupHandlerChain(ServiceImpl jaxrpcService) throws Exception {
        List<EndpointMetaData> endpoints = jaxrpcService.getServiceMetaData().getEndpoints();
        for (EndpointMetaData epMetaData : endpoints) {
            jaxrpcService.setupHandlerChain(epMetaData);
        }
    }

    private JavaWsdlMapping getJavaWsdlMapping(UnifiedServiceRefMetaData serviceRef) {
        JavaWsdlMapping javaWsdlMapping = null;
        if (serviceRef.getMappingFile() != null) {
            String mappingFile = serviceRef.getMappingFile();
            try {
                JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
                URL mappingURL = serviceRef.getVfsRoot().findChild(mappingFile).toURL();
                javaWsdlMapping = mappingFactory.parse(mappingURL);
            }
            catch (Exception e) {
                throw NativeMessages.MESSAGES.cannotUnmarshallJAXRPCMapping(mappingFile, e);
            }
        }
        return javaWsdlMapping;
    }
}

