/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.binding.AbstractDeserializerFactory;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.DeserializerSupport;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPArrayDeserializer
extends DeserializerSupport {
    private static final Logger log = Logger.getLogger(SOAPArrayDeserializer.class);
    private DeserializerSupport componentDeserializer;

    @Override
    public Object deserialize(QName xmlName, QName xmlType, Source source, SerializationContext serContext) throws BindingException {
        log.debug((Object)("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        try {
            ParameterMetaData paramMetaData = (ParameterMetaData)serContext.getProperty(ParameterMetaData.class.getName());
            Element soapElement = DOMUtils.sourceToElement((Source)source);
            QName compXmlType = this.getComponentTypeFromAttribute(soapElement);
            paramMetaData.setSOAPArrayCompType(compXmlType);
            if (compXmlType == null) {
                throw NativeMessages.MESSAGES.cannotObtainComponentXmlType(paramMetaData.getPartName());
            }
            Class compJavaType = this.getJavaTypeForComponentType(compXmlType, serContext);
            log.debug((Object)("Get component deserializer for: [javaType=" + compJavaType.getName() + ",xmlType=" + compXmlType + "]"));
            int[] arrDims = this.getDimensionsFromAttribute(soapElement);
            Object[] retArray = (Object[])Array.newInstance(compJavaType, arrDims);
            TypeMappingImpl typeMapping = serContext.getTypeMapping();
            AbstractDeserializerFactory compDeserializerFactory = (AbstractDeserializerFactory)typeMapping.getDeserializer(compJavaType, compXmlType);
            if (compDeserializerFactory == null) {
                compDeserializerFactory = (AbstractDeserializerFactory)typeMapping.getDeserializer(null, compXmlType);
            }
            if (compDeserializerFactory == null) {
                throw NativeMessages.MESSAGES.cannotObtainComponentDeserializerFor(compXmlType);
            }
            this.componentDeserializer = compDeserializerFactory.getDeserializer();
            if (arrDims.length < 1 || 2 < arrDims.length) {
                throw NativeMessages.MESSAGES.unsupportedArrayDimensions(arrDims.length);
            }
            Iterator it = DOMUtils.getChildElements((Node)soapElement);
            if (arrDims.length == 1) {
                Object[] subArr = retArray;
                this.deserializeMemberValues(compXmlType, serContext, it, subArr);
            }
            if (arrDims.length == 2) {
                for (int i = 0; i < arrDims[0]; ++i) {
                    Object[] subArr = (Object[])retArray[i];
                    this.deserializeMemberValues(compXmlType, serContext, it, subArr);
                }
            }
            log.debug((Object)("deserialized: " + retArray.getClass().getName()));
            return retArray;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    private void deserializeMemberValues(QName compXmlType, SerializationContext serContext, Iterator it, Object[] subArr) throws BindingException {
        QName compXmlName = new QName("item");
        int dim = subArr.length;
        for (int i = 0; i < dim; ++i) {
            Object compValue = null;
            if (it.hasNext()) {
                Element childElement = (Element)it.next();
                DOMSource source = new DOMSource(childElement);
                compValue = this.componentDeserializer.deserialize(compXmlName, compXmlType, source, serContext);
                compValue = JavaUtils.getWrapperValueArray((Object)compValue);
            }
            subArr[i] = compValue;
        }
    }

    private int[] getDimensionsFromAttribute(Element arrayElement) {
        QName attrQName = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
        QName arrayType = DOMUtils.getAttributeValueAsQName((Element)arrayElement, (QName)attrQName);
        if (arrayType == null) {
            throw NativeMessages.MESSAGES.cannotObtainAttribute(attrQName);
        }
        String localPart = arrayType.getLocalPart();
        int dimIndex = localPart.indexOf("[");
        String dimStr = localPart.substring(dimIndex);
        StringTokenizer st = new StringTokenizer(dimStr, "[,]");
        int[] arrDims = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            arrDims[i] = new Integer(st.nextToken());
            ++i;
        }
        return arrDims;
    }

    private QName getComponentTypeFromAttribute(Element arrayElement) {
        QName attrQName = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
        QName arrayType = DOMUtils.getAttributeValueAsQName((Element)arrayElement, (QName)attrQName);
        if (arrayType == null) {
            throw NativeMessages.MESSAGES.cannotObtainAttribute(attrQName);
        }
        String nsURI = arrayType.getNamespaceURI();
        String localPart = arrayType.getLocalPart();
        int dimIndex = localPart.indexOf("[");
        QName compXmlType = new QName(nsURI, localPart.substring(0, dimIndex));
        return compXmlType;
    }

    private Class getJavaTypeForComponentType(QName compXmlType, SerializationContext serContext) {
        TypeMappingImpl typeMapping = serContext.getTypeMapping();
        Class javaType = typeMapping.getJavaType(compXmlType);
        if (javaType == null) {
            throw NativeMessages.MESSAGES.cannotObtainAttribute(compXmlType);
        }
        return JavaUtils.getWrapperType((Class)javaType);
    }
}

